/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.ColorBlock;
import net.minecraft.block.BlockBed;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityBed;

public class Bed {
    public static void generate(IWorldEditor editor, Cardinal dir, Coord pos, DyeColor color) {
        TileEntityBed bed;
        Coord cursor = new Coord(pos);
        if (RogueConfig.getBoolean(RogueConfig.FURNITURE)) {
            MetaBlock head = new MetaBlock(Blocks.field_150324_C);
            head.func_177226_a(BlockBed.field_176472_a, BlockBed.EnumPartType.HEAD);
            head.func_177226_a(BlockBed.field_185512_D, dir.getFacing());
            head.set(editor, cursor);
            bed = (TileEntityBed)editor.getTileEntity(cursor);
            bed.func_193052_a(DyeColor.get(color));
        } else {
            ColorBlock.get(ColorBlock.WOOL, DyeColor.WHITE).set(editor, cursor);
        }
        cursor.translate(dir);
        if (RogueConfig.getBoolean(RogueConfig.FURNITURE)) {
            MetaBlock foot = new MetaBlock(Blocks.field_150324_C);
            foot.func_177226_a(BlockBed.field_176472_a, BlockBed.EnumPartType.FOOT);
            foot.func_177226_a(BlockBed.field_185512_D, dir.getFacing());
            foot.set(editor, cursor);
            bed = (TileEntityBed)editor.getTileEntity(cursor);
            bed.func_193052_a(DyeColor.get(color));
        } else {
            ColorBlock.get(ColorBlock.WOOL, DyeColor.RED).set(editor, cursor);
        }
    }

    public static void generate(IWorldEditor editor, Cardinal dir, Coord pos) {
        Bed.generate(editor, dir, pos, DyeColor.RED);
    }
}

