/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import net.minecraft.block.BlockFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class Furnace {
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;

    public static void generate(IWorldEditor editor, Cardinal dir, Coord pos) {
        Furnace.generate(editor, null, false, dir, pos);
    }

    public static void generate(IWorldEditor editor, boolean lit, Cardinal dir, Coord pos) {
        Furnace.generate(editor, null, lit, dir, pos);
    }

    public static void generate(IWorldEditor editor, ItemStack fuel, boolean lit, Cardinal dir, Coord pos) {
        if (!RogueConfig.getBoolean(RogueConfig.FURNITURE)) {
            return;
        }
        MetaBlock furnace = lit ? new MetaBlock(Blocks.field_150470_am) : new MetaBlock(Blocks.field_150460_al);
        furnace.func_177226_a(BlockFurnace.field_176447_a, dir.reverse().getFacing());
        furnace.set(editor, pos);
        if (fuel == null) {
            return;
        }
        TileEntity te = editor.getTileEntity(pos);
        if (te == null) {
            return;
        }
        if (!(te instanceof TileEntityFurnace)) {
            return;
        }
        TileEntityFurnace teFurnace = (TileEntityFurnace)te;
        teFurnace.func_70299_a(1, fuel);
    }
}

