/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import net.minecraft.block.BlockVine;

public class Vine {
    public static void fill(IWorldEditor editor, Coord start, Coord end) {
        for (Coord cursor : new RectSolid(start, end)) {
            Vine.set(editor, cursor);
        }
    }

    public static void set(IWorldEditor editor, Coord origin) {
        if (!editor.isAirBlock(origin)) {
            return;
        }
        MetaBlock vine = BlockType.get(BlockType.VINE);
        for (Cardinal dir : Cardinal.directions) {
            Coord c = new Coord(origin);
            c.translate(dir);
            if (!editor.canPlace(vine, c, dir)) continue;
            Vine.setOrientation(vine, dir).set(editor, c);
            return;
        }
    }

    public static MetaBlock setOrientation(MetaBlock vine, Cardinal dir) {
        vine.func_177226_a(BlockVine.field_176273_b, dir == Cardinal.NORTH);
        vine.func_177226_a(BlockVine.field_176278_M, dir == Cardinal.EAST);
        vine.func_177226_a(BlockVine.field_176279_N, dir == Cardinal.SOUTH);
        vine.func_177226_a(BlockVine.field_176280_O, dir == Cardinal.WEST);
        return vine;
    }
}

