/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.filter;

import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBounded;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.filter.IFilter;
import greymerk.roguelike.worldgen.shapes.Shape;
import java.util.Random;

public class CobwebFilter
implements IFilter {
    @Override
    public void apply(IWorldEditor editor, Random rand, ITheme theme, IBounded box) {
        for (Coord pos : box.getShape(Shape.RECTSOLID)) {
            if (rand.nextInt(60) != 0 || !editor.isAirBlock(pos) || !this.validLocation(editor, pos)) continue;
            this.generate(editor, rand, pos, rand.nextInt(2) + 2);
        }
    }

    private boolean validLocation(IWorldEditor editor, Coord pos) {
        for (Cardinal dir : Cardinal.values()) {
            Coord cursor = new Coord(pos);
            cursor.translate(dir);
            if (editor.isAirBlock(cursor)) continue;
            return true;
        }
        return false;
    }

    private void generate(IWorldEditor editor, Random rand, Coord pos, int count) {
        if (!editor.isAirBlock(pos)) {
            return;
        }
        if (count <= 0) {
            return;
        }
        BlockType.get(BlockType.WEB).set(editor, pos);
        for (int i = 0; i < 2; ++i) {
            Cardinal dir = Cardinal.values()[rand.nextInt(Cardinal.values().length)];
            Coord cursor = new Coord(pos);
            cursor.translate(dir);
            this.generate(editor, rand, cursor, count - 1);
        }
    }
}

