/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SpawnPotential {
    private String name;
    private int weight;
    private boolean equip;
    private NBTTagCompound entityNbt;

    public SpawnPotential(String name, boolean equip, int weight, NBTTagCompound entityNbt) {
        this.name = name;
        this.equip = equip;
        this.weight = weight;
        this.entityNbt = entityNbt;
    }

    public NBTTagList getSpawnPotentials(Random random, int level) {
        NBTTagList potentials = new NBTTagList();
        if (MobType.ZOMBIE.getName().equals(this.name)) {
            IntStream.range(0, 24).forEach(i -> potentials.func_74742_a((NBTBase)this.createZombieSpawnPotentialNbt(random, level)));
        } else if (MobType.SKELETON.getName().equals(this.name)) {
            IntStream.range(0, 12).forEach(i -> potentials.func_74742_a((NBTBase)this.createSkeletonSpawnPotentialNbt(random, level)));
        } else {
            potentials.func_74742_a((NBTBase)this.createSpawnPotentialNbt(level));
        }
        return potentials;
    }

    private NBTTagCompound createZombieSpawnPotentialNbt(Random random, int level) {
        NBTTagCompound zombieEntityNbt = this.createZombieEntityNbt(random, level);
        return this.buildSpawnPotentialNbt(zombieEntityNbt);
    }

    private NBTTagCompound createSkeletonSpawnPotentialNbt(Random random, int level) {
        NBTTagCompound skeletonEntityNbt = this.createSkeletonEntityNbt(random, level);
        return this.buildSpawnPotentialNbt(skeletonEntityNbt);
    }

    private NBTTagCompound createSpawnPotentialNbt(int level) {
        NBTTagCompound entityNbt = this.createEntityNbt(level);
        return this.buildSpawnPotentialNbt(entityNbt);
    }

    private NBTTagCompound createZombieEntityNbt(Random random, int level) {
        NBTTagCompound entityNbt = this.createEntityNbt(level);
        this.equipHands(entityNbt, random, level);
        this.equipArmour(entityNbt, random, level);
        return entityNbt;
    }

    private NBTTagCompound createSkeletonEntityNbt(Random random, int level) {
        NBTTagCompound entityNbt = this.createEntityNbt(level);
        this.equipHands(entityNbt, "minecraft:bow", null);
        this.equipArmour(entityNbt, random, level);
        return entityNbt;
    }

    private NBTTagCompound createEntityNbt(int level) {
        NBTTagCompound entityNbt = this.entityNbt.func_74737_b();
        this.setRoguelikeNbtData(level, this.name, entityNbt);
        return entityNbt;
    }

    private void equipHands(NBTTagCompound entityNbt, Random random, int level) {
        String mainHand = Equipment.getName(this.chooseRandomTool(random), Quality.getToolQuality(random, level));
        String offHand = "minecraft:shield";
        this.equipHands(entityNbt, mainHand, offHand);
    }

    private Equipment chooseRandomTool(Random random) {
        return random.nextBoolean() ? Equipment.PICK : (random.nextBoolean() ? Equipment.AXE : Equipment.SHOVEL);
    }

    private NBTTagCompound buildSpawnPotentialNbt(NBTTagCompound entityNbt) {
        NBTTagCompound spawnPotentialNbt = new NBTTagCompound();
        spawnPotentialNbt.func_74782_a("Entity", (NBTBase)entityNbt);
        spawnPotentialNbt.func_74768_a("Weight", this.weight);
        return spawnPotentialNbt;
    }

    private void equipHands(NBTTagCompound entityNbt, String mainHand, String offhand) {
        NBTTagList hands = new NBTTagList();
        hands.func_74742_a((NBTBase)this.getItem(mainHand));
        hands.func_74742_a((NBTBase)this.getItem(offhand));
        entityNbt.func_74782_a("HandItems", (NBTBase)hands);
    }

    private void equipArmour(NBTTagCompound entityNbt, Random rand, int level) {
        NBTTagList armour = new NBTTagList();
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.FEET, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.LEGS, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.CHEST, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.HELMET, Quality.getArmourQuality(rand, level))));
        entityNbt.func_74782_a("ArmorItems", (NBTBase)armour);
    }

    private NBTTagCompound getItem(String itemName) {
        NBTTagCompound item = new NBTTagCompound();
        if (itemName == null) {
            return item;
        }
        item.func_74778_a("id", itemName);
        item.func_74768_a("Count", 1);
        return item;
    }

    private void setRoguelikeNbtData(int level, String type, NBTTagCompound entityNbt) {
        entityNbt.func_74778_a("id", type);
        if (!RogueConfig.getBoolean(RogueConfig.ROGUESPAWNERS) || !this.equip) {
            return;
        }
        NBTTagCompound buff = new NBTTagCompound();
        buff.func_74774_a("Id", (byte)4);
        buff.func_74774_a("Amplifier", (byte)level);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        NBTTagList activeEffects = new NBTTagList();
        activeEffects.func_74742_a((NBTBase)buff);
        entityNbt.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
    }
}

