/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.common.collect.Lists;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.spawners.SpawnPotential;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;

public class Spawnable {
    private List<SpawnPotential> potentials = Lists.newArrayList();

    public Spawnable(List<SpawnPotential> spawnPotentials) {
        this.potentials.addAll(spawnPotentials);
    }

    public void generate(IWorldEditor editor, Random random, Coord cursor, int level) {
        Coord pos = new Coord(cursor);
        editor.setBlock(pos, new MetaBlock(Blocks.field_150474_ac.func_176223_P()), true, true);
        TileEntity tileentity = editor.getTileEntity(pos);
        if (!(tileentity instanceof TileEntityMobSpawner)) {
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
        MobSpawnerBaseLogic spawnerLogic = spawner.func_145881_a();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.getX());
        nbt.func_74768_a("y", pos.getY());
        nbt.func_74768_a("z", pos.getZ());
        nbt.func_74782_a("SpawnPotentials", (NBTBase)this.getSpawnPotentials(random, level));
        spawnerLogic.func_98270_a(nbt);
        spawnerLogic.func_98278_g();
        tileentity.func_70296_d();
    }

    private NBTTagList getSpawnPotentials(Random random, int level) {
        NBTTagList potentialsNbtTagList = new NBTTagList();
        this.potentials.stream().map(potential -> potential.getSpawnPotentials(random, level)).forEach(potentials -> potentials.forEach(arg_0 -> ((NBTTagList)potentialsNbtTagList).func_74742_a(arg_0)));
        return potentialsNbtTagList;
    }
}

