/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.spawners.SpawnPotential;
import greymerk.roguelike.worldgen.spawners.SpawnPotentialParser;
import greymerk.roguelike.worldgen.spawners.Spawnable;
import java.util.List;
import java.util.Random;

public class SpawnerSettings {
    private WeightedRandomizer<Spawnable> spawners = new WeightedRandomizer();

    public SpawnerSettings() {
    }

    public SpawnerSettings(SpawnerSettings toCopy) {
        this.spawners.merge(toCopy.spawners);
    }

    public SpawnerSettings(SpawnerSettings base, SpawnerSettings other) {
        this.spawners.merge(base.spawners);
        this.spawners.merge(other.spawners);
    }

    public void generateSpawner(IWorldEditor editor, Random rand, Coord cursor, int difficulty) {
        try {
            this.spawners.get(rand).generate(editor, rand, cursor, difficulty);
        }
        catch (Exception e) {
            throw new RuntimeException("Tried to spawn empty spawner", e);
        }
    }

    public boolean isEmpty() {
        return this.spawners.isEmpty();
    }

    public void parse(JsonObject spawnerJson) throws Exception {
        this.add(this.parseSpawnPotentials(spawnerJson), this.parseWeight(spawnerJson));
    }

    private Spawnable parseSpawnPotentials(JsonObject entry) throws Exception {
        JsonElement spawnPotentialsJson = entry.get("potentials");
        List<SpawnPotential> spawnPotentials = SpawnPotentialParser.parse(spawnPotentialsJson);
        return new Spawnable(spawnPotentials);
    }

    private int parseWeight(JsonObject entry) {
        return entry.has("weight") ? entry.get("weight").getAsInt() : 1;
    }

    public void add(Spawnable spawnable, int weight) {
        this.spawners.add(new WeightedChoice<Spawnable>(spawnable, weight));
    }

    public String toString() {
        return this.spawners.toString();
    }
}

