/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.integration.industrialcraft2;

import ic2.api.item.ElectricItem;
import ic2.api.item.IBackupElectricItemManager;
import javax.annotation.Nullable;
import li.cil.scannable.common.init.Items;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public enum ElectricItemManagerScanner implements IBackupElectricItemManager
{
    INSTANCE;


    public static void init() {
        ElectricItem.registerBackupManager((IBackupElectricItemManager)INSTANCE);
    }

    public boolean handles(ItemStack stack) {
        return Items.isScanner(stack);
    }

    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return 0.0;
        }
        if (!ignoreTransferLimit) {
            amount = Math.min(amount, 128.0);
        }
        return ElectricItemManagerScanner.toIC2(energyStorage.receiveEnergy(ElectricItemManagerScanner.fromIC2(amount), simulate));
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return 0.0;
        }
        if (!ignoreTransferLimit) {
            amount = Math.min(amount, 128.0);
        }
        return ElectricItemManagerScanner.toIC2(energyStorage.extractEnergy(ElectricItemManagerScanner.fromIC2(amount), simulate));
    }

    public double getCharge(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return 0.0;
        }
        return ElectricItemManagerScanner.toIC2(energyStorage.getEnergyStored());
    }

    public double getMaxCharge(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return 0.0;
        }
        return ElectricItemManagerScanner.toIC2(energyStorage.getMaxEnergyStored());
    }

    public boolean canUse(ItemStack stack, double amount) {
        return false;
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return false;
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    @Nullable
    public String getToolTip(ItemStack stack) {
        return null;
    }

    public int getTier(ItemStack stack) {
        return 1;
    }

    private static int fromIC2(double value) {
        return (int)(value * 4.0);
    }

    private static double toIC2(int value) {
        return (double)value * 0.25;
    }
}

