/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class DirectMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    private static int nextId = 0;
    private static Map<Integer, Runnable> runnables = Maps.newHashMap();

    public DirectMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.SERVER);
    }

    public static int registerMessage(Runnable runnable) {
        runnables.put(nextId, runnable);
        return nextId++;
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        runnables.get(message.id).run();
    }

    public static void send(int message) {
        MalisisCore.network.sendToServer(new Packet(message));
    }

    public static void send(int message, EntityPlayerMP player) {
        MalisisCore.network.sendTo(new Packet(message), player);
    }

    public static class Packet
    implements IMessage {
        int id;

        public Packet() {
        }

        public Packet(int id) {
            this.id = id;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
        }
    }
}

