/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.floodfill;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FloodFill {
    protected World world;
    protected BlockPos origin;
    protected IBlockState originState;
    protected BiPredicate<World, BlockPos> shouldProcess;
    protected BiConsumer<World, BlockPos> onProcess;
    protected EnumSet<EnumFacing> searchDirs;
    protected int countLimit;
    protected Set<BlockPos> processed = new HashSet<BlockPos>();
    protected ArrayDeque<BlockPos> toProcess = new ArrayDeque();

    protected FloodFill(World world, BlockPos origin, BiPredicate<World, BlockPos> shouldProcess, BiConsumer<World, BlockPos> onProcess, EnumSet<EnumFacing> searchDirs, int countLimit) {
        this.world = world;
        this.origin = origin;
        this.originState = world.func_180495_p(origin);
        this.shouldProcess = shouldProcess;
        this.onProcess = onProcess;
        this.searchDirs = searchDirs;
        this.countLimit = countLimit;
        this.toProcess.add(origin);
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public IBlockState getOriginState() {
        return this.originState;
    }

    public Set<BlockPos> getProcessed() {
        return this.processed;
    }

    public Set<BlockPos> getToProcess() {
        return ImmutableSet.copyOf(this.toProcess);
    }

    public void processAll() {
        while (this.process()) {
        }
    }

    public boolean processStep() {
        return this.process(this.toProcess.size());
    }

    public boolean process(int maxCount) {
        while (maxCount-- > 0 && this.process()) {
        }
        return this.toProcess.size() != 0;
    }

    public boolean process() {
        if (this.toProcess.size() <= 0) {
            return false;
        }
        BlockPos pos = this.toProcess.removeFirst();
        this.process(pos);
        if (this.onProcess != null) {
            this.onProcess.accept(this.world, pos);
        }
        return true;
    }

    protected boolean shouldProcessed(BlockPos pos) {
        if (this.toProcess.contains(pos) || this.processed.contains(pos)) {
            return false;
        }
        return this.shouldProcess == null || this.shouldProcess.test(this.world, pos);
    }

    protected void process(BlockPos pos) {
        for (EnumFacing dir : this.searchDirs) {
            BlockPos newPos = pos.func_177972_a(dir);
            if (this.processed.contains(newPos) || !this.shouldProcessed(newPos)) continue;
            this.toProcess.add(newPos);
        }
        this.processed.add(pos);
        if (this.processed.size() >= this.countLimit) {
            this.toProcess.clear();
        }
    }

    public static FloodFillBuilder builder(World world) {
        return new FloodFillBuilder(world);
    }

    public static class FloodFillBuilder {
        protected World world;
        protected BlockPos origin;
        protected BiPredicate<World, BlockPos> shouldProcess = null;
        protected BiConsumer<World, BlockPos> onProcess = null;
        protected EnumSet<EnumFacing> searchDirs = EnumSet.allOf(EnumFacing.class);
        protected int countLimit = Integer.MAX_VALUE;

        private FloodFillBuilder(World world) {
            this.world = world;
        }

        private BiPredicate<World, BlockPos> compose(BiPredicate<World, BlockPos> predicate) {
            return this.shouldProcess == null ? predicate : this.shouldProcess.and(predicate);
        }

        public FloodFillBuilder from(BlockPos origin) {
            this.origin = (BlockPos)Preconditions.checkNotNull((Object)origin);
            return this;
        }

        public FloodFillBuilder matchesOriginState() {
            IBlockState originState = this.world.func_180495_p(this.origin);
            this.shouldProcess = this.compose((w, p) -> w.func_180495_p(p) == originState);
            return this;
        }

        public FloodFillBuilder matchesOriginBlock() {
            Block originBlock = this.world.func_180495_p(this.origin).func_177230_c();
            this.shouldProcess = this.compose((w, p) -> w.func_180495_p(p).func_177230_c() == originBlock);
            return this;
        }

        public FloodFillBuilder limitDistance(float distance) {
            this.shouldProcess = this.compose((w, p) -> p.func_177951_i((Vec3i)this.origin) < (double)(distance * distance));
            return this;
        }

        public FloodFillBuilder limitCount(int count) {
            this.countLimit = count;
            return this;
        }

        public FloodFillBuilder processIf(BiPredicate<World, BlockPos> predicate) {
            this.shouldProcess = (BiPredicate)Preconditions.checkNotNull(predicate);
            return this;
        }

        public FloodFillBuilder onProcess(BiConsumer<World, BlockPos> onParse) {
            this.onProcess = (BiConsumer)Preconditions.checkNotNull(onParse);
            return this;
        }

        public FloodFillBuilder forDirections(EnumFacing ... directions) {
            this.searchDirs = EnumSet.noneOf(EnumFacing.class);
            for (EnumFacing dir : (EnumFacing[])Preconditions.checkNotNull((Object)directions)) {
                this.searchDirs.add((EnumFacing)Preconditions.checkNotNull((Object)dir));
            }
            return this;
        }

        public FloodFill build() {
            return new FloodFill(this.world, this.origin, this.shouldProcess, this.onProcess, this.searchDirs, this.countLimit);
        }
    }
}

