/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.ambience.AmbienceLayer;
import thebetweenlands.client.audio.ambience.AmbienceSound;
import thebetweenlands.client.audio.ambience.AmbienceType;
import thebetweenlands.common.TheBetweenlands;

@SideOnly(value=Side.CLIENT)
public class AmbienceManager {
    public static final AmbienceManager INSTANCE = new AmbienceManager();
    private static final Comparator<AmbienceType> PRIORITY_COMPARATOR = new Comparator<AmbienceType>(){

        @Override
        public int compare(AmbienceType a1, AmbienceType a2) {
            return Integer.compare(a2.getPriority(), a1.getPriority());
        }
    };
    private final Map<AmbienceLayer, List<AmbienceType>> ambienceRegistry = new HashMap<AmbienceLayer, List<AmbienceType>>();
    private final List<AmbienceSound> delayedAmbiences = new ArrayList<AmbienceSound>();
    private final List<AmbienceSound> playingAmbiences = new ArrayList<AmbienceSound>();
    private int lastSoundPlayTicks = 0;

    public void registerAmbience(AmbienceType type) {
        List<AmbienceType> types = this.ambienceRegistry.get(type.getAmbienceLayer());
        if (types == null) {
            types = new ArrayList<AmbienceType>();
            this.ambienceRegistry.put(type.getAmbienceLayer(), types);
        }
        types.add(type);
    }

    private List<AmbienceType> getTypes(AmbienceLayer layer) {
        List<AmbienceType> types = this.ambienceRegistry.get(layer);
        if (types == null) {
            types = new ArrayList<AmbienceType>();
        }
        return types;
    }

    private List<AmbienceType> sortByPriority(List<AmbienceType> types) {
        ArrayList<AmbienceType> copy = new ArrayList<AmbienceType>();
        copy.addAll(types);
        Collections.sort(copy, PRIORITY_COMPARATOR);
        return copy;
    }

    public void update() {
        if (this.lastSoundPlayTicks > 0) {
            --this.lastSoundPlayTicks;
        }
        Iterator<AmbienceSound> delayedAmbiencesIT = this.delayedAmbiences.iterator();
        while (delayedAmbiencesIT.hasNext()) {
            AmbienceSound sound = delayedAmbiencesIT.next();
            boolean soundPlaying = Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound) || sound.func_147667_k();
            if (!soundPlaying) continue;
            delayedAmbiencesIT.remove();
        }
        Iterator<AmbienceSound> playingAmbiencesIT = this.playingAmbiences.iterator();
        while (playingAmbiencesIT.hasNext()) {
            boolean soundPlaying;
            AmbienceSound sound = playingAmbiencesIT.next();
            boolean bl = soundPlaying = Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound) || this.delayedAmbiences.contains((Object)sound);
            if (!sound.func_147667_k() && soundPlaying) continue;
            if (soundPlaying) {
                Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
            }
            playingAmbiencesIT.remove();
        }
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (player != null) {
            for (AmbienceLayer layer : this.ambienceRegistry.keySet()) {
                AmbienceType type;
                int i;
                List<AmbienceType> availableAmbiences = this.getTypes(layer);
                for (AmbienceType type2 : availableAmbiences) {
                    type2.setPlayer(player);
                }
                int maxTracks = layer.getMaxTracks();
                if (availableAmbiences.isEmpty()) continue;
                List<AmbienceType> sorted = this.sortByPriority(availableAmbiences);
                int lowestPlayedAmbience = Integer.MAX_VALUE;
                int typeIndex = 0;
                for (i = 0; i < sorted.size() && typeIndex < maxTracks; ++i) {
                    type = sorted.get(i);
                    if (!type.isActive() || !type.isActiveInWorld(player.field_70170_p)) continue;
                    ++typeIndex;
                    if (!(type.getLowerPriorityVolume() <= 0.0f)) continue;
                    lowestPlayedAmbience = typeIndex;
                    break;
                }
                typeIndex = 0;
                for (i = 0; i < sorted.size() && typeIndex < maxTracks; ++i) {
                    type = sorted.get(i);
                    if (!type.isActive() || !type.isActiveInWorld(player.field_70170_p)) continue;
                    ++typeIndex;
                    boolean isPlaying = false;
                    for (AmbienceSound sound : this.playingAmbiences) {
                        if (type != sound.type) continue;
                        isPlaying = true;
                        break;
                    }
                    if (isPlaying || typeIndex > lowestPlayedAmbience) continue;
                    if (this.lastSoundPlayTicks > 0) break;
                    this.playSound(new AmbienceSound(type.getSound(), type.getCategory(), type, player, this), type.getDelay());
                    this.lastSoundPlayTicks = 1;
                }
                for (AmbienceSound sound : this.playingAmbiences) {
                    boolean lowerPriority = false;
                    int typeIndex2 = 0;
                    for (int i2 = 0; i2 < sorted.size() && typeIndex2 < maxTracks; ++i2) {
                        AmbienceType otherType = sorted.get(i2);
                        if (!otherType.isActive() || !otherType.isActiveInWorld(player.field_70170_p)) continue;
                        ++typeIndex2;
                        if (sound.type == otherType) break;
                        if (!(otherType.getLowerPriorityVolume() > 0.0f) || !(otherType.getLowerPriorityVolume() < 1.0f)) continue;
                        lowerPriority = true;
                    }
                    if (typeIndex2 <= lowestPlayedAmbience && sound.isFadingOut()) {
                        sound.cancelFade();
                    }
                    if (sound.isStopping()) continue;
                    if (lowestPlayedAmbience != Integer.MAX_VALUE && typeIndex2 > lowestPlayedAmbience) {
                        sound.stop();
                        continue;
                    }
                    sound.setLowPriority(lowerPriority);
                }
            }
        }
    }

    float getLowerPriorityVolume() {
        float lowest = Float.MAX_VALUE;
        for (AmbienceSound sound : this.playingAmbiences) {
            if (!(sound.type.getLowerPriorityVolume() > 0.0f) || !(sound.type.getLowerPriorityVolume() < lowest)) continue;
            lowest = sound.type.getLowerPriorityVolume();
        }
        return lowest;
    }

    private void playSound(AmbienceSound sound, int delay) {
        this.playingAmbiences.add(sound);
        if (sound.type.getSound() != null) {
            if (delay == 0) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            } else {
                this.delayedAmbiences.add(sound);
                Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)sound, delay);
            }
        }
    }

    public boolean shouldStopMusic() {
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (player != null) {
            for (AmbienceSound sound : this.playingAmbiences) {
                if (!sound.type.stopsMusic()) continue;
                return true;
            }
        }
        return false;
    }

    public void stopAll() {
        for (AmbienceSound sound : this.playingAmbiences) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
            sound.stopImmediately();
        }
        for (AmbienceSound sound : this.delayedAmbiences) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
            sound.stopImmediately();
        }
        this.playingAmbiences.clear();
        this.delayedAmbiences.clear();
    }
}

