/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience.list;

import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.client.audio.ambience.AmbienceLayer;
import thebetweenlands.client.audio.ambience.AmbienceType;
import thebetweenlands.common.registries.AmbienceRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class SpiritTreeAmbienceType
extends AmbienceType {
    private double getClosestSpiritTree() {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld((World)Minecraft.func_71410_x().field_71441_e);
        double closestSpiritTree = -1.0;
        for (ILocalStorage storage : worldStorage.getLocalStorageHandler().getLoadedStorages()) {
            double dist;
            if (!(storage instanceof LocationStorage) || ((LocationStorage)storage).getType() != EnumLocationType.SPIRIT_TREE || !((dist = Minecraft.func_71410_x().field_71439_g.func_174791_d().func_72438_d(storage.getBoundingBox().func_189972_c())) < 75.0) || !(closestSpiritTree < 0.0) && !(dist < closestSpiritTree)) continue;
            closestSpiritTree = dist;
        }
        return closestSpiritTree;
    }

    @Override
    public boolean isActive() {
        return this.getClosestSpiritTree() >= 0.0;
    }

    @Override
    public AmbienceLayer getAmbienceLayer() {
        return AmbienceRegistry.BASE_LAYER;
    }

    @Override
    public int getPriority() {
        return 999;
    }

    @Override
    public SoundCategory getCategory() {
        return SoundCategory.AMBIENT;
    }

    @Override
    public SoundEvent getSound() {
        return SoundRegistry.AMBIENT_SNOWFALL;
    }

    @Override
    public float getVolume() {
        return 0.0f;
    }

    @Override
    public float getLowerPriorityVolume() {
        float strength = 1.0f - (float)Math.max(0.0, (this.getClosestSpiritTree() - 20.0) / 55.0);
        return 1.0f - strength;
    }
}

