/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler.gallery;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.codec.digest.DigestUtils;
import thebetweenlands.client.render.sprite.TextureGalleryEntry;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;

public class GalleryEntry {
    private String sha256;
    private String url;
    private String title;
    private String author;
    @Nullable
    private String description;
    @Nullable
    private String localSha256;
    @Nullable
    private String sourceUrl;
    private File pictureFile;
    private volatile int width = 1;
    private volatile int height = 1;
    private volatile boolean isUploaded;

    public GalleryEntry(String sha256, String url, String title, String author, @Nullable String description, @Nullable String sourceUrl, File pictureFile) {
        this.sha256 = sha256.toLowerCase();
        this.url = url;
        this.title = title;
        this.author = author;
        this.description = description;
        this.sourceUrl = sourceUrl;
        this.pictureFile = pictureFile;
    }

    public void setUploaded(int width, int height) {
        this.isUploaded = true;
        this.width = width;
        this.height = height;
    }

    public boolean isUploaded() {
        return this.isUploaded;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getLocation() {
        return new ResourceLocation("thebetweenlands", "online_gallery_" + this.sha256);
    }

    public boolean loadTexture() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject texture = manager.func_110581_b(this.getLocation());
        if (texture == null) {
            TheBetweenlands.logger.info("Loading gallery picture '" + this.getSha256() + "'/'" + this.getUrl() + "'/'" + this.getLocation() + "'");
            return manager.func_110579_a(this.getLocation(), (ITextureObject)new TextureGalleryEntry(this));
        }
        return texture instanceof TextureGalleryEntry;
    }

    public ResourceLocation loadTextureAndGetLocation(ResourceLocation fallback) {
        if (this.loadTexture()) {
            return this.getLocation();
        }
        return fallback;
    }

    public File getPictureFile() {
        return this.pictureFile;
    }

    private void computeLocalPictureSha256() {
        block15: {
            this.localSha256 = null;
            if (this.pictureFile.exists()) {
                try (FileInputStream fio = new FileInputStream(this.pictureFile);){
                    this.localSha256 = DigestUtils.sha256Hex((InputStream)fio).toLowerCase();
                }
                catch (Exception ex) {
                    if (!BetweenlandsConfig.DEBUG.debug) break block15;
                    TheBetweenlands.logger.info(String.format("Failed computing SHA256 hash of gallery picture: %s", this.pictureFile.toString()), (Throwable)ex);
                }
            }
        }
    }

    @Nullable
    public String getLocalSha256() {
        if (this.localSha256 == null) {
            this.computeLocalPictureSha256();
        }
        return this.localSha256;
    }

    public String getSha256() {
        return this.sha256;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getSourceUrl() {
        return this.sourceUrl;
    }
}

