/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelDraetonBalloon;
import thebetweenlands.client.render.model.entity.ModelDraetonCarriage;
import thebetweenlands.client.render.model.entity.ModelDraetonUpgradeAnchor;
import thebetweenlands.client.render.model.entity.ModelDraetonUpgradeCrafting;
import thebetweenlands.client.render.model.entity.ModelDraetonUpgradeFurnace;
import thebetweenlands.client.render.model.entity.ModelDraetonUpgradePulley;
import thebetweenlands.client.render.model.entity.ModelDraetonUpgradeStorage;
import thebetweenlands.common.entity.draeton.DraetonLeakage;
import thebetweenlands.common.entity.draeton.DraetonPhysicsPart;
import thebetweenlands.common.entity.draeton.EntityDraeton;

@SideOnly(value=Side.CLIENT)
public class RenderDraeton
extends Render<EntityDraeton> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/draeton_carriage.png");
    private static final ResourceLocation TEXTURE_BALLOON = new ResourceLocation("thebetweenlands", "textures/entity/draeton_balloon.png");
    private static final ResourceLocation TEXTURE_ANCHOR = new ResourceLocation("thebetweenlands", "textures/entity/draeton_upgrade_anchor.png");
    private static final ResourceLocation TEXTURE_PULLEY = new ResourceLocation("thebetweenlands", "textures/entity/draeton_upgrade_pulley.png");
    private static final ResourceLocation TEXTURE_CRAFTING = new ResourceLocation("thebetweenlands", "textures/entity/draeton_upgrade_crafting.png");
    private static final ResourceLocation TEXTURE_STORAGE = new ResourceLocation("thebetweenlands", "textures/entity/draeton_upgrade_storage.png");
    private static final ResourceLocation TEXTURE_FURNACE = new ResourceLocation("thebetweenlands", "textures/entity/draeton_upgrade_furnace.png");
    private static final ResourceLocation TEXTURE_LEAKAGE_HOLE = new ResourceLocation("thebetweenlands:textures/entity/leakage_hole.png");
    private static final ResourceLocation MAP_BACKGROUND_TEXTURES = new ResourceLocation("textures/map/map_background.png");
    private final ModelDraetonCarriage modelCarriage = new ModelDraetonCarriage();
    private final ModelDraetonBalloon modelBalloon = new ModelDraetonBalloon();
    private final ModelDraetonUpgradeAnchor modelAnchor = new ModelDraetonUpgradeAnchor();
    private final ModelDraetonUpgradePulley modelPulley = new ModelDraetonUpgradePulley();
    private final ModelDraetonUpgradeCrafting modelCrafting = new ModelDraetonUpgradeCrafting();
    private final ModelDraetonUpgradeStorage modelStorage = new ModelDraetonUpgradeStorage();
    private final ModelDraetonUpgradeFurnace modelFurnace = new ModelDraetonUpgradeFurnace();
    private final Minecraft mc = Minecraft.func_71410_x();
    public static final ModelResourceLocation FRAME_MODEL = new ModelResourceLocation(new ResourceLocation("thebetweenlands", "draeton_item_frame"), "normal");
    public static final ModelResourceLocation FRAME_MAP_MODEL = new ModelResourceLocation(new ResourceLocation("thebetweenlands", "draeton_item_frame"), "map");

    public RenderDraeton(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityDraeton entity, double x, double y, double z, float entityYaw, float partialTicks) {
        double binterpZ;
        double binterpY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c(entity));
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        if (this.field_76990_c.func_178634_b()) {
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179084_k();
            for (DraetonPhysicsPart part : entity.physicsParts) {
                double pinterpX = part.prevX + (part.x - part.prevX) * (double)partialTicks - this.field_76990_c.field_78725_b;
                double pinterpY = part.prevY + (part.y - part.prevY) * (double)partialTicks - this.field_76990_c.field_78726_c;
                double pinterpZ = part.prevZ + (part.z - part.prevZ) * (double)partialTicks - this.field_76990_c.field_78723_d;
                AxisAlignedBB aabb = part.getAabb().func_72317_d(pinterpX - x - part.x, pinterpY - y - part.y, pinterpZ - z - part.z);
                RenderGlobal.func_189694_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            Vec3d balloonPos = entity.getBalloonPos(partialTicks);
            double binterpX = balloonPos.field_72450_a - this.field_76990_c.field_78725_b;
            binterpY = balloonPos.field_72448_b - this.field_76990_c.field_78726_c;
            binterpZ = balloonPos.field_72449_c - this.field_76990_c.field_78723_d;
            AxisAlignedBB balloonAabb = new AxisAlignedBB((double)-0.3f, (double)-0.3f, (double)-0.3f, (double)0.3f, (double)0.3f, (double)0.3f).func_72317_d(binterpX - x, binterpY - y, binterpZ - z);
            RenderGlobal.func_189694_a((double)balloonAabb.field_72340_a, (double)balloonAabb.field_72338_b, (double)balloonAabb.field_72339_c, (double)balloonAabb.field_72336_d, (double)balloonAabb.field_72337_e, (double)balloonAabb.field_72334_f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        }
        for (int i = 0; i < 8; ++i) {
            GlStateManager.func_179094_E();
            Vec3d balloonPos = entity.getBalloonRopeConnection(i, partialTicks);
            double binterpX = balloonPos.field_72450_a - this.field_76990_c.field_78725_b;
            double binterpY2 = balloonPos.field_72448_b - this.field_76990_c.field_78726_c;
            double binterpZ2 = balloonPos.field_72449_c - this.field_76990_c.field_78723_d;
            Vec3d connectionPoint = entity.getCarriageRopeConnection(i, partialTicks);
            GlStateManager.func_179137_b((double)connectionPoint.field_72450_a, (double)connectionPoint.field_72448_b, (double)connectionPoint.field_72449_c);
            this.renderConnection(tessellator, buffer, 0.0, 0.0, 0.0, binterpX - x - connectionPoint.field_72450_a, binterpY2 - y - connectionPoint.field_72448_b + (double)0.05f, binterpZ2 - z - connectionPoint.field_72449_c);
            GlStateManager.func_179121_F();
        }
        for (DraetonPhysicsPart part : entity.physicsParts) {
            GlStateManager.func_179094_E();
            Vec3d pullPoint = entity.getPullPoint(part, partialTicks);
            GlStateManager.func_179137_b((double)pullPoint.field_72450_a, (double)pullPoint.field_72448_b, (double)pullPoint.field_72449_c);
            if (part.type == DraetonPhysicsPart.Type.PULLER) {
                Object pullerEntity = part.getEntity();
                if (pullerEntity != null) {
                    double dinterpX = ((Entity)pullerEntity).field_70142_S + (((Entity)pullerEntity).field_70165_t - ((Entity)pullerEntity).field_70142_S) * (double)partialTicks - this.field_76990_c.field_78725_b;
                    double dinterpY = ((Entity)pullerEntity).field_70137_T + (((Entity)pullerEntity).field_70163_u - ((Entity)pullerEntity).field_70137_T) * (double)partialTicks - this.field_76990_c.field_78726_c;
                    double dinterpZ = ((Entity)pullerEntity).field_70136_U + (((Entity)pullerEntity).field_70161_v - ((Entity)pullerEntity).field_70136_U) * (double)partialTicks - this.field_76990_c.field_78723_d;
                    this.renderConnection(tessellator, buffer, 0.0, 0.0, 0.0, dinterpX - x - pullPoint.field_72450_a, dinterpY - y - pullPoint.field_72448_b + 0.25, dinterpZ - z - pullPoint.field_72449_c);
                }
            } else if (entity.upgradeAnchorPart.isEnabled()) {
                double dinterpX = part.prevX + (part.x - part.prevX) * (double)partialTicks - this.field_76990_c.field_78725_b;
                double dinterpY = part.prevY + (part.y - part.prevY) * (double)partialTicks - this.field_76990_c.field_78726_c;
                double dinterpZ = part.prevZ + (part.z - part.prevZ) * (double)partialTicks - this.field_76990_c.field_78723_d;
                this.renderConnection(tessellator, buffer, 0.0, 0.0, 0.0, dinterpX - x - pullPoint.field_72450_a, dinterpY - y - pullPoint.field_72448_b + 0.25, dinterpZ - z - pullPoint.field_72449_c);
                GlStateManager.func_179137_b((double)(dinterpX - x - pullPoint.field_72450_a), (double)(dinterpY - y - pullPoint.field_72448_b + (double)0.3f), (double)(dinterpZ - z - pullPoint.field_72449_c));
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                this.func_110776_a(TEXTURE_ANCHOR);
                this.modelAnchor.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
            GlStateManager.func_179121_F();
        }
        Vec3d balloonPos = entity.getBalloonPos(partialTicks);
        double binterpX = balloonPos.field_72450_a - this.field_76990_c.field_78725_b;
        binterpY = balloonPos.field_72448_b - this.field_76990_c.field_78726_c;
        binterpZ = balloonPos.field_72449_c - this.field_76990_c.field_78723_d;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(binterpX - x), (double)(binterpY - y), (double)(binterpZ - z));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.prevRotationRoll + (entity.rotationRoll - entity.prevRotationRoll) * partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.375f, (float)0.0f);
        this.func_110776_a(TEXTURE_BALLOON);
        this.modelBalloon.render(0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)false);
        this.func_110776_a(TEXTURE_LEAKAGE_HOLE);
        for (DraetonLeakage leakage : entity.getLeakages()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-leakage.pos.field_72450_a), (double)(-leakage.pos.field_72448_b), (double)leakage.pos.field_72449_c);
            Vec3d up = new Vec3d(0.0, (double)0.7071f, (double)0.7071f);
            Vec3d normal = new Vec3d(-leakage.dir.field_72450_a, -leakage.dir.field_72448_b, leakage.dir.field_72449_c);
            Vec3d side = normal.func_72431_c(up).func_72432_b();
            Vec3d side2 = side.func_72431_c(normal).func_72432_b();
            side = side.func_186678_a(0.5);
            side2 = side2.func_186678_a(0.5);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            buffer.func_181662_b(-side.field_72450_a - side2.field_72450_a, -side.field_72448_b - side2.field_72448_b, -side.field_72449_c - side2.field_72449_c).func_187315_a(0.0, 0.0).func_181663_c((float)(-normal.field_72450_a), (float)(-normal.field_72448_b), (float)normal.field_72449_c).func_181675_d();
            buffer.func_181662_b(-side.field_72450_a + side2.field_72450_a, -side.field_72448_b + side2.field_72448_b, -side.field_72449_c + side2.field_72449_c).func_187315_a(0.0, 1.0).func_181663_c((float)(-normal.field_72450_a), (float)(-normal.field_72448_b), (float)normal.field_72449_c).func_181675_d();
            buffer.func_181662_b(side.field_72450_a + -side2.field_72450_a, side.field_72448_b + side2.field_72448_b, side.field_72449_c + side2.field_72449_c).func_187315_a(1.0, 1.0).func_181663_c((float)(-normal.field_72450_a), (float)(-normal.field_72448_b), (float)normal.field_72449_c).func_181675_d();
            buffer.func_181662_b(side.field_72450_a - side2.field_72450_a, side.field_72448_b - side2.field_72448_b, side.field_72449_c - side2.field_72449_c).func_187315_a(1.0, 0.0).func_181663_c((float)(-normal.field_72450_a), (float)(-normal.field_72448_b), (float)normal.field_72449_c).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.prevRotationRoll + (entity.rotationRoll - entity.prevRotationRoll) * partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        float timeSinceHit = (float)entity.getTimeSinceHit() - partialTicks;
        float damageTaken = entity.getDamageTaken() - partialTicks;
        if (damageTaken < 0.0f) {
            damageTaken = 0.0f;
        }
        if (timeSinceHit > 0.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)timeSinceHit) * timeSinceHit * damageTaken / 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_180548_c(entity);
        this.modelCarriage.renderCarriage(0.0625f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IInventory upgrades = entity.getUpgradesInventory();
        for (int i = 0; i < 5; ++i) {
            ItemStack upgrade = upgrades.func_70301_a(i);
            if (upgrade.func_190926_b()) continue;
            Vec3d upgradePos = entity.getUpgradePoint(i, 0.0f);
            ModelBase upgradeModel = null;
            if (entity.isAnchorUpgrade(upgrade)) {
                GlStateManager.func_179094_E();
                float ropeOffset = (entity.prevPulleyRotation + (entity.pulleyRotation - entity.prevPulleyRotation) * partialTicks) * 0.0015f % 0.058333334f;
                GlStateManager.func_179137_b((double)(upgradePos.field_72450_a - (double)0.015f), (double)(upgradePos.field_72448_b - (double)ropeOffset), (double)(-upgradePos.field_72449_c + (double)0.1f));
                this.renderConnection(tessellator, buffer, 0.0, 0.0, 0.0, 0.0, -0.7f, 0.0);
                GlStateManager.func_179121_F();
                upgradeModel = this.modelPulley;
                this.func_110776_a(TEXTURE_PULLEY);
            } else if (entity.isFurnaceUpgrade(upgrade)) {
                upgradeModel = this.modelFurnace;
                this.func_110776_a(TEXTURE_FURNACE);
            } else if (entity.isStorageUpgrade(upgrade)) {
                upgradeModel = this.modelStorage;
                this.func_110776_a(TEXTURE_STORAGE);
            } else if (entity.isCraftingUpgrade(upgrade)) {
                upgradeModel = this.modelCrafting;
                this.func_110776_a(TEXTURE_CRAFTING);
            }
            if (upgradeModel == null) continue;
            entity.upgradeCounterRoll = entity.getUpgradeCounterRoll(i, partialTicks);
            entity.upgradeOpenTicks = entity.getUpgradeOpenTicks(i, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)upgradePos.field_72450_a, (double)upgradePos.field_72448_b, (double)(-upgradePos.field_72449_c));
            GlStateManager.func_179114_b((float)entity.getUpgradeRotY(i), (float)0.0f, (float)1.0f, (float)0.0f);
            upgradeModel.func_78088_a((Entity)entity, 0.0f, 0.0f, (float)entity.field_70173_aa + partialTicks, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        }
        ItemStack displayStack = entity.getUpgradesInventory().func_70301_a(5);
        if (!displayStack.func_190926_b()) {
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.35f, (float)-0.84f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            Entity controller = entity.func_184179_bs();
            this.renderFrame(entity.field_70170_p, displayStack, controller instanceof EntityLivingBase ? (EntityLivingBase)controller : null);
        }
        GlStateManager.func_179121_F();
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179101_C();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void renderFrame(World world, ItemStack stack, @Nullable EntityLivingBase entity) {
        IBakedModel model;
        this.field_76990_c.field_78724_e.func_110577_a(TextureMap.field_110575_b);
        BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
        ModelManager modelmanager = blockrendererdispatcher.func_175023_a().func_178126_b();
        GlStateManager.func_179094_E();
        if (stack.func_77973_b() instanceof ItemMap) {
            model = modelmanager.func_174953_a(FRAME_MAP_MODEL);
        } else {
            model = modelmanager.func_174953_a(FRAME_MODEL);
            GlStateManager.func_179152_a((float)1.3f, (float)1.3f, (float)1.3f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.115f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        blockrendererdispatcher.func_175019_b().func_178262_a(model, 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.4375f);
        this.renderItem(world, stack, entity);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    protected void renderItem(World world, ItemStack itemstack, @Nullable EntityLivingBase entity) {
        if (!itemstack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            boolean isMap = itemstack.func_77973_b() instanceof ItemMap;
            if (isMap) {
                this.field_76990_c.field_78724_e.func_110577_a(MAP_BACKGROUND_TEXTURES);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
                GlStateManager.func_179109_b((float)-64.0f, (float)-64.0f, (float)0.0f);
                MapData mapdata = ((ItemMap)itemstack.func_77973_b()).func_77873_a(itemstack, world);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                if (mapdata != null) {
                    this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
                }
            } else {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179123_a();
                RenderHelper.func_74519_b();
                if (entity != null) {
                    this.mc.func_175599_af().func_184392_a(itemstack, entity, ItemCameraTransforms.TransformType.FIXED, false);
                } else {
                    this.mc.func_175599_af().func_181564_a(itemstack, ItemCameraTransforms.TransformType.FIXED);
                }
                RenderHelper.func_74518_a();
                GlStateManager.func_179099_b();
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    protected void renderConnection(Tessellator tessellator, BufferBuilder buffer, double x1, double y1, double z1, double x2, double y2, double z2) {
        double yMult;
        float percentage;
        float b;
        float g;
        float r;
        int i;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double startX = x1;
        double startY = y1;
        double startZ = z1;
        double endX = x2;
        double endY = y2;
        double endZ = z2;
        double diffX = (float)(endX - startX);
        double diffY = (float)(endY - startY);
        double diffZ = (float)(endZ - startZ);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= 24; ++i) {
            if (i % 2 == 0) {
                r = 0.11372549f;
                g = 0.28235295f;
                b = 0.11372549f;
            } else {
                r = 0.08235294f;
                g = 0.20392157f;
                b = 0.08235294f;
            }
            percentage = (float)i / 24.0f;
            yMult = endY < startY ? (double)percentage * Math.sqrt(percentage) : (double)(percentage * percentage);
            buffer.func_181662_b(x + diffX * (double)percentage + 0.0, y + diffY * (yMult + (double)percentage) * 0.5, z + diffZ * (double)percentage).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buffer.func_181662_b(x + diffX * (double)percentage + 0.025, y + diffY * (yMult + (double)percentage) * 0.5 + 0.025, z + diffZ * (double)percentage).func_181666_a(r, g, b, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= 24; ++i) {
            if (i % 2 == 0) {
                r = 0.11372549f;
                g = 0.28235295f;
                b = 0.11372549f;
            } else {
                r = 0.08235294f;
                g = 0.20392157f;
                b = 0.08235294f;
            }
            percentage = (float)i / 24.0f;
            yMult = endY < startY ? (double)percentage * Math.sqrt(percentage) : (double)(percentage * percentage);
            buffer.func_181662_b(x + diffX * (double)percentage + 0.0, y + diffY * (yMult + (double)percentage) * 0.5 + 0.025, z + diffZ * (double)percentage).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buffer.func_181662_b(x + diffX * (double)percentage + 0.025, y + diffY * (yMult + (double)percentage) * 0.5, z + diffZ * (double)percentage + 0.025).func_181666_a(r, g, b, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
    }

    protected ResourceLocation getEntityTexture(EntityDraeton entity) {
        return TEXTURE;
    }
}

