/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;

public class ModelLayerSelection
implements IModel {
    private IModel model;
    private final boolean[] renderLayer = new boolean[BlockRenderLayer.values().length + 1];

    public ModelLayerSelection() {
    }

    public ModelLayerSelection(IModel model, List<BlockRenderLayer> layers, boolean renderNone) {
        this.model = model;
        for (BlockRenderLayer layer : layers) {
            this.renderLayer[layer.ordinal() + 1] = true;
        }
        if (renderNone) {
            this.renderLayer[0] = true;
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> dependencies = new ArrayList<ResourceLocation>();
        if (this.model != null) {
            dependencies.addAll(this.model.getDependencies());
        }
        return dependencies;
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        if (this.model != null) {
            textures.addAll(this.model.getTextures());
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.model != null) {
            IBakedModel bakedModel = this.model.bake(state, format, bakedTextureGetter);
            return new BakedLayerSelectionModel(bakedModel, this.renderLayer);
        }
        return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return this.model.getDefaultState();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        IModel baseModel = this.model;
        if (customData.containsKey((Object)"model")) {
            ResourceLocation baseModelLocation = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"model")), (String)"model"));
            baseModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)baseModelLocation, (String)"Could not find base model for combined model");
        }
        if (baseModel == null) {
            baseModel = ModelLoaderRegistry.getMissingModel();
        }
        if (customData.containsKey((Object)"model_data")) {
            baseModel = baseModel.process(LoaderExtension.parseJsonElementList(parser, (String)customData.get((Object)"model_data"), "model_data"));
        }
        ArrayList<BlockRenderLayer> renderLayers = new ArrayList<BlockRenderLayer>();
        boolean renderNone = false;
        if (!customData.containsKey((Object)"layers")) {
            for (int i = 1; i < this.renderLayer.length; ++i) {
                if (!this.renderLayer[i]) continue;
                renderLayers.add(BlockRenderLayer.values()[i - 1]);
            }
            renderNone = this.renderLayer[0];
        } else {
            String layers = (String)customData.get((Object)"layers");
            JsonArray layersArray = JsonUtils.func_151207_m((JsonElement)parser.parse(layers), (String)"layers");
            for (JsonElement element : layersArray) {
                String layer;
                switch (layer = element.getAsString()) {
                    case "solid": {
                        renderLayers.add(BlockRenderLayer.SOLID);
                        break;
                    }
                    case "cutout_mipped": {
                        renderLayers.add(BlockRenderLayer.CUTOUT_MIPPED);
                        break;
                    }
                    case "cutout": {
                        renderLayers.add(BlockRenderLayer.CUTOUT);
                        break;
                    }
                    case "translucent": {
                        renderLayers.add(BlockRenderLayer.TRANSLUCENT);
                        break;
                    }
                    case "none": {
                        renderNone = true;
                    }
                }
            }
        }
        return new ModelLayerSelection(baseModel, renderLayers, renderNone);
    }

    public static class BakedLayerSelectionModel
    implements IBakedModel {
        private final IBakedModel model;
        private final boolean[] renderLayer;

        public BakedLayerSelectionModel(IBakedModel model, boolean[] renderLayer) {
            this.model = model;
            this.renderLayer = renderLayer;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null && this.renderLayer[0] || layer != null && this.renderLayer[layer.ordinal() + 1]) {
                return this.model.func_188616_a(state, side, rand);
            }
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return this.model.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.model.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.model.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.model.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.model.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return this.model.func_188617_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair result = this.model instanceof PerspectiveMapWrapper ? ((PerspectiveMapWrapper)this.model).handlePerspective(cameraTransformType) : PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.func_177552_f().func_181688_b(cameraTransformType), (ItemCameraTransforms.TransformType)cameraTransformType);
            return Pair.of((Object)this, (Object)result.getValue());
        }
    }
}

