/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.particle.entity.ParticleAnimated;

public class ParticleBlockProtection
extends ParticleAnimated
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    protected final EnumFacing face;

    protected ParticleBlockProtection(World world, double x, double y, double z, double mx, double my, double mz, EnumFacing face, float scale, int maxAge) {
        super(world, x, y, z, 0.0, 0.0, 0.0, maxAge, scale, false);
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
        this.field_187126_f = this.field_187123_c = x;
        this.field_187127_g = this.field_187124_d = y;
        this.field_187128_h = this.field_187125_e = z;
        this.face = face;
    }

    public boolean func_187111_c() {
        return true;
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        Vec3d perpendicular;
        float minU = (float)this.field_94054_b / 16.0f;
        float maxU = minU + 0.0624375f;
        float minV = (float)this.field_94055_c / 16.0f;
        float maxV = minV + 0.0624375f;
        float scale = 0.1f * this.field_70544_f * 2.0f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        float rpx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float rpy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rpz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.func_189214_a(partialTicks);
        int lightmapX = brightness >> 16 & 0xFFFF;
        int lightmapY = brightness & 0xFFFF;
        Vec3d normal = new Vec3d(this.face.func_176730_m());
        switch (this.face) {
            case UP: {
                perpendicular = new Vec3d(1.0, 0.0, 0.0);
                break;
            }
            case DOWN: {
                perpendicular = new Vec3d(-1.0, 0.0, 0.0);
                break;
            }
            default: {
                perpendicular = new Vec3d(0.0, 1.0, 0.0);
            }
        }
        Vec3d perpendicular2 = perpendicular.func_72431_c(normal);
        double yOffset = 0.125;
        Vec3d[] vertices = new Vec3d[]{perpendicular.func_178787_e(perpendicular2.func_186678_a(-1.0)).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale), perpendicular.func_186678_a(-1.0).func_178787_e(perpendicular2.func_186678_a(-1.0)).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale), perpendicular.func_186678_a(-1.0).func_178787_e(perpendicular2).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale), perpendicular.func_178787_e(perpendicular2).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale)};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)this.face.func_82601_c();
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)this.face.func_96559_d();
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)this.face.func_82599_e();
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                vertices[l] = vec3d.func_186678_a(2.0 * vertices[l].func_72430_b(vec3d)).func_178787_e(vertices[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(vertices[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        buff.func_181662_b((double)rpx + vertices[0].field_72450_a, (double)rpy + vertices[0].field_72448_b, (double)rpz + vertices[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + vertices[1].field_72450_a, (double)rpy + vertices[1].field_72448_b, (double)rpz + vertices[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + vertices[2].field_72450_a, (double)rpy + vertices[2].field_72448_b, (double)rpz + vertices[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + vertices[3].field_72450_a, (double)rpy + vertices[3].field_72448_b, (double)rpz + vertices[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleBlockProtection> {
        public Factory() {
            super(ParticleBlockProtection.class, ParticleTextureStitcher.create(ParticleBlockProtection.class, new ResourceLocation("thebetweenlands:particle/block_protection")).setSplitAnimations(true));
        }

        @Override
        public ParticleBlockProtection createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleBlockProtection(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getObject(EnumFacing.class, 0), args.scale, args.data.getInt(1));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(EnumFacing.UP, -1);
        }
    }
}

