/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.particle.entity.ParticleAnimated;

public class ParticleDamageReduction
extends ParticleAnimated
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    protected final Vec3d offset;
    protected final Vec3d normal;
    protected final Entity entity;
    protected boolean rotateCW;

    protected ParticleDamageReduction(World world, double x, double y, double z, double mx, double my, double mz, Entity entity, Vec3d offset, Vec3d normal, float scale, int maxAge) {
        super(world, x, y, z, 0.0, 0.0, 0.0, maxAge, scale, false);
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
        this.entity = entity;
        this.offset = offset;
        this.normal = normal;
        if (this.entity != null) {
            this.field_187126_f = this.field_187123_c = this.entity.field_70165_t + this.offset.field_72450_a;
            this.field_187127_g = this.field_187124_d = this.entity.field_70163_u + this.offset.field_72448_b;
            this.field_187128_h = this.field_187125_e = this.entity.field_70161_v + this.offset.field_72449_c;
        } else {
            this.field_187126_f = this.field_187123_c = x;
            this.field_187127_g = this.field_187124_d = y;
            this.field_187128_h = this.field_187125_e = z;
        }
        this.field_190014_F = this.field_190015_G = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        this.rotateCW = world.field_73012_v.nextBoolean();
    }

    public boolean func_187111_c() {
        return false;
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F += (float)((this.rotateCW ? -1 : 1) * this.field_70546_d) / 16.0f;
        if (this.entity != null && this.entity.func_70089_S()) {
            this.field_187126_f = this.entity.field_70165_t + this.offset.field_72450_a;
            this.field_187127_g = this.entity.field_70163_u + this.offset.field_72448_b;
            this.field_187128_h = this.entity.field_70161_v + this.offset.field_72449_c;
        } else {
            this.func_187112_i();
        }
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        float minU = (float)this.field_94054_b / 16.0f;
        float maxU = minU + 0.0624375f;
        float minV = (float)this.field_94055_c / 16.0f;
        float maxV = minV + 0.0624375f;
        float scale = 0.1f * this.field_70544_f * 2.0f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        float rpx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float rpy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rpz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.func_189214_a(partialTicks);
        int lightmapX = brightness >> 16 & 0xFFFF;
        int lightmapY = brightness & 0xFFFF;
        Vec3d perpendicular = new Vec3d(0.0, 1.0, 0.0).func_72431_c(this.normal);
        Vec3d perpendicular2 = perpendicular.func_72431_c(this.normal);
        double yOffset = 0.125;
        Vec3d[] vertices = new Vec3d[]{perpendicular.func_178787_e(perpendicular2.func_186678_a(-1.0)).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale), perpendicular.func_186678_a(-1.0).func_178787_e(perpendicular2.func_186678_a(-1.0)).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale), perpendicular.func_186678_a(-1.0).func_178787_e(perpendicular2).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale), perpendicular.func_178787_e(perpendicular2).func_178787_e(perpendicular.func_186678_a(yOffset)).func_186678_a((double)scale)};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)this.normal.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)this.normal.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)this.normal.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                vertices[l] = vec3d.func_186678_a(2.0 * vertices[l].func_72430_b(vec3d)).func_178787_e(vertices[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(vertices[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        buff.func_181662_b((double)rpx + vertices[0].field_72450_a, (double)rpy + vertices[0].field_72448_b, (double)rpz + vertices[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + vertices[1].field_72450_a, (double)rpy + vertices[1].field_72448_b, (double)rpz + vertices[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + vertices[2].field_72450_a, (double)rpy + vertices[2].field_72448_b, (double)rpz + vertices[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + vertices[3].field_72450_a, (double)rpy + vertices[3].field_72448_b, (double)rpz + vertices[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleDamageReduction> {
        public Factory() {
            super(ParticleDamageReduction.class, ParticleTextureStitcher.create(ParticleDamageReduction.class, new ResourceLocation("thebetweenlands:particle/damage_reduction")).setSplitAnimations(true));
        }

        @Override
        public ParticleDamageReduction createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleDamageReduction(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getObject(Entity.class, 0), args.data.getObject(Vec3d.class, 1), args.data.getObject(Vec3d.class, 2), args.scale, args.data.getInt(3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(null, new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 0.0), -1);
        }
    }
}

