/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleBeam;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;

public class ParticleLightningArc
extends Particle {
    private final Vec3d target;
    private final List<Arc> arcs = new ArrayList<Arc>();
    private float baseSize = 0.04f;
    private int baseSubdivs = 3;
    private int branchSubdivs = 3;
    private float baseOffsets = 0.3f;
    private float branchOffsets = 0.1f;
    private int splits = 5;
    private float minSplitSpeed = 1.0f;
    private float maxSplitSpeed = 2.0f;
    private float lengthDecay = 0.25f;
    private float sizeDecay = 0.8f;
    private boolean lighting = true;

    protected ParticleLightningArc(World worldIn, double posXIn, double posYIn, double posZIn, double mx, double my, double mz, Vec3d target) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
        this.field_190017_n = false;
        this.target = target;
        this.field_70547_e = 5;
    }

    public ParticleLightningArc setBaseSize(float size) {
        this.baseSize = size;
        return this;
    }

    public ParticleLightningArc setSubdivs(int baseSubdivs, int branchSubdivs) {
        this.baseSubdivs = baseSubdivs;
        this.branchSubdivs = branchSubdivs;
        return this;
    }

    public ParticleLightningArc setOffsets(float baseOffsets, float branchOffsets) {
        this.baseOffsets = baseOffsets;
        this.branchOffsets = branchOffsets;
        return this;
    }

    public ParticleLightningArc setSplits(int splits) {
        this.splits = splits;
        return this;
    }

    public ParticleLightningArc setSplitSpeed(float minSplitSpeed, float maxSplitSpeed) {
        this.minSplitSpeed = minSplitSpeed;
        this.maxSplitSpeed = maxSplitSpeed;
        return this;
    }

    public ParticleLightningArc setLengthDecay(float multiplier) {
        this.lengthDecay = multiplier;
        return this;
    }

    public ParticleLightningArc setSizeDecay(float multiplier) {
        this.sizeDecay = multiplier;
        return this;
    }

    public ParticleLightningArc setLighting(boolean light) {
        this.lighting = light;
        return this;
    }

    private void addArc(List<Arc> arcs, Arc arc, float offsets, int subdivs) {
        Vec3d startpoint = arc.from;
        Arc prevArc = null;
        for (int i = 0; i < subdivs; ++i) {
            float t2 = (float)(i + 1) / (float)subdivs;
            float offsetScale = i == subdivs - 1 ? 0.0f : 1.0f;
            Vec3d endpoint = arc.from.func_178787_e(arc.dir.func_186678_a((double)t2)).func_72441_c((double)((this.field_187136_p.nextFloat() - 0.5f) * offsets * offsetScale), (double)((this.field_187136_p.nextFloat() - 0.5f) * offsets * offsetScale), (double)((this.field_187136_p.nextFloat() - 0.5f) * offsets * offsetScale));
            Arc newArc = prevArc == null ? new Arc(arc.parent, arc.t, startpoint, endpoint.func_178788_d(startpoint), arc.splits, subdivs, arc.depth, arc.size) : new Arc(prevArc, 1.0f, startpoint, endpoint.func_178788_d(startpoint), arc.splits, subdivs, arc.depth, arc.size);
            arcs.add(newArc);
            prevArc = newArc;
            startpoint = endpoint;
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        double distFromCam;
        float rx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float ry = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int light = this.func_189214_a(partialTicks);
        int lightmapX = light >> 16 & 0xFFFF;
        int lightmapY = light & 0xFFFF;
        float scale = ((MathHelper.func_76126_a((float)(((float)this.field_70546_d + partialTicks) * 0.8f)) + 1.0f) * 0.5f * 0.5f + 0.5f) * this.baseSize * (1.0f - ((float)(this.field_70546_d - 1) + partialTicks) / (float)this.field_70547_e);
        for (Arc arc : this.arcs) {
            ParticleBeam.buildBeam((double)rx + ((Arc)arc).from.field_72450_a, (double)ry + ((Arc)arc).from.field_72448_b, (double)rz + ((Arc)arc).from.field_72449_c, arc.dir, scale * arc.size, 0.0f, 0.0f, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ, (x, y, z, u, v) -> buffer.func_181662_b(x, y, z).func_187315_a(u, v).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d());
        }
        if (this.lighting && ShaderHelper.INSTANCE.isWorldShaderActive() && (distFromCam = entityIn.func_70011_f(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c)) < 40.0) {
            ShaderHelper.INSTANCE.require();
            float strength = (1.0f - (float)this.field_70546_d / (float)this.field_70547_e) * this.field_82339_as * 50.0f;
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c, 1.0f + 5.0f * this.baseSize, this.field_70552_h * strength, this.field_70553_i * strength, this.field_70551_j * strength));
        }
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.arcs.isEmpty()) {
            this.addArc(this.arcs, new Arc(null, 0.0f, Vec3d.field_186680_a, this.target.func_178786_a(this.field_187126_f, this.field_187127_g, this.field_187128_h), this.splits, 0, 0, 1.0f), this.baseOffsets, this.baseSubdivs);
        }
        for (Arc arc : this.arcs) {
            if (arc.parent != null) {
                arc.from = arc.parent.from.func_178787_e(arc.parent.dir.func_186678_a((double)arc.t));
            }
            float jitter = (float)(arc.depth + 1) * 0.02f;
            float length = (float)arc.dir.func_72433_c() * (arc.depth > 0 ? 0.9f * arc.t : 1.0f);
            arc.dir = arc.dir.func_72441_c((double)((this.field_187136_p.nextFloat() - 0.5f) * jitter), (double)((this.field_187136_p.nextFloat() - 0.5f) * jitter), (double)((this.field_187136_p.nextFloat() - 0.5f) * jitter)).func_72432_b().func_186678_a((double)length);
        }
        int iters = Math.round(this.minSplitSpeed + this.field_187136_p.nextFloat() * (this.maxSplitSpeed - this.minSplitSpeed));
        for (int j = 0; j < iters; ++j) {
            ArrayList<Arc> newArcs = new ArrayList<Arc>();
            for (Arc arc : this.arcs) {
                if (arc.splits <= 0) continue;
                int numSplits = arc.splits / 2 + this.field_187136_p.nextInt(arc.splits / 2 + 1);
                for (int i = 0; i < numSplits; ++i) {
                    arc.splits--;
                    float len = (float)arc.dir.func_72433_c();
                    Vec3d dir = arc.dir.func_72441_c((double)((this.field_187136_p.nextFloat() - 0.5f) * len * 0.5f), (double)((this.field_187136_p.nextFloat() - 0.5f) * len * 0.5f), (double)((this.field_187136_p.nextFloat() - 0.5f) * len * 0.5f)).func_72432_b().func_186678_a((double)(len * (float)arc.subdivs * this.lengthDecay));
                    float t = this.field_187136_p.nextFloat();
                    Vec3d from = arc.from.func_178787_e(arc.dir.func_186678_a((double)t));
                    this.addArc(newArcs, new Arc(arc, t, from, dir, arc.splits / 2, this.branchSubdivs, arc.depth + 1, arc.size * this.sizeDecay), len * this.branchOffsets / 3.0f, this.branchSubdivs);
                }
            }
            this.arcs.addAll(newArcs);
        }
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleLightningArc> {
        public Factory() {
            super(ParticleLightningArc.class);
        }

        @Override
        public ParticleLightningArc createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleLightningArc(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getObject(Vec3d.class, 0));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(Vec3d.field_186680_a);
        }
    }

    private class Arc {
        @Nullable
        private Arc parent;
        private float t;
        private Vec3d from;
        private Vec3d dir;
        private int splits;
        private int subdivs;
        private int depth;
        private float size;

        private Arc(Arc parent, float t, Vec3d from, Vec3d to, int splits, int subdivs, int depth, float size) {
            this.parent = parent;
            this.t = t;
            this.from = from;
            this.dir = to;
            this.splits = splits;
            this.subdivs = subdivs;
            this.depth = depth;
            this.size = size;
        }
    }
}

