/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader.postprocessing;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.PostProcessingEffect;
import thebetweenlands.client.render.shader.postprocessing.WorldShader;
import thebetweenlands.util.RenderUtils;

public class GroundFog
extends PostProcessingEffect<GroundFog> {
    public static final ResourceLocation TEXTURE_GROUND_FOG_HEIGHT_MAP = new ResourceLocation("thebetweenlands", "textures/shaders/ground_fog_height_map.png");
    public static final int MAX_FOG_VOLUMES = 16;
    private final int[] fogVolumePositionUniformIDs = new int[16];
    private final int[] fogVolumeColorUniformIDs = new int[16];
    private final int[] fogVolumeSizeUniformIDs = new int[16];
    private final int[] fogVolumeExtinctionUniformIDs = new int[16];
    private final int[] fogVolumeInScatteringUniformIDs = new int[16];
    private int depthUniformID = -1;
    private int heightMapUniformID = -1;
    private int invMVPUniformID = -1;
    private int msTimeUniformID = -1;
    private int worldTimeUniformID = -1;
    private int renderPosUniformID = -1;
    private int viewPosUniformID = -1;
    private int fogVolumeAmountUniformIDs = -1;
    private int fogModeUniformID = -1;
    private int depthBufferTexture = -1;
    private List<GroundFogVolume> volumes = Collections.emptyList();

    public GroundFog setDepthBufferTexture(int id) {
        this.depthBufferTexture = id;
        return this;
    }

    public GroundFog setFogVolumes(List<GroundFogVolume> volumes) {
        this.volumes = volumes;
        return this;
    }

    @Override
    protected ResourceLocation[] getShaders() {
        return new ResourceLocation[]{new ResourceLocation("thebetweenlands:shaders/postprocessing/ground_fog/ground_fog.vsh"), new ResourceLocation("thebetweenlands:shaders/postprocessing/ground_fog/ground_fog.fsh")};
    }

    @Override
    protected boolean initEffect() {
        this.depthUniformID = this.getUniform("s_diffuse_depth");
        this.heightMapUniformID = this.getUniform("s_height_map");
        this.invMVPUniformID = this.getUniform("u_INVMVP");
        this.msTimeUniformID = this.getUniform("u_msTime");
        this.worldTimeUniformID = this.getUniform("u_worldTime");
        this.viewPosUniformID = this.getUniform("u_viewPos");
        this.renderPosUniformID = this.getUniform("u_renderPos");
        this.fogModeUniformID = this.getUniform("u_fogMode");
        for (int i = 0; i < 16; ++i) {
            this.fogVolumePositionUniformIDs[i] = this.getUniform("u_fogVolumes[" + i + "].position");
            this.fogVolumeColorUniformIDs[i] = this.getUniform("u_fogVolumes[" + i + "].color");
            this.fogVolumeSizeUniformIDs[i] = this.getUniform("u_fogVolumes[" + i + "].size");
            this.fogVolumeExtinctionUniformIDs[i] = this.getUniform("u_fogVolumes[" + i + "].extinction");
            this.fogVolumeInScatteringUniformIDs[i] = this.getUniform("u_fogVolumes[" + i + "].inScattering");
        }
        this.fogVolumeAmountUniformIDs = this.getUniform("u_fogVolumesAmount");
        return true;
    }

    @Override
    protected void uploadUniforms(float partialTicks) {
        WorldShader shader = ShaderHelper.INSTANCE.getWorldShader();
        this.uploadSampler(this.depthUniformID, shader.getDepthBuffer().func_110552_b(), 1);
        this.uploadSampler(this.heightMapUniformID, TEXTURE_GROUND_FOG_HEIGHT_MAP, 2);
        this.uploadMatrix4f(this.invMVPUniformID, shader.getInvertedModelviewProjectionMatrix());
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        this.uploadFloat(this.msTimeUniformID, (float)System.nanoTime() / 1000000.0f);
        this.uploadFloat(this.worldTimeUniformID, (float)RenderUtils.getRenderTickCounter() + partialTicks);
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        Vec3d camPos = renderView != null ? ActiveRenderInfo.func_178806_a((Entity)Minecraft.func_71410_x().func_175606_aa(), (double)partialTicks) : Vec3d.field_186680_a;
        this.uploadFloat(this.viewPosUniformID, (float)(camPos.field_72450_a - renderPosX), (float)(camPos.field_72448_b - renderPosY), (float)(camPos.field_72449_c - renderPosZ));
        this.uploadFloat(this.renderPosUniformID, (float)renderPosX, (float)renderPosY, (float)renderPosZ);
        int renderedVolumes = Math.min(16, this.volumes.size());
        this.uploadInt(this.fogVolumeAmountUniformIDs, renderedVolumes);
        for (int i = 0; i < renderedVolumes; ++i) {
            GroundFogVolume volume = this.volumes.get(i);
            this.uploadFloat(this.fogVolumePositionUniformIDs[i], (float)(volume.position.field_72450_a - renderPosX), (float)(volume.position.field_72448_b - renderPosY), (float)(volume.position.field_72449_c - renderPosZ));
            this.uploadFloat(this.fogVolumeColorUniformIDs[i], volume.r, volume.g, volume.b);
            this.uploadFloat(this.fogVolumeSizeUniformIDs[i], (float)volume.size.field_72450_a, (float)volume.size.field_72448_b, (float)volume.size.field_72449_c);
            this.uploadFloat(this.fogVolumeExtinctionUniformIDs[i], volume.extinction);
            this.uploadFloat(this.fogVolumeInScatteringUniformIDs[i], volume.inScattering);
        }
        this.uploadInt(this.fogModeUniformID, FogHandler.getCurrentFogMode());
    }

    public static class GroundFogVolume {
        public final Vec3d position;
        public final Vec3d size;
        public final float r;
        public final float g;
        public final float b;
        public final float inScattering;
        public final float extinction;

        public GroundFogVolume(Vec3d position, Vec3d size, float inScattering, float extinction, int color) {
            this(position, size, inScattering, extinction, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }

        public GroundFogVolume(Vec3d position, Vec3d size, float inScattering, float extinction, float r, float g, float b) {
            this.position = position;
            this.size = size;
            this.inScattering = inScattering;
            this.extinction = extinction;
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

