/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.client.render.model.tile.ModelCenser;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.GroundFog;
import thebetweenlands.common.block.container.BlockCenser;
import thebetweenlands.common.tile.TileEntityCenser;
import thebetweenlands.util.RenderUtils;
import thebetweenlands.util.StatePropertyHelper;

public class RenderCenser
extends TileEntitySpecialRenderer<TileEntityCenser> {
    private static final ModelCenser MODEL = new ModelCenser();
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/censer.png");
    public static final ResourceLocation CENSER_FOG_PATH = new ResourceLocation("thebetweenlands", "tiles/censer_fog");

    public boolean isGlobalRenderer(TileEntityCenser te) {
        return true;
    }

    private void renderFogFlow(TextureAtlasSprite fogSprite, float animationTicks, int skyLight, int blockLight, int color, float alpha, boolean flatSlope) {
        float stripY;
        float zOff;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f * alpha;
        float minU = fogSprite.func_94209_e();
        float minV = fogSprite.func_94206_g();
        float maxU = fogSprite.func_94212_f();
        float maxV = fogSprite.func_94210_h();
        maxU = minU + (maxU - minU) * 0.1875f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        float halfWidth = 0.065f;
        float prevZOff = zOff = 0.0f;
        float vOff = minV;
        float onePx = 0.0625f;
        float oneTx = (maxV - minV) / 16.0f;
        float prevStripY = stripY = 0.0f;
        for (int i = 0; i < 16; ++i) {
            float slopeIndex = i + 1;
            float slope = 0.001f;
            if (flatSlope && (i == 3 || i == 4)) {
                slope = 1.9E-4f;
            }
            float wavyZOff = (zOff += onePx / ((float)(i + 1) * slope / 0.001f)) + (float)Math.sin(((float)i - animationTicks * 0.1f) * 1.1f) * 0.015f;
            buffer.func_181662_b((double)(-halfWidth), (double)prevStripY, (double)prevZOff).func_181666_a(r, g, b, a).func_187315_a((double)minU, (double)(vOff + oneTx)).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b((double)(-halfWidth), (double)(stripY -= slope + Math.min(slopeIndex * slopeIndex * slopeIndex * slope, onePx)), (double)wavyZOff).func_181666_a(r, g, b, a).func_187315_a((double)minU, (double)vOff).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b((double)halfWidth, (double)stripY, (double)wavyZOff).func_181666_a(r, g, b, a).func_187315_a((double)maxU, (double)vOff).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b((double)halfWidth, (double)prevStripY, (double)prevZOff).func_181666_a(r, g, b, a).func_187315_a((double)maxU, (double)(vOff + oneTx)).func_187314_a(skyLight, blockLight).func_181675_d();
            vOff += oneTx;
            prevStripY = stripY;
            prevZOff = wavyZOff;
        }
        tessellator.func_78381_a();
    }

    public void render(TileEntityCenser te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)StatePropertyHelper.getStatePropertySafely(te, BlockCenser.class, BlockCenser.FACING, EnumFacing.NORTH).func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179129_p();
        MODEL.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (te != null && te.getFuelTicks() > 0) {
            ICenserRecipe<Object> recipe;
            if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
                ShaderHelper.INSTANCE.require();
                float strength = te.getDungeonFogStrength(partialTicks);
                float fogBrightness = 0.85f;
                float inScattering = 0.025f * strength;
                float extinction = 2.5f + 5.0f * (1.0f - strength);
                AxisAlignedBB fogArea = te.getFogRenderArea();
                ShaderHelper.INSTANCE.getWorldShader().addGroundFogVolume(new GroundFog.GroundFogVolume(new Vec3d(fogArea.field_72340_a, fogArea.field_72338_b, fogArea.field_72339_c), new Vec3d(fogArea.field_72336_d - fogArea.field_72340_a, fogArea.field_72337_e - fogArea.field_72338_b, fogArea.field_72334_f - fogArea.field_72339_c), inScattering, extinction, fogBrightness, fogBrightness, fogBrightness));
            }
            if ((recipe = te.getCurrentRecipe()) != null) {
                if (te.func_145830_o()) {
                    int effectColor = recipe.getEffectColor(te.getCurrentRecipeContext(), te, ICenserRecipe.EffectColorType.FOG);
                    float effectStrength = te.getEffectStrength(partialTicks);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)0.7f), (double)(z + 0.5));
                    GlStateManager.func_179114_b((float)(-StatePropertyHelper.getStatePropertySafely(te, BlockCenser.class, BlockCenser.FACING, EnumFacing.NORTH).func_185119_l() - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    this.func_147499_a(TextureMap.field_110575_b);
                    TextureAtlasSprite fogSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(CENSER_FOG_PATH.toString());
                    int skyLight = 240;
                    int blockLight = 240;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.18f, (float)0.18f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 0.86f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.03f, (float)0.18f, (float)0.15f);
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 0.94f, skyLight, blockLight, effectColor, effectStrength, true);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)-0.03f, (float)0.18f, (float)0.15f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 0.92f, skyLight, blockLight, effectColor, effectStrength, true);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.114f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 0.9f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)-0.135f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 1.1f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.114f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 0.85f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.135f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 1.15f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.114f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 0.95f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.135f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 1.08f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.114f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 0.88f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.135f, (float)0.0f, (float)0.235f);
                    this.renderFogFlow(fogSprite, ((float)RenderUtils.getRenderTickCounter() + partialTicks) * 1.05f, skyLight, blockLight, effectColor, effectStrength, false);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179132_a((boolean)true);
                }
                recipe.render(te.getCurrentRecipeContext(), te, x, y, z, partialTicks);
            }
        }
    }
}

