/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelDecayPitPlug;
import thebetweenlands.client.render.model.entity.ModelDecayPitTarget;
import thebetweenlands.common.tile.TileEntityDecayPitControl;

@SideOnly(value=Side.CLIENT)
public class RenderDecayPitControl
extends TileEntitySpecialRenderer<TileEntityDecayPitControl> {
    public static final ResourceLocation OUTER_RING_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_outer_ring.png");
    public static final ResourceLocation INNER_RING_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_inner_ring.png");
    public static final ResourceLocation OUTER_MASK_MUD_TILE_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_outer_gear_mask.png");
    public static final ResourceLocation INNER_MASK_MUD_TILE_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_inner_gear_mask.png");
    public static final ResourceLocation MASK_MUD_TILE_TEXTURE_HOLE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_gear_mask_hole.png");
    public static final ResourceLocation VERTICAL_RING_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_vertical_ring.png");
    public static final ResourceLocation DECAY_HOLE_TEXTURE_1 = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_hole_1.png");
    public static final ResourceLocation DECAY_HOLE_TEXTURE_2 = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_hole_2.png");
    public static final ResourceLocation DECAY_HOLE_TEXTURE_3 = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_hole_3.png");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/decay_pit_plug.png");
    private static final ModelDecayPitPlug PLUG_MODEL = new ModelDecayPitPlug();
    public static final ResourceLocation TARGET_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_target.png");
    private static final ModelDecayPitTarget TARGET_MODEL = new ModelDecayPitTarget();

    public void render(TileEntityDecayPitControl tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        int i = tile.func_145831_w().func_175626_b(tile.func_174877_v().func_177984_a(), 0);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float floor_fade = tile.floorFadeTicksPrev + (tile.floorFadeTicks - tile.floorFadeTicksPrev) * partialTicks;
        if (tile.getShowFloor()) {
            float ringRotation = tile.animationTicksPrev + (tile.animationTicks - tile.animationTicksPrev) * partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - floor_fade));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            if (tile.getShowFloor()) {
                int part;
                this.func_147499_a(OUTER_MASK_MUD_TILE_TEXTURE);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 3.0 + 0.001, z + 0.5, 15.0f * (float)part, 7.5, 7.5, 4.25, 4.25, false);
                }
                tessellator.func_78381_a();
                this.func_147499_a(INNER_MASK_MUD_TILE_TEXTURE);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 2.0 + (double)0.001f, z + 0.5, 15.0f * (float)part, 4.25, 4.25, 2.75, 2.75, false);
                }
                tessellator.func_78381_a();
                this.func_147499_a(VERTICAL_RING_TEXTURE);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 3.0 + 0.001, z + 0.5, 15.0f * (float)part, 7.5, 7.5, 4.25, 4.25, true);
                }
                tessellator.func_78381_a();
                this.func_147499_a(DECAY_HOLE_TEXTURE_1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 1.0 + (double)0.003f, z + 0.5, 15.0f * (float)part, 2.25, 2.25, 0.0, 0.0, false);
                }
                tessellator.func_78381_a();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.0);
                GlStateManager.func_179114_b((float)ringRotation, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
                GlStateManager.func_179128_n((int)5888);
                this.func_147499_a(OUTER_RING_TEXTURE);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 3.0 + 0.003, z + 0.5, 15.0f * (float)part, 7.5, 7.5, 4.24, 4.24, false);
                }
                tessellator.func_78381_a();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.0);
                GlStateManager.func_179114_b((float)(-ringRotation), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
                GlStateManager.func_179128_n((int)5888);
                this.func_147499_a(INNER_RING_TEXTURE);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 2.0 + (double)0.003f, z + 0.5, 15.0f * (float)part, 4.25, 4.25, 2.75, 2.75, false);
                }
                tessellator.func_78381_a();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.0);
                GlStateManager.func_179114_b((float)ringRotation, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
                GlStateManager.func_179128_n((int)5888);
                this.func_147499_a(DECAY_HOLE_TEXTURE_2);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 1.5 + (double)0.003f, z + 0.5, 15.0f * (float)part, 2.0, 2.0, 0.0, 0.0, false);
                }
                tessellator.func_78381_a();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.0);
                GlStateManager.func_179114_b((float)(ringRotation * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
                GlStateManager.func_179128_n((int)5888);
                this.func_147499_a(DECAY_HOLE_TEXTURE_3);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                for (part = 0; part < 24; ++part) {
                    RenderDecayPitControl.buildRingQuads(buffer, x + 0.5, y + 1.75 + (double)0.003f, z + 0.5, 15.0f * (float)part, 2.25, 2.25, 0.0, 0.0, false);
                }
                tessellator.func_78381_a();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
        if (tile.isPlugged()) {
            float fall = tile.plugDropTicksPrev + (tile.plugDropTicks - tile.plugDropTicksPrev) * partialTicks;
            float jumpUP = (float)tile.plugJumpPrev * 0.1f + ((float)tile.plugJump * 0.1f - (float)tile.plugJumpPrev * 0.1f) * partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            this.func_147499_a(TEXTURE);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 4.0 - (double)fall + (double)jumpUP), (double)(z + 0.5));
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(0.0f + tile.plugRotation), (float)0.0f, (float)1.0f, (float)0.0f);
            PLUG_MODEL.renderJustPlug(0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            if (tile.getShowFloor()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - floor_fade));
                GlStateManager.func_179129_p();
                this.func_147499_a(TEXTURE);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 4.0 - (double)fall), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                PLUG_MODEL.renderJustChains(0.0625f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179089_o();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - floor_fade));
                GlStateManager.func_179129_p();
                this.func_147499_a(TEXTURE);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 7.0 - (double)fall), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                TARGET_MODEL.render(0.0625f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179089_o();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void buildRingQuads(BufferBuilder buffer, double x, double y, double z, double angle, double offsetXOuter, double offsetZOuter, double offsetXInner, double offsetZInner, boolean innerWall) {
        double startAngle = Math.toRadians(angle);
        double endAngle = Math.toRadians(angle + 15.0);
        double offSetXOut1 = -Math.sin(startAngle) * offsetXOuter;
        double offSetZOut1 = Math.cos(startAngle) * offsetZOuter;
        double offSetXIn1 = -Math.sin(startAngle) * offsetXInner;
        double offSetZIn1 = Math.cos(startAngle) * offsetZInner;
        double offSetXOut2 = -Math.sin(endAngle) * offsetXOuter;
        double offSetZOut2 = Math.cos(endAngle) * offsetZOuter;
        double offSetXIn2 = -Math.sin(endAngle) * offsetXInner;
        double offSetZIn2 = Math.cos(endAngle) * offsetZInner;
        if (!innerWall) {
            buffer.func_181662_b(x + offSetXOut1, y, z + offSetZOut1).func_187315_a(offSetZOut1 / offsetZOuter / 2.0 + 0.5, 1.0 - (offSetXOut1 / offsetXOuter / 2.0 + 0.5)).func_181675_d();
            buffer.func_181662_b(x + offSetXIn1, y, z + offSetZIn1).func_187315_a(offSetZIn1 / offsetZOuter / 2.0 + 0.5, 1.0 - (offSetXIn1 / offsetXOuter / 2.0 + 0.5)).func_181675_d();
            buffer.func_181662_b(x + offSetXIn2, y, z + offSetZIn2).func_187315_a(offSetZIn2 / offsetZOuter / 2.0 + 0.5, 1.0 - (offSetXIn2 / offsetXOuter / 2.0 + 0.5)).func_181675_d();
            buffer.func_181662_b(x + offSetXOut2, y, z + offSetZOut2).func_187315_a(offSetZOut2 / offsetZOuter / 2.0 + 0.5, 1.0 - (offSetXOut2 / offsetXOuter / 2.0 + 0.5)).func_181675_d();
        } else {
            buffer.func_181662_b(x + offSetXIn1, y, z + offSetZIn1).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(x + offSetXIn1, y - 1.0, z + offSetZIn1).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(x + offSetXIn2, y - 1.0, z + offSetZIn2).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(x + offSetXIn2, y, z + offSetZIn2).func_187315_a(0.0, 1.0).func_181675_d();
        }
    }

    public boolean isGlobalRenderer(TileEntityDecayPitControl tile) {
        return true;
    }
}

