/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import thebetweenlands.client.render.model.tile.ModelWaystone;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.block.structure.BlockWaystone;
import thebetweenlands.common.tile.TileEntityWaystone;
import thebetweenlands.util.StatePropertyHelper;

public class RenderWaystone
extends TileEntitySpecialRenderer<TileEntityWaystone> {
    private static final ModelWaystone MODEL = new ModelWaystone();
    private static final ResourceLocation TEXTURE_ACTIVE = new ResourceLocation("thebetweenlands:textures/tiles/waystone_active.png");
    private static final ResourceLocation TEXTURE_INACTIVE = new ResourceLocation("thebetweenlands:textures/tiles/waystone_inactive.png");
    private static final ResourceLocation TEXTURE_GRASS = new ResourceLocation("thebetweenlands:textures/tiles/waystone_grass.png");

    public void render(TileEntityWaystone te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean isBreakingAnimation;
        BlockWaystone.Part part = StatePropertyHelper.getStatePropertySafely(te, BlockWaystone.class, BlockWaystone.PART, BlockWaystone.Part.BOTTOM);
        boolean active = StatePropertyHelper.getStatePropertySafely(te, BlockWaystone.class, BlockWaystone.ACTIVE, false);
        if (destroyStage < 0 || te == null) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        GlStateManager.func_179091_B();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        boolean bl = isBreakingAnimation = te != null && destroyStage >= 0;
        if (part == BlockWaystone.Part.BOTTOM || isBreakingAnimation) {
            float rotation = 0.0f;
            if (isBreakingAnimation) {
                this.func_147499_a(field_178460_a[destroyStage]);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.func_179128_n((int)5888);
                TileEntityWaystone master = null;
                switch (part) {
                    case TOP: {
                        GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
                        if (te.func_145831_w() == null) break;
                        master = te.func_145831_w().func_175625_s(te.func_174877_v().func_177979_c(2));
                        break;
                    }
                    case MIDDLE: {
                        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                        if (te.func_145831_w() == null) break;
                        master = te.func_145831_w().func_175625_s(te.func_174877_v().func_177979_c(1));
                        break;
                    }
                    case BOTTOM: {
                        master = te;
                    }
                }
                if (master instanceof TileEntityWaystone) {
                    rotation = master.getRotation();
                }
            } else {
                if (active) {
                    this.func_147499_a(TEXTURE_ACTIVE);
                } else {
                    this.func_147499_a(TEXTURE_INACTIVE);
                }
                float f = rotation = te != null ? te.getRotation() : 0.0f;
                if (active && te != null && ShaderHelper.INSTANCE.isWorldShaderActive()) {
                    BlockPos pos = te.func_174877_v();
                    double px = (double)pos.func_177958_n() + 0.5;
                    double py = pos.func_177956_o();
                    double pz = (double)pos.func_177952_p() + 0.5;
                    EntityPlayer closestPlayer = te.func_145831_w().func_184137_a(px, py, pz, 4.0, false);
                    if (closestPlayer != null) {
                        ShaderHelper.INSTANCE.require();
                        float brightness = 3.0f * (float)(1.0 - closestPlayer.func_70011_f(px, py, pz) / 4.0);
                        ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(px, py, pz, 8.0f, 0.44f * brightness, 0.8f * brightness, 1.0f * brightness));
                    }
                }
            }
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            MODEL.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            if (isBreakingAnimation) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            } else {
                this.func_147499_a(TEXTURE_GRASS);
                int grassColor = te != null ? BiomeColorHelper.func_180286_a((IBlockAccess)te.func_145831_w(), (BlockPos)te.func_174877_v()) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                GlStateManager.func_179124_c((float)((float)(grassColor >> 16 & 0xFF) / 255.0f), (float)((float)(grassColor >> 8 & 0xFF) / 255.0f), (float)((float)(grassColor & 0xFF) / 255.0f));
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
                MODEL.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179113_r();
            }
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(TileEntityWaystone te) {
        return StatePropertyHelper.getStatePropertySafely(te, BlockWaystone.class, BlockWaystone.ACTIVE, false);
    }
}

