/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityAspectVial;

public class BlockAspectVial
extends BlockContainer
implements BlockRegistry.ICustomItemBlock {
    public static final PropertyEnum<BlockDentrothyst.EnumDentrothyst> TYPE = PropertyEnum.func_177709_a((String)"type", BlockDentrothyst.EnumDentrothyst.class);
    public static final PropertyBool RANDOM_POSITION = PropertyBool.func_177716_a((String)"random_position");
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, (double)0.95f, (double)0.45f, (double)0.95f);

    public BlockAspectVial() {
        super(Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.4f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)BlockDentrothyst.EnumDentrothyst.GREEN)).func_177226_a((IProperty)RANDOM_POSITION, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, (double)0.45f, (double)0.85f);
    }

    public IBlockState func_176203_a(int meta) {
        BlockDentrothyst.EnumDentrothyst type;
        switch (meta & 1) {
            default: {
                type = BlockDentrothyst.EnumDentrothyst.GREEN;
                break;
            }
            case 1: {
                type = BlockDentrothyst.EnumDentrothyst.ORANGE;
            }
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)RANDOM_POSITION, (Comparable)Boolean.valueOf((meta & 2) == 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        switch ((BlockDentrothyst.EnumDentrothyst)((Object)state.func_177229_b(TYPE))) {
            default: {
                break;
            }
            case ORANGE: {
                meta |= 1;
            }
        }
        if (!((Boolean)state.func_177229_b((IProperty)RANDOM_POSITION)).booleanValue()) {
            meta |= 2;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, RANDOM_POSITION});
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.func_175625_s(pos) instanceof TileEntityAspectVial) {
            TileEntityAspectVial tile = (TileEntityAspectVial)world.func_175625_s(pos);
            if (!player.func_184586_b(hand).func_190926_b()) {
                ItemStack heldItem = player.func_184586_b(hand);
                ItemAspectContainer container = null;
                if (heldItem.func_77973_b() == ItemRegistry.ASPECT_VIAL && (container = ItemAspectContainer.fromItem(heldItem)).getAspects().size() == 1) {
                    Aspect itemAspect = container.getAspects().get(0);
                    if (!player.func_70093_af()) {
                        if (tile.getAspect() == null || tile.getAspect().type == itemAspect.type) {
                            if (!world.field_72995_K) {
                                int added;
                                if (tile.getAspect() == null) {
                                    tile.setAspect(new Aspect(itemAspect.type, 0));
                                }
                                if ((added = tile.addAmount(Math.min(itemAspect.amount, 100))) > 0) {
                                    int leftAmount = itemAspect.amount - added;
                                    container.set(itemAspect.type, itemAspect.amount - added);
                                    if (leftAmount <= 0) {
                                        int type = heldItem.func_77952_i();
                                        switch (type) {
                                            default: {
                                                player.func_184611_a(hand, ItemRegistry.DENTROTHYST_VIAL.createStack(0));
                                                break;
                                            }
                                            case 1: {
                                                player.func_184611_a(hand, ItemRegistry.DENTROTHYST_VIAL.createStack(2));
                                            }
                                        }
                                    }
                                }
                            }
                            player.func_184609_a(hand);
                            return true;
                        }
                    } else if (tile.getAspect() != null && tile.getAspect().type == itemAspect.type) {
                        int toRemove;
                        if (!world.field_72995_K && (toRemove = Math.min(100, 5000 - itemAspect.amount)) > 0) {
                            int removedAmount = tile.removeAmount(toRemove);
                            container.set(itemAspect.type, itemAspect.amount + removedAmount);
                        }
                        player.func_184609_a(hand);
                        return true;
                    }
                } else if (heldItem.func_77973_b() == ItemRegistry.DENTROTHYST_VIAL && player.func_70093_af() && tile.getAspect() != null && heldItem.func_77952_i() != 1) {
                    if (!world.field_72995_K) {
                        Aspect aspect = tile.getAspect();
                        int removedAmount = tile.removeAmount(100);
                        if (removedAmount > 0) {
                            EntityItem itemEntity;
                            ItemStack vial = new ItemStack((Item)ItemRegistry.ASPECT_VIAL);
                            switch (heldItem.func_77952_i()) {
                                default: {
                                    vial.func_77964_b(0);
                                    break;
                                }
                                case 2: {
                                    vial.func_77964_b(1);
                                }
                            }
                            container = ItemAspectContainer.fromItem(vial);
                            container.add(aspect.type, removedAmount);
                            heldItem.func_190918_g(1);
                            if (heldItem.func_190916_E() <= 0) {
                                player.func_184611_a(hand, heldItem);
                            }
                            if ((itemEntity = player.func_71019_a(vial, false)) != null) {
                                itemEntity.func_174867_a(0);
                            }
                        }
                    }
                    player.func_184609_a(hand);
                    return true;
                }
            } else if (player.func_70093_af()) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)RANDOM_POSITION, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)RANDOM_POSITION) == false)));
                }
                player.func_184609_a(hand);
                return true;
            }
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAspectVial();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        NonNullList list = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)list, (IBlockAccess)world, pos, state, 0);
        return list.size() > 0 ? (ItemStack)list.get(0) : ItemStack.field_190927_a;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityAspectVial tile = (TileEntityAspectVial)world.func_175625_s(pos);
        if (tile != null) {
            if (tile.getAspect() != null) {
                if (tile.getAspect().amount > 0) {
                    ItemStack vial = new ItemStack((Item)ItemRegistry.ASPECT_VIAL);
                    switch ((BlockDentrothyst.EnumDentrothyst)((Object)state.func_177229_b(TYPE))) {
                        case ORANGE: {
                            vial.func_77964_b(1);
                            break;
                        }
                        default: {
                            vial.func_77964_b(0);
                        }
                    }
                    ItemAspectContainer.fromItem(vial).add(tile.getAspect().type, tile.getAspect().amount);
                    drops.add((Object)vial);
                }
            } else {
                ItemStack vial = new ItemStack((Item)ItemRegistry.DENTROTHYST_VIAL);
                switch ((BlockDentrothyst.EnumDentrothyst)((Object)state.func_177229_b(TYPE))) {
                    case ORANGE: {
                        vial.func_77964_b(2);
                        break;
                    }
                    default: {
                        vial.func_77964_b(0);
                    }
                }
                drops.add((Object)vial);
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        player.func_71064_a(StatList.func_188055_a((Block)this), 1);
        player.func_71020_j(0.025f);
        if (!(world.field_72995_K || world.restoringBlockSnapshots || player.field_71075_bZ.field_75098_d)) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)world, pos, state, 0);
            float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)world.func_180495_p(pos), (int)0, (float)1.0f, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : drops) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, item);
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_175698_g(pos);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }
}

