/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.block.IAspectFogBlock;
import thebetweenlands.api.block.IDungeonFogBlock;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.tile.TileEntityCenser;

public class BlockCenser
extends BasicBlock
implements ITileEntityProvider,
IDungeonFogBlock,
IAspectFogBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");

    public BlockCenser() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.func_175625_s(pos) instanceof TileEntityCenser) {
            FluidActionResult fluidActionResult;
            IItemHandler playerInventory;
            IFluidHandler handler;
            TileEntityCenser tile = (TileEntityCenser)world.func_175625_s(pos);
            if (player.func_70093_af()) {
                return false;
            }
            if (!heldItem.func_190926_b() && (handler = (IFluidHandler)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && (fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)tile, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (!world.field_72995_K ? 1 : 0) != 0)).isSuccess()) {
                if (!world.field_72995_K) {
                    player.func_184611_a(hand, fluidActionResult.getResult());
                }
                return true;
            }
            if (!world.field_72995_K && tile != null) {
                player.openGui((Object)TheBetweenlands.instance, 15, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            if (2 < inventory.func_70302_i_()) {
                inventory.func_70299_a(2, ItemStack.field_190927_a);
            }
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)inventory);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 8 : 0);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean enabled;
        boolean bl = enabled = !worldIn.func_175640_z(pos);
        if (enabled != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCenser();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ENABLED});
    }

    @Override
    public boolean isCreatingDungeonFog(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCenser) {
            return ((TileEntityCenser)te).getDungeonFogStrength(1.0f) >= 0.1f;
        }
        return false;
    }

    @Override
    public IAspectType getAspectFogType(IBlockAccess world, BlockPos pos, IBlockState state) {
        ICenserRecipe<Object> recipe;
        TileEntityCenser censer;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCenser && (censer = (TileEntityCenser)te).isRecipeRunning() && (recipe = censer.getCurrentRecipe()) != null) {
            return recipe.getAspectFogType(censer.getCurrentRecipeContext(), censer);
        }
        return null;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        ICenserRecipe<Object> recipe;
        TileEntityCenser censer;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityCenser && (censer = (TileEntityCenser)te).isRecipeRunning() && (recipe = censer.getCurrentRecipe()) != null) {
            int fogColor = recipe.getEffectColor(censer.getCurrentRecipeContext(), censer, ICenserRecipe.EffectColorType.FOG);
            float r = (float)(fogColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(fogColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(fogColor >> 0 & 0xFF) / 255.0f;
            for (int i = 0; i < 3 + rand.nextInt(5); ++i) {
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.SMOOTH_SMOKE.create(worldIn, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() - 0.5f) * 0.08f, rand.nextFloat() * 0.01f + 0.005f, (rand.nextFloat() - 0.5f) * 0.08f)).withScale(2.0f + rand.nextFloat() * 8.0f)).withColor(r, g, b, 0.1f)).withData(80, true, Float.valueOf(0.05f), true)));
            }
        }
    }
}

