/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityMortar;

public class BlockMortar
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockMortar() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TileEntityMortar) {
            TileEntityMortar tile = (TileEntityMortar)worldIn.func_175625_s(pos);
            tile.manualGrinding = true;
            IBlockState state = worldIn.func_180495_p(pos);
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (worldIn.func_175625_s(pos) instanceof TileEntityMortar) {
            TileEntityMortar tile = (TileEntityMortar)worldIn.func_175625_s(pos);
            if (!playerIn.func_184586_b(hand).func_190926_b()) {
                if (playerIn.func_184586_b(hand).func_77973_b() == ItemRegistry.PESTLE && tile.func_70301_a(1).func_190926_b()) {
                    tile.func_70299_a(1, playerIn.func_184586_b(hand));
                    tile.hasPestle = true;
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                } else if (playerIn.func_184586_b(hand).func_77973_b() == ItemRegistry.LIFE_CRYSTAL && tile.func_70301_a(3).func_190926_b()) {
                    tile.func_70299_a(3, playerIn.func_184586_b(hand));
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    playerIn.openGui((Object)TheBetweenlands.instance, 8, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else {
                playerIn.openGui((Object)TheBetweenlands.instance, 8, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IInventory tile = (IInventory)world.func_175625_s(pos);
        if (tile != null) {
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack stack = tile.func_70301_a(i);
                if (stack.func_190926_b() || world.field_72995_K) continue;
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                if (stack.func_77973_b() == ItemRegistry.PESTLE) {
                    stack.func_77978_p().func_74757_a("active", false);
                }
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntityMortar tile = (TileEntityMortar)world.func_175625_s(pos);
        if (tile.progress > 0 && rand.nextInt(3) == 0) {
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 1.1f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMortar();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

