/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityRepeller;

public class BlockRepeller
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<BlockSlab.EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockSlab.EnumBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, 1.0, (double)0.85f);
    protected static final AxisAlignedBB AABB_TOP = new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, (double)0.7f, (double)0.85f);

    public BlockRepeller() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP ? AABB_TOP : AABB_BOTTOM;
    }

    public TileEntity func_149915_a(World world, int meta) {
        IBlockState state = this.func_176203_a(meta);
        if (state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.BOTTOM) {
            return new TileEntityRepeller();
        }
        return null;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.TOP).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            this.func_180639_a(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), player, hand, facing, hitX, hitY, hitZ);
        } else if (state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.BOTTOM) {
            TileEntityRepeller tile = (TileEntityRepeller)world.func_175625_s(pos);
            ItemStack held = player.func_184586_b(hand);
            if (!player.func_70093_af() && !held.func_190926_b()) {
                if (held.func_77973_b() == ItemRegistry.SHIMMER_STONE) {
                    if (!tile.hasShimmerstone()) {
                        tile.addShimmerstone();
                        if (!player.field_71075_bZ.field_75098_d) {
                            held.func_190918_g(1);
                            if (held.func_190916_E() <= 0) {
                                player.func_184611_a(hand, ItemStack.field_190927_a);
                            }
                        }
                    }
                    return true;
                }
                if (held.func_77973_b() == ItemRegistry.ASPECT_VIAL) {
                    if (tile.hasShimmerstone()) {
                        int loss;
                        ItemAspectContainer aspectContainer;
                        int amount;
                        if (tile.getFuel() < tile.getMaxFuel() && (amount = (aspectContainer = ItemAspectContainer.fromItem(held)).get(AspectRegistry.BYARIIS)) >= (loss = 10)) {
                            if (!world.field_72995_K) {
                                int added = tile.addFuel(amount - loss);
                                if (!player.field_71075_bZ.field_75098_d) {
                                    int leftAmount = amount - added - loss;
                                    if (leftAmount > 0) {
                                        aspectContainer.set(AspectRegistry.BYARIIS, leftAmount);
                                    } else {
                                        player.func_184611_a(hand, held.func_77973_b().getContainerItem(held));
                                    }
                                }
                            }
                            player.func_184609_a(hand);
                            return true;
                        }
                    } else if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.repeller.shimmerstone_missing", new Object[0]), true);
                    }
                } else if (held.func_77973_b() == ItemRegistry.DENTROTHYST_VIAL && tile.getFuel() > 0 && (held.func_77952_i() == 0 || held.func_77952_i() == 2)) {
                    ItemStack newStack = new ItemStack((Item)ItemRegistry.ASPECT_VIAL, 1, held.func_77952_i() == 0 ? 0 : 1);
                    if (!world.field_72995_K) {
                        ItemAspectContainer aspectContainer = ItemAspectContainer.fromItem(newStack);
                        aspectContainer.set(AspectRegistry.BYARIIS, tile.removeFuel(5000));
                    }
                    held.func_190918_g(1);
                    if (held.func_190916_E() <= 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    if (!player.field_71071_by.func_70441_a(newStack)) {
                        player.func_71019_a(newStack, false);
                    }
                    return true;
                }
            } else {
                if (player.func_70093_af() && held.func_190926_b() && tile.hasShimmerstone()) {
                    tile.removeShimmerstone();
                    ItemStack stack = new ItemStack(ItemRegistry.SHIMMER_STONE, 1);
                    if (!player.field_71071_by.func_70441_a(stack)) {
                        player.func_71019_a(stack, false);
                    }
                    return true;
                }
                if (!player.func_70093_af() && held.func_190926_b()) {
                    if (!world.field_72995_K) {
                        tile.cycleRadiusState();
                    }
                    player.func_184609_a(hand);
                }
            }
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndBreakBlock(worldIn, pos);
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    protected void checkAndBreakBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.func_177229_b(HALF);
        if (half == BlockSlab.EnumBlockHalf.BOTTOM && (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) || world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) || half == BlockSlab.EnumBlockHalf.TOP && world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            this.func_180663_b(world, pos, state);
            world.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityRepeller tile;
        if (!worldIn.field_72995_K && (tile = (TileEntityRepeller)worldIn.func_175625_s(pos)) != null) {
            EntityItem entityitem;
            double d2;
            double d1;
            double d0;
            float f = 0.7f;
            if (tile.hasShimmerstone()) {
                d0 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                d1 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                d2 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack(ItemRegistry.SHIMMER_STONE, 1));
                entityitem.func_174869_p();
                worldIn.func_72838_d((Entity)entityitem);
            }
            d0 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d1 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d2 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack(BlockRegistry.REPELLER, 1));
            entityitem.func_174869_p();
            worldIn.func_72838_d((Entity)entityitem);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntityRepeller tile;
        IBlockState state;
        if (rand.nextInt(6) == 0 && (state = worldIn.func_180495_p(pos)).func_177229_b(HALF) == BlockSlab.EnumBlockHalf.BOTTOM && (tile = (TileEntityRepeller)worldIn.func_175625_s(pos)) != null && tile.isRunning()) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            for (int i = 0; i < 60; ++i) {
                float rot = (float)(0.10471975511965977 * (double)i + Math.PI * (double)rand.nextFloat() / 60.0);
                double radius = Math.max((double)tile.getRadius(0.0f), 1.0);
                double rotX = Math.sin(rot) * radius;
                double rotZ = Math.cos(rot) * radius;
                double xOff = (float)(-facing.func_82601_c()) * 0.23f;
                double zOff = (float)facing.func_82599_e() * 0.23f;
                double centerX = (double)((float)pos.func_177958_n() + 0.5f) + xOff;
                double centerY = (float)pos.func_177956_o() + 1.3f;
                double centerZ = (double)((float)pos.func_177952_p() + 0.5f) - zOff;
                ArrayList<Vec3d> points = new ArrayList<Vec3d>();
                points.add(new Vec3d(centerX, centerY, centerZ));
                points.add(new Vec3d(centerX, centerY + radius, centerZ));
                points.add(new Vec3d(centerX + rotX, centerY + radius, centerZ + rotZ));
                points.add(new Vec3d(centerX + rotX, (double)pos.func_177956_o() + 0.1, centerZ + rotZ));
                BLParticles.ANIMATOR.spawn(worldIn, centerX, centerY, centerZ, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(points));
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF});
    }

    public IBlockState func_176203_a(int meta) {
        int facing = meta >> 1 & 3;
        boolean isUpper = (meta & 1) == 1;
        return this.func_176223_P().func_177226_a(HALF, (Comparable)(isUpper ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)facing));
    }

    public int func_176201_c(IBlockState state) {
        int facing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        boolean isUpper = state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP;
        int meta = facing << 1;
        return meta |= isUpper ? 1 : 0;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRepeller) {
            TileEntityRepeller repeller = (TileEntityRepeller)tile;
            return Math.round((float)repeller.getFuel() / (float)repeller.getMaxFuel() * 16.0f);
        }
        return 0;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

