/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;

public class BlockBrazier
extends Block {
    public static final PropertyEnum<EnumBrazierHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBrazierHalf.class);

    public BlockBrazier() {
        super(Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)((Object)EnumBrazierHalf.LOWER)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177229_b(HALF) == EnumBrazierHalf.UPPER && side == EnumFacing.UP;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBrazierHalf.UPPER)), 2);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() == null || !world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        return state.func_185904_a().func_76230_c();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.dropBrazierIfCantStay(world, state, pos);
    }

    protected boolean dropBrazierIfCantStay(World world, IBlockState state, BlockPos pos) {
        if (world.func_175623_d(pos.func_177977_b())) {
            world.func_175698_g(pos);
            if (state.func_177229_b(HALF) == EnumBrazierHalf.LOWER) {
                this.func_176226_b(world, pos, state, 0);
            }
            return false;
        }
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == EnumBrazierHalf.UPPER && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_175698_g(pos.func_177977_b());
            } else {
                world.func_175655_b(pos.func_177977_b(), true);
                if (world.field_72995_K) {
                    world.func_175698_g(pos.func_177977_b());
                }
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(HALF) == EnumBrazierHalf.UPPER) {
            return Items.field_190931_a;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public IBlockState func_176203_a(int meta) {
        return meta > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBrazierHalf.UPPER)) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBrazierHalf.LOWER));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b(HALF) == EnumBrazierHalf.UPPER && (iblockstate = world.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
            return state;
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(HALF) == EnumBrazierHalf.UPPER ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP && state.func_177229_b(HALF) == EnumBrazierHalf.UPPER;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && state.func_177229_b(HALF) == EnumBrazierHalf.UPPER ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public static enum EnumBrazierHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

