/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class BlockEnergyBarrier
extends Block {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockEnergyBarrier() {
        super(Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149663_c("thebetweenlands.energy_barrier");
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149715_a(0.8f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double particleX = (float)pos.func_177958_n() + rand.nextFloat();
        double particleY = (float)pos.func_177956_o() + rand.nextFloat();
        double particleZ = (float)pos.func_177952_p() + rand.nextFloat();
        double motionX = ((double)rand.nextFloat() - 0.5) * 0.5;
        double motionY = ((double)rand.nextFloat() - 0.5) * 0.5;
        double motionZ = ((double)rand.nextFloat() - 0.5) * 0.5;
        int multiplier = rand.nextInt(2) * 2 - 1;
        if (world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c() != this && world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c() != this) {
            particleX = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)multiplier;
            motionX = rand.nextFloat() * 2.0f * (float)multiplier;
        } else {
            particleZ = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)multiplier;
            motionZ = rand.nextFloat() * 2.0f * (float)multiplier;
        }
        BLParticles.PORTAL.spawn(world, particleX, particleY, particleZ, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(motionX * (double)0.2f, motionY, motionZ * (double)0.2f));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BOUNDS;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return field_185505_j.func_186670_a(pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            EnumHand swordHand = null;
            for (EnumHand hand : EnumHand.values()) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.SHOCKWAVE_SWORD) continue;
                swordHand = hand;
                break;
            }
            if (swordHand != null) {
                int data = Block.func_149682_b((Block)world.func_180495_p(pos).func_177230_c());
                if (!world.field_72995_K) {
                    world.func_180498_a(null, 2001, pos, data);
                }
                int range = 7;
                for (int x = -range; x < range; ++x) {
                    for (int y = -range; y < range; ++y) {
                        for (int z = -range; z < range; ++z) {
                            BlockPos offset = pos.func_177982_a(x, y, z);
                            IBlockState blockState = world.func_180495_p(offset);
                            if (blockState.func_177230_c() != this) continue;
                            if (blockState.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                                for (int i = 0; i < 8; ++i) {
                                    world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)offset.func_177958_n() + (double)world.field_73012_v.nextFloat(), (double)offset.func_177956_o() + (double)world.field_73012_v.nextFloat(), (double)offset.func_177952_p() + (double)world.field_73012_v.nextFloat(), (double)world.field_73012_v.nextFloat() - 0.5, (double)world.field_73012_v.nextFloat() - 0.5, (double)world.field_73012_v.nextFloat() - 0.5, new int[]{Block.func_176210_f((IBlockState)blockState)});
                                }
                            }
                            if (world.field_72995_K) continue;
                            world.func_175698_g(offset);
                        }
                    }
                }
            } else if (!player.func_175149_v()) {
                entity.func_70097_a(DamageSource.field_76376_m, 1.0f);
                double dx = (entity.field_70165_t - (double)pos.func_177958_n()) * 2.0 - 1.0;
                double dz = (entity.field_70161_v - (double)pos.func_177952_p()) * 2.0 - 1.0;
                if (Math.abs(dx) > Math.abs(dz)) {
                    dz = 0.0;
                } else {
                    dx = 0.0;
                }
                dx = (int)dx;
                dz = (int)dz;
                entity.func_70024_g(dx * 0.85, 0.08, dz * 0.85);
                entity.func_184185_a((SoundEvent)SoundRegistry.REJECTED, 0.5f, 1.0f);
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

