/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.ItemBlockEnum;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockMudTiles
extends Block
implements BlockRegistry.ICustomItemBlock,
BlockRegistry.ISubtypeItemBlockModelDefinition {
    public static final PropertyEnum<EnumMudTileType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMudTileType.class);
    public static final PropertyBool CONNECTED_DOWN = PropertyBool.func_177716_a((String)"connected_down");
    public static final PropertyBool CONNECTED_UP = PropertyBool.func_177716_a((String)"connected_up");
    public static final PropertyBool CONNECTED_NORTH = PropertyBool.func_177716_a((String)"connected_north");
    public static final PropertyBool CONNECTED_SOUTH = PropertyBool.func_177716_a((String)"connected_south");
    public static final PropertyBool CONNECTED_WEST = PropertyBool.func_177716_a((String)"connected_west");
    public static final PropertyBool CONNECTED_EAST = PropertyBool.func_177716_a((String)"connected_east");

    public BlockMudTiles() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumMudTileType.MUD_TILES)).func_177226_a((IProperty)CONNECTED_DOWN, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_EAST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_NORTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_UP, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_WEST, (Comparable)Boolean.FALSE));
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumMudTileType type : EnumMudTileType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((EnumMudTileType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumMudTileType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMudTileType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        return state.func_177226_a((IProperty)CONNECTED_DOWN, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.DOWN))).func_177226_a((IProperty)CONNECTED_EAST, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.EAST))).func_177226_a((IProperty)CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.NORTH))).func_177226_a((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.SOUTH))).func_177226_a((IProperty)CONNECTED_UP, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.UP))).func_177226_a((IProperty)CONNECTED_WEST, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.WEST)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, CONNECTED_DOWN, CONNECTED_UP, CONNECTED_NORTH, CONNECTED_SOUTH, CONNECTED_WEST, CONNECTED_EAST});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumMudTileType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    private boolean isSideConnectable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateConnection = world.func_180495_p(pos.func_177972_a(side));
        if (stateConnection.func_177230_c() == this && state.func_177230_c() == this) {
            if (!(state.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES && state.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_CRACKED || stateConnection.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_DECAY && stateConnection.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_CRACKED_DECAY && stateConnection.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES && stateConnection.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_CRACKED)) {
                return false;
            }
            if (!(state.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_DECAY && state.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_CRACKED_DECAY || stateConnection.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES && stateConnection.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_CRACKED)) {
                return false;
            }
        }
        return stateConnection == null ? false : stateConnection.func_177230_c() == this;
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        if (!(entity instanceof IEntityBL || state.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_DECAY && state.func_177229_b(VARIANT) != EnumMudTileType.MUD_TILES_CRACKED_DECAY)) {
            return 0.98f;
        }
        return 0.6f;
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create(this, EnumMudTileType.class);
    }

    @Override
    public int getSubtypeNumber() {
        return EnumMudTileType.values().length;
    }

    @Override
    public String getSubtypeName(int meta) {
        return EnumMudTileType.values()[meta].func_176610_l();
    }

    public static enum EnumMudTileType implements IStringSerializable
    {
        MUD_TILES,
        MUD_TILES_DECAY,
        MUD_TILES_CRACKED,
        MUD_TILES_CRACKED_DECAY;

        private final String name = this.name().toLowerCase(Locale.ENGLISH);

        public int getMetadata() {
            return this.ordinal();
        }

        public String toString() {
            return this.name;
        }

        public static EnumMudTileType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= EnumMudTileType.values().length) {
                metadata = 0;
            }
            return EnumMudTileType.values()[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

