/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;

public class BlockWoodenSupportBeam
extends BlockHorizontal {
    private static final AxisAlignedBB[] SELECTION_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.28, 0.0, 0.0, 0.72, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.28, 1.0, 1.0, 0.72)};
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");

    public BlockWoodenSupportBeam() {
        this(Material.field_151575_d);
    }

    public BlockWoodenSupportBeam(Material material) {
        super(material);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(BLCreativeTabs.PLANTS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        return SELECTION_AABB[facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 1];
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isBurning(world, pos) ? PathNodeType.DAMAGE_FIRE : PathNodeType.OPEN;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing);
        if (this.canPlaceAt(world, pos, facing)) {
            return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)) : state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P();
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && this.canPlaceAt(worldIn, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return false;
    }

    private boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean isSide = facing.func_176740_k().func_176722_c();
        return isSide && world.func_180495_p(blockpos).isSideSolid((IBlockAccess)world, blockpos, facing);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_185512_D);
        if (!this.canPlaceAt(world, pos, facing)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta & 3));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, TOP});
    }
}

