/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.terrain.BlockSludgyDirt;
import thebetweenlands.common.block.terrain.BlockSpreadingDeath;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class BlockSpreadingSludgyDirt
extends BlockSpreadingDeath {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockSpreadingSludgyDirt() {
        super(Material.field_151577_b);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 0);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149675_a(true);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175699_k(pos.func_177984_a()) < 4 && world.getBlockLightOpacity(pos.func_177984_a()) > 2) {
            world.func_175656_a(pos, BlockRegistry.SWAMP_DIRT.func_176223_P());
            this.checkAndRevertBiome(world, pos);
        } else {
            super.func_180650_b(world, pos, state, rand);
        }
    }

    @Override
    public boolean canSpreadInto(World world, BlockPos pos, IBlockState state, BlockPos offsetPos, IBlockState offsetState) {
        return super.canSpreadInto(world, pos, state, offsetPos, offsetState) && SurfaceType.GRASS_AND_DIRT.matches(offsetState);
    }

    @Override
    public void spreadInto(World world, BlockPos pos, IBlockState state, BlockPos offsetPos, IBlockState offsetState) {
        world.func_175656_a(offsetPos, this.func_176223_P());
        for (int yo = 1; yo < 6; ++yo) {
            if (!this.canSpreadInto(world, pos, state, offsetPos.func_177979_c(yo), world.func_180495_p(offsetPos.func_177979_c(yo)))) continue;
            world.func_175656_a(offsetPos.func_177979_c(yo), BlockRegistry.MUD.func_176223_P());
        }
        if (world.field_73012_v.nextInt(3) == 0 && world.func_175623_d(offsetPos.func_177984_a())) {
            world.func_175656_a(offsetPos.func_177984_a(), BlockRegistry.DEAD_WEEDWOOD_BUSH.func_176223_P());
        }
    }

    @Override
    protected boolean shouldSpread(World world, BlockPos pos, IBlockState state) {
        return world.field_73012_v.nextInt(2) == 0;
    }

    @Override
    public Biome getSpreadingBiome() {
        return BiomeRegistry.SLUDGE_PLAINS;
    }

    @Override
    public Biome getPreviousBiome() {
        return BiomeRegistry.SWAMPLANDS_CLEARING;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BlockRegistry.SWAMP_DIRT.func_180660_a(state, rand, fortune);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(entity instanceof IEntityBL)) {
            entity.func_70110_aj();
        }
    }

    public boolean func_149662_c(IBlockState s) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess iblockaccess, BlockPos pos, EnumFacing side) {
        Block block = iblockaccess.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return !(block instanceof BlockSludgyDirt) && !(block instanceof BlockSpreadingSludgyDirt);
    }
}

