/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.structure.BlockCompactedMudSlope;
import thebetweenlands.common.entity.EntityProximitySpawner;
import thebetweenlands.common.entity.mobs.EntityCryptCrawler;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.structure.utils.SludgeWormMazeBlockHelper;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class EntityCCGroundSpawner
extends EntityProximitySpawner {
    private static final byte EVENT_GOOP_PARTICLES = 100;
    private static final DataParameter<Boolean> IS_WORLD_SPANWED = EntityDataManager.func_187226_a(EntityCCGroundSpawner.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SPAWN_COUNT = EntityDataManager.func_187226_a(EntityCCGroundSpawner.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CAN_BE_REMOVED_SAFELY = EntityDataManager.func_187226_a(EntityCCGroundSpawner.class, (DataSerializer)DataSerializers.field_187198_h);
    private SludgeWormMazeBlockHelper blockHelper = new SludgeWormMazeBlockHelper(null);

    public EntityCCGroundSpawner(World world) {
        super(world);
        this.func_70105_a(3.0f, 0.5f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_WORLD_SPANWED, (Object)true);
        this.field_70180_af.func_187214_a(SPAWN_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(CAN_BE_REMOVED_SAFELY, (Object)false);
    }

    public boolean func_70601_bi() {
        int solidCount = 0;
        BlockPos pos = new BlockPos((Entity)this);
        if (pos.func_177956_o() < 110) {
            return false;
        }
        for (int xo = -1; xo <= 1; ++xo) {
            for (int zo = -1; zo <= 1; ++zo) {
                BlockPos offsetPos = pos.func_177982_a(xo, 0, zo);
                IBlockState state = this.field_70170_p.func_180495_p(offsetPos);
                if (state.func_185904_a().func_76224_d()) {
                    return false;
                }
                if (SurfaceType.MIXED_GROUND.apply(state)) {
                    ++solidCount;
                } else if (xo == 0 && zo == 0) {
                    return false;
                }
                if (this.field_70170_p.func_175623_d(offsetPos.func_177984_a())) continue;
                return false;
            }
        }
        return solidCount >= 6;
    }

    public boolean func_70058_J() {
        return true;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            List listPlug;
            if (this.isWorldSpawned() && !this.isSpawnEventActive(this.func_130014_f_())) {
                this.func_70106_y();
            }
            if (this.func_130014_f_().func_82737_E() % 60L == 0L) {
                this.checkArea();
            }
            if (!(listPlug = this.func_130014_f_().func_72872_a(EntityFallingBlock.class, this.func_174813_aQ())).isEmpty()) {
                this.func_130014_f_().func_175698_g(this.func_180425_c());
                this.func_70106_y();
            }
        }
        this.func_70107_b((double)MathHelper.func_76128_c((double)this.field_70165_t) + 0.5, MathHelper.func_76128_c((double)this.field_70163_u), (double)MathHelper.func_76128_c((double)this.field_70161_v) + 0.5);
        this.field_70169_q = this.field_70142_S = this.field_70165_t;
        this.field_70167_r = this.field_70137_T = this.field_70163_u;
        this.field_70166_s = this.field_70136_U = this.field_70161_v;
    }

    public boolean isSpawnEventActive(World world) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        return worldStorage.getEnvironmentEventRegistry().bloodSky.isActive();
    }

    @Override
    @Nullable
    protected Entity checkArea() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getCanBeRemovedSafely() && this.canBeRemovedNow()) {
                this.func_70106_y();
            }
            if (this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
                if (this.isWorldSpawned() && !this.isSpawnEventActive(this.func_130014_f_())) {
                    return null;
                }
                List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.proximityBox());
                if (list.stream().filter(e -> e instanceof EntityCryptCrawler).count() >= 4L) {
                    return null;
                }
                for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                    Entity entity = (Entity)list.get(entityCount);
                    if (entity == null || !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_175149_v() || ((EntityPlayer)entity).func_184812_l_()) continue;
                    if (this.canSneakPast() && entity.func_70093_af()) {
                        return null;
                    }
                    if (this.checkSight() && !this.func_70685_l(entity) || this.getCanBeRemovedSafely()) {
                        return null;
                    }
                    for (int count = 0; count < this.getEntitySpawnCount(); ++count) {
                        Entity spawn = this.getEntitySpawned();
                        if (spawn == null) continue;
                        this.performPreSpawnaction(entity, spawn);
                        if (!spawn.field_70128_L) {
                            this.func_130014_f_().func_72838_d(spawn);
                        }
                        this.performPostSpawnaction(entity, spawn);
                    }
                }
            }
        }
        return null;
    }

    public boolean canBeRemovedNow() {
        AxisAlignedBB dead_zone = this.func_174813_aQ().func_72314_b(0.0, 1.0, 0.0).func_72317_d(0.0, -0.5, 0.0);
        List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, dead_zone);
        return list.stream().filter(e -> e instanceof EntityCryptCrawler).count() < 1L;
    }

    public float func_70047_e() {
        return this.field_70131_O + 0.5f;
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity sourceEntity;
        if (source instanceof EntityDamageSource && (sourceEntity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer && ((EntityPlayer)sourceEntity).func_184812_l_()) {
            this.setCanBeRemovedSafely(true);
        }
        return false;
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof EntityFallingBlock && !this.func_130014_f_().field_72995_K) {
            this.setCanBeRemovedSafely(true);
        }
    }

    @Override
    protected void performPreSpawnaction(Entity targetEntity, Entity entitySpawned) {
        if (this.isWorldSpawned()) {
            this.setSpawnCount(this.getSpawnCount() + 1);
        }
        this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), this.getDigSound(), SoundCategory.HOSTILE, 0.5f, 1.0f);
        entitySpawned.func_70107_b((double)((float)this.func_180425_c().func_177958_n() + 0.5f), (double)((float)this.func_180425_c().func_177956_o() - 1.5f), (double)((float)this.func_180425_c().func_177952_p() + 0.5f));
    }

    protected SoundEvent getDigSound() {
        return SoundRegistry.CRYPT_CRAWLER_DIG;
    }

    @Override
    protected void performPostSpawnaction(Entity targetEntity, @Nullable Entity entitySpawned) {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
            entitySpawned.field_70181_x += 0.5;
            if (this.isWorldSpawned() && this.getSpawnCount() >= this.maxUseCount()) {
                this.setCanBeRemovedSafely(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 100) {
            for (int count = 0; count <= 200; ++count) {
                Particle fx = new ParticleBreaking.SnowballFactory().func_178902_a(EnumParticleTypes.SNOWBALL.func_179348_c(), this.field_70170_p, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() + 0.25, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), 0.0, 0.0, 0.0, new int[]{0});
                fx.func_70538_b(48.0f, 64.0f, 91.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
            }
        }
    }

    @Override
    protected float getProximityHorizontal() {
        return 8.0f;
    }

    @Override
    protected float getProximityVertical() {
        return 2.0f;
    }

    @Override
    protected boolean canSneakPast() {
        return false;
    }

    @Override
    protected boolean checkSight() {
        return true;
    }

    @Override
    protected Entity getEntitySpawned() {
        EntityCryptCrawler crawler = new EntityCryptCrawler(this.func_130014_f_());
        crawler.func_180482_a(this.func_130014_f_().func_175649_E(this.func_180425_c()), null);
        return crawler;
    }

    @Override
    protected int getEntitySpawnCount() {
        return 1;
    }

    @Override
    protected boolean isSingleUse() {
        return false;
    }

    @Override
    protected int maxUseCount() {
        return 5;
    }

    public void setIsWorldSpawned(boolean world_spawned) {
        this.field_70180_af.func_187227_b(IS_WORLD_SPANWED, (Object)world_spawned);
    }

    public boolean isWorldSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_WORLD_SPANWED);
    }

    public void setSpawnCount(int spawn_count) {
        this.field_70180_af.func_187227_b(SPAWN_COUNT, (Object)spawn_count);
    }

    public int getSpawnCount() {
        return (Integer)this.field_70180_af.func_187225_a(SPAWN_COUNT);
    }

    public void setCanBeRemovedSafely(boolean safe) {
        this.field_70180_af.func_187227_b(CAN_BE_REMOVED_SAFELY, (Object)safe);
    }

    public boolean getCanBeRemovedSafely() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_BE_REMOVED_SAFELY);
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K && this.isWorldSpawned() && this.getEntityData().func_74764_b("tempBlockTypes")) {
            this.loadOriginBlocks(this.func_130014_f_(), this.getEntityData());
        }
        super.func_70106_y();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            this.getOriginBlocks(this.func_130014_f_(), this.func_180425_c());
            this.func_130014_f_().func_175656_a(this.func_180425_c(), this.blockHelper.AIR);
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, -1, 0), this.blockHelper.COMPACTED_MUD);
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(-1, 0, -1), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, 0, -1), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(1, 0, -1), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(-1, 0, 1), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, 0, 1), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(1, 0, 1), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(-1, 0, 0), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(1, 0, 0), this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        }
        return livingdata;
    }

    private void getOriginBlocks(World world, BlockPos pos) {
        NBTTagList tagList = new NBTTagList();
        NBTTagCompound entityNbt = this.getEntityData();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    IBlockState state = world.func_180495_p(pos.func_177982_a(x, -y, z));
                    NBTTagCompound tag = new NBTTagCompound();
                    NBTUtil.func_190009_a((NBTTagCompound)tag, (IBlockState)state);
                    tagList.func_74742_a((NBTBase)tag);
                }
            }
        }
        if (!tagList.func_82582_d()) {
            entityNbt.func_74782_a("tempBlockTypes", (NBTBase)tagList);
            NBTTagCompound nbttagcompoundPos = NBTUtil.func_186859_a((BlockPos)pos);
            entityNbt.func_74782_a("originPos", (NBTBase)nbttagcompoundPos);
        }
        this.func_70014_b(entityNbt);
    }

    public void loadOriginBlocks(World world, NBTTagCompound tag) {
        NBTTagCompound entityNbt = this.getEntityData();
        NBTTagCompound nbttagcompoundPos = entityNbt.func_74775_l("originPos");
        BlockPos origin = NBTUtil.func_186861_c((NBTTagCompound)nbttagcompoundPos);
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        NBTTagList tagList = entityNbt.func_150295_c("tempBlockTypes", 10);
        for (int indexCount = 0; indexCount < tagList.func_74745_c(); ++indexCount) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(indexCount);
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)nbttagcompound);
            list.add(indexCount, state);
        }
        int a = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    world.func_180501_a(origin.func_177982_a(x, -y, z), (IBlockState)list.get(a++), 3);
                }
            }
        }
        this.func_130014_f_().func_184133_a((EntityPlayer)null, origin, (SoundEvent)SoundRegistry.ROOF_COLLAPSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("world_spawned", 1)) {
            this.setIsWorldSpawned(nbt.func_74767_n("world_spawned"));
        }
        if (nbt.func_150297_b("remove_safely", 1)) {
            this.setCanBeRemovedSafely(nbt.func_74767_n("remove_safely"));
        }
        this.setSpawnCount(nbt.func_74762_e("spawn_count"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("world_spawned", this.isWorldSpawned());
        nbt.func_74757_a("remove_safely", this.getCanBeRemovedSafely());
        nbt.func_74768_a("spawn_count", this.getSpawnCount());
    }
}

