/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.entity.ai.IPathObstructionAwareEntity;
import thebetweenlands.common.entity.ai.ObstructionAwareWalkNodeProcessor;

public class ObstructionAwarePathNavigateGround<T extends EntityLiving>
extends PathNavigateGround {
    protected final T callbackEntity;
    protected int stuckCheckTicks = 0;

    public ObstructionAwarePathNavigateGround(T entity, World worldIn) {
        super(entity, worldIn);
        this.callbackEntity = entity;
        if (this.field_179695_a instanceof ObstructionAwareWalkNodeProcessor) {
            ((ObstructionAwareWalkNodeProcessor)this.field_179695_a).setCallback(entity);
        }
    }

    protected PathFinder func_179679_a() {
        this.field_179695_a = new ObstructionAwareWalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        return new PathFinder(this.field_179695_a);
    }

    protected void func_179677_a(Vec3d entityPos) {
        super.func_179677_a(entityPos);
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vec3d checkPos;
            Vec3d target = this.field_75514_c.func_75881_a(this.callbackEntity, Math.min(this.field_75514_c.func_75874_d() - 1, this.field_75514_c.func_75873_e() + 0));
            Vec3d diff = target.func_178788_d(entityPos);
            int axis = 0;
            double maxDiff = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d;
                switch (i) {
                    default: {
                        d = Math.abs(diff.field_72450_a);
                        break;
                    }
                    case 1: {
                        d = Math.abs(diff.field_72448_b);
                        break;
                    }
                    case 2: {
                        d = Math.abs(diff.field_72449_c);
                    }
                }
                if (!(d > maxDiff)) continue;
                axis = i;
                maxDiff = d;
            }
            int height = MathHelper.func_76141_d((float)(((EntityLiving)this.callbackEntity).field_70131_O + 1.0f));
            int ceilHalfWidth = MathHelper.func_76123_f((float)(((EntityLiving)this.callbackEntity).field_70130_N / 2.0f + 0.05f));
            switch (axis) {
                default: {
                    checkPos = new Vec3d(entityPos.field_72450_a + Math.signum(diff.field_72450_a) * (double)ceilHalfWidth, entityPos.field_72448_b, target.field_72449_c);
                    break;
                }
                case 1: {
                    checkPos = new Vec3d(entityPos.field_72450_a, entityPos.field_72448_b + (double)(diff.field_72448_b > 0.0 ? height + 1 : -1), target.field_72449_c);
                    break;
                }
                case 2: {
                    checkPos = new Vec3d(target.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c + Math.signum(diff.field_72449_c) * (double)ceilHalfWidth);
                }
            }
            Vec3d facingDiff = checkPos.func_178788_d(entityPos.func_72441_c(0.0, axis == 1 ? (double)(this.field_75515_a.field_70131_O / 2.0f) : 0.0, 0.0));
            EnumFacing facing = EnumFacing.func_176737_a((float)((float)facingDiff.field_72450_a), (float)((float)facingDiff.field_72448_b), (float)((float)facingDiff.field_72449_c));
            boolean blocked = false;
            block9: for (int yo = 0; yo < height; ++yo) {
                for (int xzo = -ceilHalfWidth; xzo <= ceilHalfWidth; ++xzo) {
                    AxisAlignedBB collisionBox;
                    PathNodeType nodeType;
                    BlockPos pos = new BlockPos(checkPos.field_72450_a + (double)(axis != 0 ? xzo : 0), checkPos.field_72448_b + (double)(axis != 1 ? yo : 0), checkPos.field_72449_c + (double)(axis != 2 ? xzo : 0));
                    IBlockState state = ((EntityLiving)this.callbackEntity).field_70170_p.func_180495_p(pos);
                    PathNodeType pathNodeType = nodeType = state.func_177230_c().func_176205_b((IBlockAccess)((EntityLiving)this.callbackEntity).field_70170_p, pos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
                    if (nodeType != PathNodeType.BLOCKED || (collisionBox = state.func_185890_d((IBlockAccess)((EntityLiving)this.callbackEntity).field_70170_p, pos)) == null || !collisionBox.func_186670_a(pos).func_72326_a(this.callbackEntity.func_174813_aQ().func_72321_a(Math.signum(diff.field_72450_a) * 0.2, Math.signum(diff.field_72448_b) * 0.2, Math.signum(diff.field_72449_c) * 0.2))) continue;
                    blocked = true;
                    break block9;
                }
            }
            if (blocked) {
                ++this.stuckCheckTicks;
                if (this.stuckCheckTicks > ((IPathObstructionAwareEntity)this.callbackEntity).getMaxStuckCheckTicks()) {
                    ((IPathObstructionAwareEntity)this.callbackEntity).onPathingObstructed(facing);
                    this.stuckCheckTicks = 0;
                }
            } else {
                this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 2, 0);
            }
        } else {
            this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 4, 0);
        }
    }

    public static interface PathObstructionCallback {
        public void onPathObstructed();
    }
}

