/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.draeton;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import thebetweenlands.api.entity.IPullerEntity;
import thebetweenlands.common.entity.draeton.EntityDraeton;

public class DraetonPhysicsPart {
    public final Type type;
    public final EntityDraeton carriage;
    private Entity entity;
    public final int slot;
    public final int id;
    public double prevX;
    public double prevY;
    public double prevZ;
    public double x;
    public double y;
    public double z;
    public double motionX;
    public double motionY;
    public double motionZ;
    public int lerpSteps;
    public double lerpX;
    public double lerpY;
    public double lerpZ;
    public boolean isActive = true;
    public boolean grounded = false;

    public DraetonPhysicsPart(Type type, EntityDraeton carriage, int id, int slot) {
        this.type = type;
        this.carriage = carriage;
        this.id = id;
        this.slot = slot;
    }

    public void setEntity(IPullerEntity entity) {
        if (entity instanceof Entity) {
            this.entity = (Entity)entity;
        }
    }

    @Nullable
    public <T extends Entity> T getEntity() {
        return (T)this.entity;
    }

    public AxisAlignedBB getAabb() {
        return this.carriage.getAabb(this);
    }

    private void setPosToAabb(AxisAlignedBB aabb) {
        this.carriage.setPosToAabb(this, aabb);
    }

    public float getWidth() {
        return this.carriage.getWidth(this);
    }

    public float getHeight() {
        return this.carriage.getHeight(this);
    }

    public void move(double x, double y, double z) {
        if (!this.carriage.canCollide(this)) {
            this.grounded = false;
            this.setPosToAabb(this.getAabb().func_72317_d(x, y, z));
            return;
        }
        double ty = y;
        List collisionBoxes = this.carriage.field_70170_p.func_184144_a(null, this.getAabb().func_72321_a(x, y, z));
        if (y != 0.0) {
            int l = collisionBoxes.size();
            for (int k = 0; k < l; ++k) {
                y = ((AxisAlignedBB)collisionBoxes.get(k)).func_72323_b(this.getAabb(), y);
            }
            this.setPosToAabb(this.getAabb().func_72317_d(0.0, y, 0.0));
        }
        if (x != 0.0) {
            int l5 = collisionBoxes.size();
            for (int j5 = 0; j5 < l5; ++j5) {
                x = ((AxisAlignedBB)collisionBoxes.get(j5)).func_72316_a(this.getAabb(), x);
            }
            if (x != 0.0) {
                this.setPosToAabb(this.getAabb().func_72317_d(x, 0.0, 0.0));
            }
        }
        if (z != 0.0) {
            int i6 = collisionBoxes.size();
            for (int k5 = 0; k5 < i6; ++k5) {
                z = ((AxisAlignedBB)collisionBoxes.get(k5)).func_72322_c(this.getAabb(), z);
            }
            if (z != 0.0) {
                this.setPosToAabb(this.getAabb().func_72317_d(0.0, 0.0, z));
            }
        }
        this.grounded = Math.abs(ty - y) > (double)1.0E-4f;
    }

    public void tickLerp() {
        if (this.lerpSteps > 0) {
            this.x += (this.lerpX - this.x) / (double)this.lerpSteps;
            this.y += (this.lerpY - this.y) / (double)this.lerpSteps;
            this.z += (this.lerpZ - this.z) / (double)this.lerpSteps;
            --this.lerpSteps;
        }
    }

    public static enum Type {
        PULLER,
        ANCHOR;

    }
}

