/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.draeton;

import com.google.common.collect.ImmutableList;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityPreventUnmount;
import thebetweenlands.api.entity.IPullerEntity;
import thebetweenlands.api.entity.IPullerEntityProvider;
import thebetweenlands.client.audio.DraetonBurnerSound;
import thebetweenlands.client.audio.DraetonLeakSound;
import thebetweenlands.client.audio.DraetonPulleySound;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.draeton.DraetonLeakage;
import thebetweenlands.common.entity.draeton.DraetonPhysicsPart;
import thebetweenlands.common.entity.draeton.EntityDraetonInteractionPart;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.network.bidirectional.MessageUpdateDraetonPhysicsPart;
import thebetweenlands.common.network.clientbound.MessageSyncDraetonLeakages;
import thebetweenlands.common.network.serverbound.MessageSetDraetonAnchorPos;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityDraetonFurnace;
import thebetweenlands.util.Matrix;
import thebetweenlands.util.NBTHelper;
import thebetweenlands.util.PlayerUtil;

public class EntityDraeton
extends Entity
implements IEntityMultiPart,
IEntityAdditionalSpawnData,
IEntityBL,
IEntityPreventUnmount {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> ANCHOR_DEPLOYED = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ANCHOR_FIXATED = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> ANCHOR_LENGTH = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<BlockPos> ANCHOR_POS = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<ItemStack> UPGRADE_1_CONTENT = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_2_CONTENT = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_3_CONTENT = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_4_CONTENT = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_5_CONTENT = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> UPGRADE_6_CONTENT = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final ImmutableList<DataParameter<ItemStack>> UPGRADE_CONTENT = ImmutableList.of(UPGRADE_1_CONTENT, UPGRADE_2_CONTENT, UPGRADE_3_CONTENT, UPGRADE_4_CONTENT, UPGRADE_5_CONTENT, UPGRADE_6_CONTENT);
    private static final DataParameter<Boolean> STORAGE_1_OPEN = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STORAGE_2_OPEN = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STORAGE_3_OPEN = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STORAGE_4_OPEN = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final ImmutableList<DataParameter<Boolean>> STORAGE_OPEN = ImmutableList.of(STORAGE_1_OPEN, STORAGE_2_OPEN, STORAGE_3_OPEN, STORAGE_4_OPEN);
    private static final DataParameter<Integer> BURNER_FUEL = EntityDataManager.func_187226_a(EntityDraeton.class, (DataSerializer)DataSerializers.field_187192_b);
    private Vec3d prevBalloonPos = Vec3d.field_186680_a;
    private Vec3d balloonPos = Vec3d.field_186680_a;
    private Vec3d balloonMotion = Vec3d.field_186680_a;
    private final InventoryBasic upgradesInventory = new InventoryBasic("container.bl.draeton_upgrades", false, 6){

        public void func_70299_a(int index, ItemStack stack) {
            if (!(EntityDraeton.this.field_70170_p.field_72995_K || index < 0 || index >= 4 || !stack.func_190926_b() && EntityDraeton.this.isFurnaceUpgrade(stack))) {
                EntityDraeton.this.dropFurnaceContent(index);
            }
            super.func_70299_a(index, stack);
        }
    };
    private final InventoryBasic pullersInventory = new InventoryBasic("container.bl.dreaton_pullers", false, 6);
    private final InventoryBasic burnerInventory = new InventoryBasic("container.bl.draeton_burner", false, 1);
    private final NonNullList<ItemStack> furnacesInventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    private final TileEntityDraetonFurnace[] furnaces = new TileEntityDraetonFurnace[4];
    public final List<DraetonPhysicsPart> physicsParts = new ArrayList<DraetonPhysicsPart>();
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private List<Entity> loadedPullerEntities = new ArrayList<Entity>();
    private int nextPhysicsPartId = 0;
    public float prevRotationRoll;
    public float rotationRoll;
    private boolean descend = false;
    private final EntityDraetonInteractionPart[] parts;
    public final EntityDraetonInteractionPart guiPart;
    public final EntityDraetonInteractionPart upgradePart1;
    public final EntityDraetonInteractionPart upgradePart2;
    public final EntityDraetonInteractionPart upgradePart3;
    public final EntityDraetonInteractionPart upgradePart4;
    public final EntityDraetonInteractionPart upgradeAnchorPart;
    public final EntityDraetonInteractionPart upgradeFramePart;
    public final EntityDraetonInteractionPart burnerPart;
    public final EntityDraetonInteractionPart balloonFront;
    public final EntityDraetonInteractionPart balloonMiddle;
    public final EntityDraetonInteractionPart balloonBack;
    private final EntityDraetonInteractionPart[] leakageParts;
    private DraetonPhysicsPart anchorPhysicsPart;
    private final EntityItemFrame dummyFrame;
    protected boolean dropContentsWhenDead = true;
    public float upgradeCounterRoll = 0.0f;
    public float upgradeOpenTicks = 0.0f;
    private final int[] storageUsers = new int[4];
    private final int[] prevStorageOpenTicks = new int[4];
    private final int[] storageOpenTicks = new int[4];
    private boolean turnSoundRoll = false;
    private boolean turnSoundPitch = false;
    protected int fuelConversion = 6;
    protected int maxFuel = 1000 * this.fuelConversion * 4;
    private boolean wasBurnerRunning = false;
    private boolean playLeakSound = false;
    private int prevLeakCount = 0;
    private List<DraetonLeakage> leakages = new ArrayList<DraetonLeakage>();
    protected int movementSyncTicks = 10;
    protected float crashSpeedThreshold = 0.25f;
    protected int crashCooldown = 20;
    protected float minAnchorLength = 0.25f;
    protected float maxAnchorLength = 8.0f;
    protected int anchorRetractTicks = 0;
    public float prevPulleyRotation = 0.0f;
    public float pulleyRotation = 0.0f;
    protected int pulleyRotationTicks = 0;
    protected TObjectIntMap<EntityPlayer> unmountTicks = new TObjectIntHashMap();
    protected TObjectIntMap<EntityPlayer> notSneakingTicks = new TObjectIntHashMap();
    protected double waterLevel = 0.0;

    public EntityDraeton(World world) {
        super(world);
        int i;
        this.func_70105_a(1.5f, 1.5f);
        this.field_70178_ae = true;
        this.guiPart = new EntityDraetonInteractionPart(this, "gui", 0.5f, 0.5f, false);
        this.upgradePart1 = new EntityDraetonInteractionPart(this, "upgrade_1", 0.5f, 0.75f, false);
        this.upgradePart2 = new EntityDraetonInteractionPart(this, "upgrade_2", 0.5f, 0.75f, false);
        this.upgradePart3 = new EntityDraetonInteractionPart(this, "upgrade_3", 0.5f, 0.75f, false);
        this.upgradePart4 = new EntityDraetonInteractionPart(this, "upgrade_4", 0.5f, 0.75f, false);
        this.burnerPart = new EntityDraetonInteractionPart(this, "burner", 0.75f, 0.2f, false);
        this.upgradeAnchorPart = new EntityDraetonInteractionPart(this, "upgrade_anchor", 0.5f, 0.75f, false);
        this.upgradeFramePart = new EntityDraetonInteractionPart(this, "upgrade_frame", 0.5f, 0.5f, false);
        this.balloonFront = new EntityDraetonInteractionPart(this, "balloon_front", 1.5f, 1.0f, true);
        this.balloonMiddle = new EntityDraetonInteractionPart(this, "balloon_middle", 1.5f, 1.0f, true);
        this.balloonBack = new EntityDraetonInteractionPart(this, "balloon_back", 1.5f, 1.0f, true);
        EntityDraetonInteractionPart[] mainParts = new EntityDraetonInteractionPart[]{this.guiPart, this.upgradePart1, this.upgradePart2, this.upgradePart3, this.upgradePart4, this.burnerPart, this.upgradeAnchorPart, this.upgradeFramePart, this.balloonFront, this.balloonMiddle, this.balloonBack};
        this.leakageParts = new EntityDraetonInteractionPart[16];
        for (i = 0; i < 16; ++i) {
            this.leakageParts[i] = new EntityDraetonInteractionPart(this, "leakage_" + i, 0.5f, 0.5f, false);
        }
        this.parts = new EntityDraetonInteractionPart[mainParts.length + 16];
        for (i = 0; i < mainParts.length; ++i) {
            this.parts[i] = mainParts[i];
        }
        for (i = 0; i < this.leakageParts.length; ++i) {
            this.parts[mainParts.length + i] = this.leakageParts[i];
        }
        this.dummyFrame = new EntityItemFrame(this.field_70170_p){

            public BlockPos func_174857_n() {
                return new BlockPos((Entity)EntityDraeton.this);
            }
        };
        this.dummyFrame.field_174860_b = EnumFacing.NORTH;
        for (i = 0; i < 4; ++i) {
            this.furnaces[i] = TileEntityDraetonFurnace.create(this.furnacesInventory, i);
            this.furnaces[i].func_145834_a(world);
        }
    }

    @Nullable
    public DraetonPhysicsPart getAnchorPhysicsPart() {
        return this.anchorPhysicsPart;
    }

    public DraetonPhysicsPart getPhysicsPartById(int id) {
        for (DraetonPhysicsPart part : this.physicsParts) {
            if (part.id != id) continue;
            return part;
        }
        return null;
    }

    public DraetonPhysicsPart getPhysicsPartBySlot(int slot, DraetonPhysicsPart.Type type) {
        for (DraetonPhysicsPart part : this.physicsParts) {
            if (part.slot != slot || part.type != type) continue;
            return part;
        }
        return null;
    }

    public DraetonPhysicsPart addPhysicsPart(MessageUpdateDraetonPhysicsPart.Position pos) {
        DraetonPhysicsPart part = new DraetonPhysicsPart(pos.type, this, pos.id, pos.slot);
        part.lerpX = part.x = (double)pos.x + this.field_70165_t;
        part.lerpY = part.y = (double)pos.y + this.field_70163_u;
        part.lerpZ = part.z = (double)pos.z + this.field_70161_v;
        part.motionX = pos.mx;
        part.motionY = pos.my;
        part.motionZ = pos.mz;
        this.physicsParts.add(part);
        if (part.type == DraetonPhysicsPart.Type.ANCHOR) {
            this.anchorPhysicsPart = part;
        }
        return part;
    }

    public boolean removePhysicsPartById(int id) {
        Iterator<DraetonPhysicsPart> it = this.physicsParts.iterator();
        while (it.hasNext()) {
            DraetonPhysicsPart part = it.next();
            if (part.id != id) continue;
            part.isActive = false;
            it.remove();
            return true;
        }
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ANCHOR_DEPLOYED, (Object)false);
        this.field_70180_af.func_187214_a(ANCHOR_FIXATED, (Object)false);
        this.field_70180_af.func_187214_a(ANCHOR_LENGTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ANCHOR_POS, (Object)BlockPos.field_177992_a);
        for (DataParameter param : UPGRADE_CONTENT) {
            this.field_70180_af.func_187214_a(param, (Object)ItemStack.field_190927_a);
        }
        for (DataParameter param : STORAGE_OPEN) {
            this.field_70180_af.func_187214_a(param, (Object)false);
        }
        this.field_70180_af.func_187214_a(BURNER_FUEL, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                DataParameter param = (DataParameter)UPGRADE_CONTENT.get(i);
                if (!param.equals(key)) continue;
                this.getUpgradesInventory().func_70299_a(i, (ItemStack)this.field_70180_af.func_187225_a(param));
            }
        }
        if (ANCHOR_DEPLOYED.equals(key)) {
            if (((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED)).booleanValue()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70180_af.func_187227_b(ANCHOR_LENGTH, (Object)Float.valueOf(this.maxAnchorLength));
                } else {
                    this.pulleyRotationTicks = 10;
                }
            }
            if (this.field_70170_p.field_72995_K && !((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED)).booleanValue()) {
                this.playPulleySound();
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.lerpX = this.field_70165_t;
        this.lerpY = this.field_70163_u;
        this.lerpZ = this.field_70161_v;
        this.lerpYaw = this.field_70177_z;
        this.lerpPitch = this.field_70125_A;
        this.loadedPullerEntities.clear();
        this.physicsParts.clear();
        NBTTagList list = nbt.func_150295_c("PhysicsParts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            DraetonPhysicsPart part = new DraetonPhysicsPart(DraetonPhysicsPart.Type.PULLER, this, this.nextPhysicsPartId++, tag.func_74762_e("Slot"));
            Vec3d partPos = new Vec3d(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"));
            part.x = partPos.field_72450_a;
            part.y = partPos.field_72448_b;
            part.z = partPos.field_72449_c;
            Vec3d pos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178787_e(this.getPullPoint(part, 1.0f));
            Vec3d diff = partPos.func_178788_d(pos);
            if (diff.func_72433_c() > (double)this.getMaxTetherLength(part)) {
                partPos = pos.func_178787_e(diff.func_72432_b().func_186678_a((double)this.getMaxTetherLength(part)));
            }
            part.x = partPos.field_72450_a;
            part.y = partPos.field_72448_b;
            part.z = partPos.field_72449_c;
            if (tag.func_150297_b("Entity", 10)) {
                NBTTagCompound entityNbt = tag.func_74775_l("Entity");
                Entity entity = EntityList.func_75615_a((NBTTagCompound)entityNbt, (World)this.field_70170_p);
                if (entity instanceof IPullerEntity) {
                    ((IPullerEntity)entity).setPuller(this, part);
                    part.setEntity((IPullerEntity)entity);
                    entity.func_70107_b(part.x, part.y, part.z);
                    this.loadedPullerEntities.add(entity);
                } else {
                    entity.func_184174_b(false);
                    entity.func_70106_y();
                }
            }
            this.physicsParts.add(part);
        }
        this.field_70180_af.func_187227_b(ANCHOR_DEPLOYED, (Object)nbt.func_74767_n("AnchorDeployed"));
        this.setAnchorPos(NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("AnchorPos")), nbt.func_74767_n("AnchorFixated"));
        this.upgradesInventory.func_174888_l();
        if (nbt.func_150297_b("Upgrades", 10)) {
            NBTHelper.loadAllItems(nbt.func_74775_l("Upgrades"), (IInventory)this.upgradesInventory);
        }
        this.pullersInventory.func_174888_l();
        if (nbt.func_150297_b("Pullers", 10)) {
            NBTHelper.loadAllItems(nbt.func_74775_l("Pullers"), (IInventory)this.pullersInventory);
        }
        this.furnacesInventory.clear();
        if (nbt.func_150297_b("FurnacesInventory", 10)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt.func_74775_l("FurnacesInventory"), this.furnacesInventory);
        }
        this.burnerInventory.func_174888_l();
        if (nbt.func_150297_b("BurnerInventory", 10)) {
            NBTHelper.loadAllItems(nbt.func_74775_l("BurnerInventory"), (IInventory)this.burnerInventory);
        }
        NBTTagCompound furnacesNbt = nbt.func_74775_l("Furnaces");
        for (int i = 0; i < 4; ++i) {
            this.getFurnace(i).readDreatonFurnaceData(furnacesNbt.func_74775_l("Furnace" + i));
        }
        this.setBurnerFuel(nbt.func_74762_e("BurnerFuel"));
        this.leakages.clear();
        NBTTagList leakagesNbt = nbt.func_150295_c("Leakages", 10);
        for (int i = 0; i < leakagesNbt.func_74745_c(); ++i) {
            NBTTagCompound leakageNbt = leakagesNbt.func_150305_b(i);
            this.leakages.add(new DraetonLeakage(new Vec3d((double)leakageNbt.func_74760_g("x"), (double)leakageNbt.func_74760_g("y"), (double)leakageNbt.func_74760_g("z")), new Vec3d((double)leakageNbt.func_74760_g("dx"), (double)leakageNbt.func_74760_g("dy"), (double)leakageNbt.func_74760_g("dz")), leakageNbt.func_74762_e("age")));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (DraetonPhysicsPart part : this.physicsParts) {
            ResourceLocation id;
            if (part.type != DraetonPhysicsPart.Type.PULLER) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", part.slot);
            tag.func_74780_a("x", part.x);
            tag.func_74780_a("y", part.y);
            tag.func_74780_a("z", part.z);
            Object entity = part.getEntity();
            if (entity != null && entity.func_70089_S() && (id = EntityList.func_191301_a(entity)) != null) {
                NBTTagCompound entityNbt = new NBTTagCompound();
                entity.func_189511_e(entityNbt);
                entityNbt.func_74778_a("id", id.toString());
                tag.func_74782_a("Entity", (NBTBase)entityNbt);
            }
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("PhysicsParts", (NBTBase)list);
        nbt.func_74757_a("AnchorDeployed", ((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED)).booleanValue());
        nbt.func_74757_a("AnchorFixated", ((Boolean)this.field_70180_af.func_187225_a(ANCHOR_FIXATED)).booleanValue());
        nbt.func_74782_a("AnchorPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)((BlockPos)this.field_70180_af.func_187225_a(ANCHOR_POS))));
        nbt.func_74782_a("Upgrades", (NBTBase)NBTHelper.saveAllItems(new NBTTagCompound(), (IInventory)this.upgradesInventory, false));
        nbt.func_74782_a("Pullers", (NBTBase)NBTHelper.saveAllItems(new NBTTagCompound(), (IInventory)this.pullersInventory, false));
        nbt.func_74782_a("FurnacesInventory", (NBTBase)ItemStackHelper.func_191281_a((NBTTagCompound)new NBTTagCompound(), this.furnacesInventory, (boolean)false));
        nbt.func_74782_a("BurnerInventory", (NBTBase)NBTHelper.saveAllItems(new NBTTagCompound(), (IInventory)this.burnerInventory, false));
        NBTTagCompound furnacesNbt = new NBTTagCompound();
        for (int i = 0; i < 4; ++i) {
            furnacesNbt.func_74782_a("Furnace" + i, (NBTBase)this.getFurnace(i).writeDreatonFurnaceData(new NBTTagCompound()));
        }
        nbt.func_74782_a("Furnaces", (NBTBase)furnacesNbt);
        nbt.func_74768_a("BurnerFuel", this.getBurnerFuel());
        NBTTagList leakagesNbt = new NBTTagList();
        for (DraetonLeakage leakage : this.leakages) {
            NBTTagCompound leakageNbt = new NBTTagCompound();
            leakageNbt.func_74776_a("x", (float)leakage.pos.field_72450_a);
            leakageNbt.func_74776_a("y", (float)leakage.pos.field_72448_b);
            leakageNbt.func_74776_a("z", (float)leakage.pos.field_72449_c);
            leakageNbt.func_74776_a("dx", (float)leakage.dir.field_72450_a);
            leakageNbt.func_74776_a("dy", (float)leakage.dir.field_72448_b);
            leakageNbt.func_74776_a("dz", (float)leakage.dir.field_72449_c);
            leakageNbt.func_74768_a("age", leakage.age);
            leakagesNbt.func_74742_a((NBTBase)leakageNbt);
        }
        nbt.func_74782_a("Leakages", (NBTBase)leakagesNbt);
    }

    public double func_70042_X() {
        return 0.3;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.lerpX = this.field_70165_t;
        this.lerpY = this.field_70163_u;
        this.lerpZ = this.field_70161_v;
        this.lerpYaw = this.field_70177_z;
        this.lerpPitch = this.field_70125_A;
        this.prevBalloonPos = this.balloonPos = this.func_174791_d().func_72441_c(0.0, 2.0, 0.0);
        if (!this.field_70170_p.field_72995_K) {
            this.anchorPhysicsPart = new DraetonPhysicsPart(DraetonPhysicsPart.Type.ANCHOR, this, this.nextPhysicsPartId++, 0);
            this.physicsParts.add(this.anchorPhysicsPart);
        }
    }

    public Vec3d getBalloonPos(float partialTicks) {
        return this.prevBalloonPos.func_178787_e(this.balloonPos.func_178788_d(this.prevBalloonPos).func_186678_a((double)partialTicks));
    }

    public Vec3d getCarriageRopeConnection(int i, float partialTicks) {
        Vec3d connectionPoint;
        switch (i) {
            default: {
                connectionPoint = this.getRotatedCarriagePoint(new Vec3d((double)0.6f, (double)1.05f, (double)0.61f), partialTicks);
                break;
            }
            case 1: 
            case 5: {
                connectionPoint = this.getRotatedCarriagePoint(new Vec3d((double)-0.6f, (double)1.05f, (double)0.61f), partialTicks);
                break;
            }
            case 2: 
            case 6: {
                connectionPoint = this.getRotatedCarriagePoint(new Vec3d((double)0.6f, (double)1.05f, (double)-0.63f), partialTicks);
                break;
            }
            case 3: 
            case 7: {
                connectionPoint = this.getRotatedCarriagePoint(new Vec3d((double)-0.6f, (double)1.05f, (double)-0.63f), partialTicks);
            }
        }
        return connectionPoint;
    }

    public Vec3d getBalloonRopeConnection(int i, float partialTicks) {
        Vec3d balloonPos = this.getBalloonPos(partialTicks);
        switch (i) {
            default: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(1.0, (double)-0.425f, 1.5), partialTicks));
                break;
            }
            case 1: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(-1.0, (double)-0.425f, 1.5), partialTicks));
                break;
            }
            case 2: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(1.0, (double)-0.425f, -1.5), partialTicks));
                break;
            }
            case 3: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(-1.0, (double)-0.425f, -1.5), partialTicks));
                break;
            }
            case 4: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(1.0, (double)-0.35f, (double)0.7f), partialTicks));
                break;
            }
            case 5: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(-1.0, (double)-0.35f, (double)0.7f), partialTicks));
                break;
            }
            case 6: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(1.0, (double)-0.35f, (double)-0.7f), partialTicks));
                break;
            }
            case 7: {
                balloonPos = balloonPos.func_178787_e(this.getRotatedBalloonPoint(new Vec3d(-1.0, (double)-0.35f, (double)-0.7f), partialTicks));
            }
        }
        return balloonPos;
    }

    public Vec3d getUpgradePoint(int i, float offset) {
        Vec3d offsetVec = new Vec3d((double)offset, 0.0, 0.0);
        Matrix mat = new Matrix();
        mat.rotate(Math.toRadians(this.getUpgradeRotY(i)), 0.0, 1.0, 0.0);
        offsetVec = mat.transform(offsetVec);
        switch (i) {
            default: {
                return new Vec3d(0.625, 0.875, 0.5).func_178787_e(offsetVec);
            }
            case 1: {
                return new Vec3d(-0.625, 0.875, 0.5).func_178787_e(offsetVec);
            }
            case 2: {
                return new Vec3d(0.625, 0.875, -0.5).func_178787_e(offsetVec);
            }
            case 3: {
                return new Vec3d(-0.625, 0.875, -0.5).func_178787_e(offsetVec);
            }
            case 4: 
        }
        return new Vec3d(0.0, 1.375, 0.875);
    }

    public float getUpgradeRotY(int i) {
        switch (i) {
            default: {
                return 0.0f;
            }
            case 0: 
            case 2: {
                return 0.0f;
            }
            case 1: 
            case 3: 
        }
        return 180.0f;
    }

    public float getUpgradeCounterRoll(int i, float partialTicks) {
        float roll = this.prevRotationRoll + (this.rotationRoll - this.prevRotationRoll) * partialTicks;
        switch (i) {
            default: {
                return 0.0f;
            }
            case 0: 
            case 2: {
                return -roll;
            }
            case 1: 
            case 3: 
        }
        return roll;
    }

    public float getUpgradeOpenTicks(int i, float partialTicks) {
        if (i < 4) {
            return (float)this.prevStorageOpenTicks[i] + (float)(this.storageOpenTicks[i] - this.prevStorageOpenTicks[i]) * partialTicks;
        }
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkWaterLevel() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)(axisalignedbb.field_72338_b - 1.0));
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h) continue;
                        float f = BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.field_72338_b < (double)f;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag;
    }

    public boolean func_70072_I() {
        this.checkWaterLevel();
        if (this.func_184187_bx() instanceof EntityBoat) {
            this.field_70171_ac = false;
        } else if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, -0.1, 0.0).func_186664_h(0.001), Material.field_151586_h, (Entity)this)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        if (this.waterLevel - this.field_70163_u > 0.1) {
            this.field_70171_ac = true;
        }
        return this.field_70171_ac;
    }

    public void func_70030_z() {
        block30: {
            block29: {
                if (!this.field_70170_p.field_72995_K) {
                    Iterator<Object> entityIt = this.loadedPullerEntities.iterator();
                    while (entityIt.hasNext()) {
                        Entity entity = (Entity)entityIt.next();
                        if (!this.field_70170_p.func_72838_d(entity)) continue;
                        entityIt.remove();
                    }
                    Iterator<DraetonPhysicsPart> iterator = this.physicsParts.iterator();
                    while (iterator.hasNext()) {
                        Iterator<DraetonLeakage> entity;
                        DraetonPhysicsPart part = iterator.next();
                        if (part.type != DraetonPhysicsPart.Type.PULLER || (entity = part.getEntity()) != null && entity.func_70089_S()) continue;
                        part.isActive = false;
                        iterator.remove();
                        TheBetweenlands.networkWrapper.sendToAllTracking((IMessage)new MessageUpdateDraetonPhysicsPart(this, part, MessageUpdateDraetonPhysicsPart.Action.REMOVE), (Entity)this);
                    }
                    ArrayList<DraetonLeakage> expiredLeakages = null;
                    for (DraetonLeakage draetonLeakage : this.leakages) {
                        if (draetonLeakage.age++ <= 6000) continue;
                        if (expiredLeakages == null) {
                            expiredLeakages = new ArrayList<DraetonLeakage>();
                        }
                        expiredLeakages.add(draetonLeakage);
                    }
                    if (expiredLeakages != null) {
                        for (DraetonLeakage draetonLeakage : expiredLeakages) {
                            this.removeLeakage(draetonLeakage);
                        }
                    }
                }
                for (DraetonPhysicsPart draetonPhysicsPart : this.physicsParts) {
                    draetonPhysicsPart.prevX = draetonPhysicsPart.x;
                    draetonPhysicsPart.prevY = draetonPhysicsPart.y;
                    draetonPhysicsPart.prevZ = draetonPhysicsPart.z;
                }
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                float drag = 0.98f;
                for (DraetonPhysicsPart part : this.physicsParts) {
                    if (part.getEntity() == null) continue;
                    drag = ((IPullerEntity)part.getEntity()).getCarriageDrag(drag);
                }
                if (this.field_70122_E || this.field_70171_ac) {
                    drag *= 0.8f;
                }
                this.field_70181_x *= (double)drag;
                this.field_70159_w *= (double)drag;
                this.field_70179_y *= (double)drag;
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                this.func_70072_I();
                if (this.waterLevel - this.field_70163_u > 0.2) {
                    if (this.field_70181_x < 0.0) {
                        this.field_70181_x *= 0.75;
                    }
                    this.field_70181_x += 0.01;
                }
                if (!this.field_70170_p.field_72995_K || this.func_184186_bw()) {
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x - (double)1.0E-7f, this.field_70179_y);
                    this.func_145771_j(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                float newSpeed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                if (!this.field_70170_p.field_72995_K) {
                    if (this.crashCooldown > 0) {
                        if (!this.field_70132_H || this.field_70122_E) {
                            --this.crashCooldown;
                        }
                    } else if (this.func_184179_bs() != null && !((Boolean)this.field_70180_af.func_187225_a(ANCHOR_FIXATED)).booleanValue() && (this.field_70132_H || this.field_70122_E) && f > this.crashSpeedThreshold && f - newSpeed > this.crashSpeedThreshold * 0.5f) {
                        float leakageChance = Math.min((f - this.crashSpeedThreshold) * 3.0f, 0.5f) + 0.25f;
                        if (this.field_70170_p.field_73012_v.nextFloat() < leakageChance) {
                            this.field_70179_y = 0.0;
                            this.field_70181_x = 0.0;
                            this.field_70159_w = 0.0;
                            this.crashCooldown = 20;
                            if (this.leakages.size() < 16) {
                                this.addLeakage(this.generateRandomLeakage());
                            }
                        }
                    }
                }
                if (this.field_70170_p.field_72995_K && !this.func_184186_bw()) break block29;
                Entity controller = this.func_184179_bs();
                if (this.field_70170_p.field_72995_K && this.func_184186_bw() && controller instanceof EntityLivingBase) {
                    controller.field_70143_R = 0.0f;
                    this.handleControllerMovement((EntityLivingBase)controller);
                }
                this.updateCarriage();
                if (!this.field_70170_p.field_72995_K) {
                    this.lerpX = this.field_70165_t;
                    this.lerpY = this.field_70163_u;
                    this.lerpZ = this.field_70161_v;
                    this.lerpYaw = this.field_70177_z;
                    this.lerpPitch = this.field_70125_A;
                    for (DraetonPhysicsPart part : this.physicsParts) {
                        part.lerpX = part.x;
                        part.lerpY = part.y;
                        part.lerpZ = part.z;
                    }
                }
                if (this.field_70171_ac) break block30;
                if (this.func_184188_bt().isEmpty() || this.physicsParts.isEmpty()) {
                    this.field_70181_x -= (double)0.005f;
                }
                if (this.isBurnerRunning()) break block30;
                this.field_70181_x -= (double)0.06f;
                break block30;
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                for (DraetonPhysicsPart draetonPhysicsPart : this.physicsParts) {
                    draetonPhysicsPart.tickLerp();
                }
            }
        }
        this.updateBurner();
        this.updatePullerSlots();
        if (this.field_70170_p instanceof WorldServer && this.field_70173_aa % this.movementSyncTicks == 0) {
            for (DraetonPhysicsPart draetonPhysicsPart : this.physicsParts) {
                MessageUpdateDraetonPhysicsPart msg = new MessageUpdateDraetonPhysicsPart(this, draetonPhysicsPart, MessageUpdateDraetonPhysicsPart.Action.UPDATE);
                Set tracking = ((WorldServer)this.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this);
                for (EntityPlayer player : tracking) {
                    if (!(player instanceof EntityPlayerMP) || player == this.func_184179_bs()) continue;
                    TheBetweenlands.networkWrapper.sendTo((IMessage)msg, (EntityPlayerMP)player);
                }
            }
        }
        this.field_70148_d = false;
    }

    protected void updateBurner() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack burnerStack;
            if (this.isBurnerRunning()) {
                this.setBurnerFuel(Math.max(0, this.getBurnerFuel() - 1 - this.leakages.size()));
            }
            if (!(burnerStack = this.burnerInventory.func_70301_a(0)).func_190926_b()) {
                burnerStack = this.tryFillingBurner(burnerStack);
                this.burnerInventory.func_70299_a(0, burnerStack);
            }
        } else {
            if (!this.wasBurnerRunning && this.isBurnerRunning()) {
                this.playBurnerSound();
            }
            this.wasBurnerRunning = this.isBurnerRunning();
            if (this.isBurnerRunning()) {
                this.spawnBurnerFlame();
            }
        }
    }

    protected ItemStack tryFillingBurner(ItemStack stack) {
        int space;
        int toDrain;
        FluidStack drained;
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler != null && (drained = handler.drain(new FluidStack(FluidRegistry.SHALLOWBREATH, 1000), false)) != null && (toDrain = Math.min((space = this.maxFuel - this.getBurnerFuel()) / this.fuelConversion, drained.amount)) > 0 && (drained = handler.drain(new FluidStack(FluidRegistry.SHALLOWBREATH, toDrain), true)) != null) {
            this.setBurnerFuel(this.getBurnerFuel() + drained.amount * this.fuelConversion);
            return handler.getContainer();
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    protected void playLeakSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DraetonLeakSound(this));
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnBurnerFlame() {
        BLParticles.DRAETON_BURNER_FLAME.spawn(this.field_70170_p, 0.0, 0.0, 0.0, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.1, 0.0)).withColor(0.0f, 0.8f, 1.0f, 0.8f)).withData(this));
    }

    @SideOnly(value=Side.CLIENT)
    protected void playBurnerSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DraetonBurnerSound(this));
    }

    @SideOnly(value=Side.CLIENT)
    protected void playPulleySound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DraetonPulleySound(this));
    }

    protected void updatePullerSlots() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                Entity entity;
                ItemStack stack = this.getPullersInventory().func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMob)) continue;
                DraetonPhysicsPart puller = this.getPhysicsPartBySlot(i, DraetonPhysicsPart.Type.PULLER);
                if (puller == null) {
                    this.getPullersInventory().func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                if (puller.getEntity() == null || (entity = ((IPullerEntity)puller.getEntity()).createReleasedEntity()) == null) continue;
                stack = ((ItemMob)stack.func_77973_b()).capture(entity);
                this.getPullersInventory().func_70299_a(i, stack);
            }
        }
    }

    protected void updateParts() {
        int i;
        IInventory inventory = this.getUpgradesInventory();
        if (!this.field_70170_p.field_72995_K) {
            for (i = 0; i < 6; ++i) {
                this.field_70180_af.func_187227_b((DataParameter)UPGRADE_CONTENT.get(i), (Object)inventory.func_70301_a(i));
            }
        }
        this.upgradePart1.setEnabled(!inventory.func_70301_a(0).func_190926_b());
        this.upgradePart2.setEnabled(!inventory.func_70301_a(1).func_190926_b());
        this.upgradePart3.setEnabled(!inventory.func_70301_a(2).func_190926_b());
        this.upgradePart4.setEnabled(!inventory.func_70301_a(3).func_190926_b());
        this.upgradeAnchorPart.setEnabled(!inventory.func_70301_a(4).func_190926_b());
        for (i = 0; i < 4; ++i) {
            this.prevStorageOpenTicks[i] = this.storageOpenTicks[i];
            this.storageOpenTicks[i] = (Boolean)this.field_70180_af.func_187225_a((DataParameter)STORAGE_OPEN.get(i)) != false ? Math.min(5, this.storageOpenTicks[i] + 1) : Math.max(0, this.storageOpenTicks[i] - 1);
        }
        if (!this.field_70170_p.field_72995_K && !((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED)).booleanValue()) {
            this.field_70180_af.func_187227_b(ANCHOR_LENGTH, (Object)Float.valueOf(Math.max(this.minAnchorLength, ((Float)this.field_70180_af.func_187225_a(ANCHOR_LENGTH)).floatValue() - 0.1f)));
        }
        if (this.anchorRetractTicks > 0) {
            if (!this.field_70170_p.field_72995_K && ((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED)).booleanValue()) {
                this.field_70180_af.func_187227_b(ANCHOR_LENGTH, (Object)Float.valueOf(Math.max(this.minAnchorLength, ((Float)this.field_70180_af.func_187225_a(ANCHOR_LENGTH)).floatValue() - 0.05f)));
            }
            this.anchorRetractTicks = Math.max(0, this.anchorRetractTicks - 1);
        }
        for (EntityDraetonInteractionPart entity : this.parts) {
            entity.func_70071_h_();
        }
        this.updatePartPositions();
        if (this.field_70170_p.field_72995_K && this.isLeaking()) {
            for (DraetonLeakage leakage : this.leakages) {
                Vec3d leakagePos = this.getBalloonPos(1.0f).func_178787_e(this.getRotatedBalloonPoint(leakage.pos, 1.0f));
                Vec3d leakageDir = this.getRotatedBalloonPoint(leakage.dir, 1.0f);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, leakagePos.field_72450_a, leakagePos.field_72448_b, leakagePos.field_72449_c, this.field_70159_w + leakageDir.field_72450_a * (double)0.1f, this.field_70181_x + leakageDir.field_72448_b * (double)0.1f, this.field_70179_y + leakageDir.field_72449_c * (double)0.1f, new int[0]);
            }
        }
    }

    protected void updatePartPositions() {
        int i;
        if (this.field_70170_p.field_72995_K) {
            this.balloonMotion = this.balloonMotion.func_72441_c(0.0, 0.125, 0.0).func_186678_a((double)0.9f);
            this.balloonPos = this.balloonPos.func_178787_e(this.balloonMotion);
            for (i = 0; i < 8; ++i) {
                Vec3d balloonConnection = this.getBalloonRopeConnection(i, 1.0f);
                Vec3d tetherPos = this.func_174791_d().func_178787_e(this.getCarriageRopeConnection(i, 1.0f));
                Vec3d diff = balloonConnection.func_178788_d(tetherPos);
                float tetherLength = 2.0f + (float)Math.sin((float)this.field_70173_aa * 0.1f) * 0.05f;
                if (diff.func_72433_c() > 6.0) {
                    this.balloonPos = this.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
                    continue;
                }
                if (!(diff.func_72433_c() > (double)tetherLength)) continue;
                Vec3d correction = diff.func_72432_b().func_186678_a(-(diff.func_72433_c() - (double)tetherLength));
                this.balloonPos = this.balloonPos.func_178787_e(correction.func_186678_a(0.75));
                this.balloonMotion = this.balloonMotion.func_178787_e(correction.func_186678_a(1.25));
            }
        } else {
            this.balloonMotion = Vec3d.field_186680_a;
            this.prevBalloonPos = this.balloonPos = this.func_174791_d().func_72441_c(0.0, 2.5, 0.0);
        }
        for (i = 0; i < this.leakageParts.length; ++i) {
            Vec3d leakagePos = this.getBalloonPos(1.0f).func_178787_e(this.getRotatedBalloonPoint(new Vec3d(0.0, 0.0, 0.0), 1.0f));
            this.leakageParts[i].func_70107_b(leakagePos.field_72450_a, leakagePos.field_72448_b, leakagePos.field_72449_c);
        }
        for (i = 0; i < Math.min(this.leakages.size(), this.leakageParts.length); ++i) {
            DraetonLeakage leakage = this.leakages.get(i);
            Vec3d leakagePos = this.getBalloonPos(1.0f).func_178787_e(this.getRotatedBalloonPoint(leakage.pos, 1.0f));
            this.leakageParts[i].func_70107_b(leakagePos.field_72450_a, leakagePos.field_72448_b - (double)(this.leakageParts[i].field_70131_O / 2.0f), leakagePos.field_72449_c);
        }
        Vec3d guiPos = this.getRotatedCarriagePoint(new Vec3d(0.0, 0.05, 0.25), 1.0f).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.guiPart.func_70107_b(guiPos.field_72450_a, guiPos.field_72448_b, guiPos.field_72449_c);
        Vec3d upgradePos1 = this.getRotatedCarriagePoint(this.getUpgradePoint(0, 0.25f), 1.0f).func_72441_c(this.field_70165_t, this.field_70163_u - (double)this.upgradePart1.field_70131_O + (double)0.05f, this.field_70161_v);
        this.upgradePart1.func_70107_b(upgradePos1.field_72450_a, upgradePos1.field_72448_b, upgradePos1.field_72449_c);
        Vec3d upgradePos2 = this.getRotatedCarriagePoint(this.getUpgradePoint(1, 0.25f), 1.0f).func_72441_c(this.field_70165_t, this.field_70163_u - (double)this.upgradePart2.field_70131_O + (double)0.05f, this.field_70161_v);
        this.upgradePart2.func_70107_b(upgradePos2.field_72450_a, upgradePos2.field_72448_b, upgradePos2.field_72449_c);
        Vec3d upgradePos3 = this.getRotatedCarriagePoint(this.getUpgradePoint(2, 0.25f), 1.0f).func_72441_c(this.field_70165_t, this.field_70163_u - (double)this.upgradePart3.field_70131_O + (double)0.05f, this.field_70161_v);
        this.upgradePart3.func_70107_b(upgradePos3.field_72450_a, upgradePos3.field_72448_b, upgradePos3.field_72449_c);
        Vec3d upgradePos4 = this.getRotatedCarriagePoint(this.getUpgradePoint(3, 0.25f), 1.0f).func_72441_c(this.field_70165_t, this.field_70163_u - (double)this.upgradePart4.field_70131_O + (double)0.05f, this.field_70161_v);
        this.upgradePart4.func_70107_b(upgradePos4.field_72450_a, upgradePos4.field_72448_b, upgradePos4.field_72449_c);
        Vec3d anchorPos = this.getRotatedCarriagePoint(new Vec3d(0.0, (double)0.525f, (double)0.975f), 1.0f).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.upgradeAnchorPart.func_70107_b(anchorPos.field_72450_a, anchorPos.field_72448_b - (double)(this.upgradeAnchorPart.field_70131_O / 2.0f), anchorPos.field_72449_c);
        Vec3d burnerPos = this.getBalloonPos(1.0f).func_178787_e(this.getRotatedBalloonPoint(new Vec3d(0.0, -0.5, 0.0), 1.0f));
        this.burnerPart.func_70107_b(burnerPos.field_72450_a, burnerPos.field_72448_b - (double)(this.burnerPart.field_70131_O / 2.0f), burnerPos.field_72449_c);
        Matrix balloonRot = new Matrix();
        balloonRot.rotate((float)(-Math.toRadians(this.field_70177_z)), 0.0, 1.0, 0.0);
        Vec3d balloonFrontPos = balloonRot.transform(new Vec3d(0.0, (double)3.15f, 1.5)).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.balloonFront.func_70107_b(balloonFrontPos.field_72450_a, balloonFrontPos.field_72448_b, balloonFrontPos.field_72449_c);
        Vec3d balloonMiddlePos = balloonRot.transform(new Vec3d(0.0, (double)3.15f, 0.0)).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.balloonMiddle.func_70107_b(balloonMiddlePos.field_72450_a, balloonMiddlePos.field_72448_b, balloonMiddlePos.field_72449_c);
        Vec3d balloonBackPos = balloonRot.transform(new Vec3d(0.0, (double)3.15f, -1.5)).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.balloonBack.func_70107_b(balloonBackPos.field_72450_a, balloonBackPos.field_72448_b, balloonBackPos.field_72449_c);
    }

    public void func_70071_h_() {
        float targetRoll;
        float targetPitch;
        float targetYaw;
        this.func_70066_B();
        this.prevRotationRoll = this.rotationRoll;
        this.prevBalloonPos = this.balloonPos;
        Iterator unmountingPlayersIt = this.unmountTicks.keySet().iterator();
        while (unmountingPlayersIt.hasNext()) {
            EntityPlayer player = (EntityPlayer)unmountingPlayersIt.next();
            if (player.func_184187_bx() != this) {
                unmountingPlayersIt.remove();
                continue;
            }
            if (player.func_70093_af() || this.notSneakingTicks.adjustOrPutValue((Object)player, 1, 0) <= 40) continue;
            unmountingPlayersIt.remove();
            this.notSneakingTicks.remove((Object)player);
        }
        Iterator notSneakingPlayersIt = this.notSneakingTicks.keySet().iterator();
        while (notSneakingPlayersIt.hasNext()) {
            EntityPlayer player = (EntityPlayer)notSneakingPlayersIt.next();
            if (player.func_184187_bx() == this) continue;
            notSneakingPlayersIt.remove();
        }
        if (this.func_184179_bs() == null) {
            this.descend = false;
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack mapStack;
            if (!this.upgradeAnchorPart.isEnabled()) {
                this.field_70180_af.func_187227_b(ANCHOR_DEPLOYED, (Object)false);
            }
            if (!((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED)).booleanValue()) {
                this.setAnchorPos(BlockPos.field_177992_a, false);
            }
            if (!(mapStack = this.getUpgradesInventory().func_70301_a(5)).func_190926_b() && mapStack.func_77973_b() instanceof ItemMap) {
                ItemMap map = (ItemMap)mapStack.func_77973_b();
                mapStack.func_82842_a(this.dummyFrame);
                this.dummyFrame.field_174860_b = EnumFacing.func_176733_a((double)this.field_70177_z);
                MapData mapData = map.func_77873_a(mapStack, this.field_70170_p);
                if (mapData != null) {
                    if (this.func_184179_bs() instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)this.func_184179_bs();
                        mapData.func_76191_a(player, mapStack);
                        map.func_77872_a(this.field_70170_p, (Entity)player, mapData);
                    }
                    if (this.field_70173_aa % 10 == 0 && this.field_70170_p instanceof WorldServer) {
                        Set trackers = ((WorldServer)this.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this);
                        for (EntityPlayer tracker : trackers) {
                            if (!(tracker instanceof EntityPlayerMP)) continue;
                            EntityPlayerMP player = (EntityPlayerMP)tracker;
                            mapData.func_76191_a((EntityPlayer)player, mapStack);
                            Packet packet = map.func_150911_c(mapStack, this.field_70170_p, (EntityPlayer)player);
                            if (packet == null) continue;
                            player.field_71135_a.func_147359_a(packet);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.furnaces[i].func_174878_a(this.func_180425_c());
            this.furnaces[i].func_73660_a();
        }
        super.func_70071_h_();
        double dx = this.field_70159_w;
        double dz = this.field_70179_y;
        double dy = this.field_70181_x;
        float adjustStrength = 0.1f;
        float speed = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (speed > 0.1f) {
            targetYaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            float horizontal = (float)Math.sqrt(dx * dx + dz * dz);
            targetPitch = MathHelper.func_76131_a((float)(((float)(-Math.toDegrees(Math.atan2(horizontal, dy))) + 90.0f) * MathHelper.func_76131_a((float)(horizontal * 2.0f), (float)0.0f, (float)1.0f)), (float)-30.0f, (float)30.0f);
            targetRoll = MathHelper.func_76131_a((float)(MathHelper.func_76142_g((float)(targetYaw - this.field_70177_z)) * 10.0f), (float)-20.0f, (float)20.0f);
            adjustStrength = MathHelper.func_76131_a((float)(speed * 0.5f), (float)0.05f, (float)0.5f);
        } else {
            targetYaw = this.field_70177_z;
            targetPitch = 0.0f;
            targetRoll = 0.0f;
        }
        float yawOffset = MathHelper.func_76142_g((float)(targetYaw - this.field_70177_z));
        this.field_70177_z += yawOffset * adjustStrength;
        float pitchOffset = MathHelper.func_76142_g((float)(targetPitch - this.field_70125_A));
        this.field_70125_A += pitchOffset * adjustStrength * 0.5f;
        float rollOffset = MathHelper.func_76142_g((float)(targetRoll - this.rotationRoll));
        this.rotationRoll += rollOffset * adjustStrength * 0.5f;
        if (Math.abs(this.rotationRoll) + Math.abs(rollOffset) > 14.0f && !this.turnSoundRoll) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.DRAETON_TURN, SoundCategory.NEUTRAL, 1.0f, 1.0f - Math.min(Math.abs(rollOffset), 15.0f) / 15.0f * 0.2f, false);
            this.turnSoundRoll = true;
        } else if (Math.abs(this.rotationRoll) < 3.0f) {
            this.turnSoundRoll = false;
        }
        if (Math.abs(this.field_70125_A) + Math.abs(pitchOffset) > 6.0f && !this.turnSoundPitch) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.DRAETON_TURN, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            this.turnSoundPitch = true;
        } else if (Math.abs(this.field_70125_A) < 1.5f) {
            this.turnSoundPitch = false;
        }
        this.tickLerp();
        this.updateParts();
        if (((Boolean)this.field_70180_af.func_187225_a(ANCHOR_FIXATED)).booleanValue() && this.anchorPhysicsPart != null) {
            BlockPos anchorPos = this.getAnchorPos();
            this.anchorPhysicsPart.prevX = this.anchorPhysicsPart.x = (double)((float)anchorPos.func_177958_n() + 0.5f);
            this.anchorPhysicsPart.prevY = this.anchorPhysicsPart.y = (double)((float)anchorPos.func_177956_o() - this.getAnchorYOffset());
            this.anchorPhysicsPart.prevZ = this.anchorPhysicsPart.z = (double)((float)anchorPos.func_177952_p() + 0.5f);
        }
        if (this.field_70170_p.field_72995_K && this.func_184186_bw() && this.anchorPhysicsPart != null && ((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED)).booleanValue() && this.isFixated(this.anchorPhysicsPart) && this.field_70173_aa % 5 == 0) {
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageSetDraetonAnchorPos(this));
        }
        if (this.field_70170_p.field_72995_K) {
            this.prevPulleyRotation = this.pulleyRotation;
            if (this.isReelingInAnchor()) {
                this.pulleyRotationTicks = -1;
            }
            if (this.pulleyRotationTicks < 0) {
                this.pulleyRotationTicks = Math.min(0, this.pulleyRotationTicks + 1);
                this.pulleyRotation += 8.0f;
            } else if (this.pulleyRotationTicks > 0) {
                this.pulleyRotationTicks = Math.max(0, this.pulleyRotationTicks - 1);
                this.pulleyRotation -= 30.0f;
            }
            if (this.prevLeakCount < this.leakages.size()) {
                Vec3d pos = this.getBalloonPos(1.0f);
                this.field_70170_p.func_184134_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (SoundEvent)SoundRegistry.DRAETON_LEAK_START, SoundCategory.NEUTRAL, 1.0f, 0.85f + this.field_70170_p.field_73012_v.nextFloat() * 0.35f, false);
            }
            this.prevLeakCount = this.leakages.size();
            if (this.isLeaking() && !this.playLeakSound) {
                this.playLeakSound();
                this.playLeakSound = true;
            } else if (!this.isLeaking()) {
                this.playLeakSound = false;
            }
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && this.field_70170_p.field_72995_K && !this.func_184186_bw()) {
            double x = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double y = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double z = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            if (this.func_184179_bs() != null) {
                double dx = x - this.field_70165_t;
                double dy = y - this.field_70163_u;
                double dz = z - this.field_70161_v;
                for (DraetonPhysicsPart part : this.physicsParts) {
                    part.x += dx;
                    part.y += dy;
                    part.z += dz;
                    part.lerpX += dx;
                    part.lerpY += dy;
                    part.lerpZ += dz;
                }
            }
            double yaw = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + yaw / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_184174_b(boolean dropWhenDead) {
        this.dropContentsWhenDead = dropWhenDead;
    }

    public Entity func_184204_a(int dimensionIn) {
        this.dropContentsWhenDead = false;
        return super.func_184204_a(dimensionIn);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int index = this.func_184188_bt().indexOf(passenger);
            float yOff = 0.5f;
            Vec3d mountOffset = index <= 1 ? this.getRotatedCarriagePoint(new Vec3d(0.0, (double)yOff, (double)(0.25f - (float)index * 0.75f)), 1.0f) : this.getRotatedCarriagePoint(new Vec3d(0.0, (double)yOff, 0.0), 1.0f);
            passenger.func_70107_b(this.field_70165_t + mountOffset.field_72450_a, this.field_70163_u + mountOffset.field_72448_b - (double)yOff + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + mountOffset.field_72449_c);
        }
        if (passenger == this.func_184179_bs()) {
            this.descend = passenger.func_70051_ag();
        }
        passenger.func_70031_b(false);
        PlayerUtil.resetFloating(passenger);
        PlayerUtil.resetVehicleFloating(passenger);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        double startX = this.field_70165_t;
        double startY = this.field_70163_u;
        double startZ = this.field_70161_v;
        super.func_70091_d(type, x, y, z);
        for (DraetonPhysicsPart part : this.physicsParts) {
            if (part.type != DraetonPhysicsPart.Type.PULLER) continue;
            float drag = part.getEntity() != null ? ((IPullerEntity)part.getEntity()).getDrag(0.25f) : 0.25f;
            part.move((this.field_70165_t - startX) * (double)drag, (this.field_70163_u - startY) * (double)drag, (this.field_70161_v - startZ) * (double)drag);
        }
        if (this.field_70170_p.field_72995_K && !this.func_184186_bw()) {
            this.balloonPos = this.balloonPos.func_72441_c(this.field_70165_t - startX, this.field_70163_u - startY, this.field_70161_v - startZ);
        }
    }

    public void setPacketRelativePartPosition(DraetonPhysicsPart part, float x, float y, float z, float mx, float my, float mz) {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175144_cb()) {
            if (this.field_70170_p.field_72995_K) {
                part.lerpX = this.field_70165_t + (double)x;
                part.lerpY = this.field_70163_u + (double)y;
                part.lerpZ = this.field_70161_v + (double)z;
                part.lerpSteps = 10;
            } else if (part.type == DraetonPhysicsPart.Type.PULLER) {
                part.lerpX = part.x = this.field_70165_t + (double)x + part.motionX * (double)this.movementSyncTicks;
                part.lerpY = part.y = this.field_70163_u + (double)y + part.motionY * (double)this.movementSyncTicks;
                part.lerpZ = part.z = this.field_70161_v + (double)z + part.motionZ * (double)this.movementSyncTicks;
            } else {
                part.lerpX = part.x = this.field_70165_t + (double)x;
                part.lerpY = part.y = this.field_70163_u + (double)y;
                part.lerpZ = part.z = this.field_70161_v + (double)z;
            }
            part.motionX = mx;
            part.motionY = my;
            part.motionZ = mz;
        }
    }

    protected void handleControllerMovement(EntityLivingBase controller) {
        double dx = 0.0;
        double dz = 0.0;
        boolean input = false;
        if (controller.field_191988_bg > 0.0f) {
            dx += Math.cos(Math.toRadians(controller.field_70177_z + 90.0f));
            dz += Math.sin(Math.toRadians(controller.field_70177_z + 90.0f));
            input = true;
        }
        if (controller.field_191988_bg < 0.0f) {
            dx += Math.cos(Math.toRadians(controller.field_70177_z - 90.0f));
            dz += Math.sin(Math.toRadians(controller.field_70177_z - 90.0f));
            input = true;
        }
        if (controller.field_70702_br > 0.0f) {
            dx += Math.cos(Math.toRadians(controller.field_70177_z));
            dz += Math.sin(Math.toRadians(controller.field_70177_z));
            input = true;
        }
        if (controller.field_70702_br < 0.0f) {
            dx += Math.cos(Math.toRadians(controller.field_70177_z + 180.0f));
            dz += Math.sin(Math.toRadians(controller.field_70177_z + 180.0f));
            input = true;
        }
        if (input) {
            Vec3d dir = new Vec3d(dx, Math.sin(Math.toRadians(MathHelper.func_76125_a((int)((controller.field_70703_bu ? 45 : 0) + (this.descend ? -45 : 0)), (int)-90, (int)90))), dz).func_72432_b();
            double moveStrength = 0.1;
            for (DraetonPhysicsPart part : this.physicsParts) {
                if (part.type != DraetonPhysicsPart.Type.PULLER) continue;
                part.motionX += dir.field_72450_a * moveStrength * (double)(this.field_70146_Z.nextFloat() * 0.6f + 0.7f);
                part.motionZ += dir.field_72449_c * moveStrength * (double)(this.field_70146_Z.nextFloat() * 0.6f + 0.7f);
                part.motionY += dir.field_72448_b * moveStrength * (double)(this.field_70146_Z.nextFloat() * 0.6f + 0.7f);
            }
        }
    }

    protected void updateCarriage() {
        if (this.isBurnerRunning()) {
            for (DraetonLeakage leakage : this.leakages) {
                float leakageStrength = 0.005f + this.field_70170_p.field_73012_v.nextFloat() * 0.0075f;
                Vec3d dir = this.getRotatedBalloonPoint(new Vec3d(leakage.dir.field_72450_a, leakage.dir.field_72448_b, leakage.dir.field_72449_c * (double)0.1f), 1.0f);
                this.field_70159_w -= dir.field_72450_a * (double)leakageStrength;
                this.field_70181_x -= dir.field_72448_b * (double)leakageStrength * 0.5;
                this.field_70179_y -= dir.field_72449_c * (double)leakageStrength;
            }
        }
        for (DraetonPhysicsPart part : this.physicsParts) {
            Vec3d motion;
            Object entity = part.getEntity();
            if (part.type == DraetonPhysicsPart.Type.PULLER) {
                float pullerDrag = entity != null ? ((IPullerEntity)part.getEntity()).getDrag(0.9f) : 0.9f;
                part.motionX *= (double)pullerDrag;
                part.motionY *= (double)pullerDrag;
                part.motionZ *= (double)pullerDrag;
                if (!this.isControlling(part)) {
                    part.motionZ = 0.0;
                    part.motionY = 0.0;
                    part.motionX = 0.0;
                    part.x = ((Entity)entity).field_70165_t;
                    part.y = ((Entity)entity).field_70163_u;
                    part.z = ((Entity)entity).field_70161_v;
                } else {
                    float maxSpeed;
                    float speed = (float)Math.sqrt(part.motionX * part.motionX + part.motionY * part.motionY + part.motionZ * part.motionZ);
                    if (speed > (maxSpeed = this.getMaxPullerSpeed())) {
                        part.motionX *= (double)(1.0f / speed * maxSpeed);
                        part.motionY *= (double)(1.0f / speed * maxSpeed);
                        part.motionZ *= (double)(1.0f / speed * maxSpeed);
                    }
                    part.move(part.motionX, part.motionY, part.motionZ);
                }
                Vec3d pullerPos = new Vec3d(part.x, part.y, part.z);
                for (DraetonPhysicsPart otherPart : this.physicsParts) {
                    float minDist;
                    Vec3d otherPullerPos;
                    Vec3d diff;
                    double dist;
                    if (otherPart.type != DraetonPhysicsPart.Type.PULLER || !((dist = (diff = pullerPos.func_178788_d(otherPullerPos = new Vec3d(otherPart.x, otherPart.y, otherPart.z))).func_72433_c()) < (double)(minDist = 1.5f))) continue;
                    float pushStr = 0.75f;
                    part.motionX += diff.field_72450_a * ((double)minDist - dist) / (double)minDist * (double)pushStr;
                    part.motionY += diff.field_72448_b * ((double)minDist - dist) / (double)minDist * (double)pushStr;
                    part.motionZ += diff.field_72449_c * ((double)minDist - dist) / (double)minDist * (double)pushStr;
                }
            } else {
                if (part.grounded) {
                    part.motionX *= (double)0.8f;
                    part.motionZ *= (double)0.8f;
                    part.motionY = 0.0;
                } else {
                    part.motionX *= (double)0.98f;
                    part.motionY *= (double)0.98f;
                    part.motionZ *= (double)0.98f;
                }
                if (this.isFixated(part)) {
                    part.motionX = 0.0;
                    part.motionY = 0.0;
                    part.motionZ = 0.0;
                }
                part.motionY -= (double)0.1f;
                part.move(part.motionX, part.motionY, part.motionZ);
            }
            Vec3d tether = new Vec3d(part.x, part.y, part.z);
            Vec3d pos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178787_e(this.getPullPoint(part, 1.0f));
            Vec3d diff = tether.func_178788_d(pos);
            double dist = diff.func_72433_c();
            float tetherLength = this.getMaxTetherLength(part);
            if (dist > (double)(tetherLength + 6.0f)) {
                part.lerpX = part.x = this.field_70165_t;
                part.lerpY = part.y = this.field_70163_u;
                part.lerpZ = part.z = this.field_70161_v;
                dist = 0.0;
            }
            if (!(dist > (double)tetherLength)) continue;
            if (part.type == DraetonPhysicsPart.Type.PULLER || this.isFixated(part)) {
                float pullStrength = entity != null ? ((IPullerEntity)part.getEntity()).getPull(0.01f) : 0.05f;
                motion = diff.func_72432_b().func_186678_a((dist - (double)tetherLength) * (double)pullStrength);
                this.field_70159_w += motion.field_72450_a;
                this.field_70181_x += motion.field_72448_b;
                this.field_70179_y += motion.field_72449_c;
            }
            if (this.isFixated(part)) continue;
            if (part.type == DraetonPhysicsPart.Type.PULLER) {
                Vec3d constrainedTetherPos = pos.func_178787_e(diff.func_72432_b().func_186678_a((double)tetherLength));
                part.move(constrainedTetherPos.field_72450_a - part.x, constrainedTetherPos.field_72448_b - part.y, constrainedTetherPos.field_72449_c - part.z);
                Vec3d correction = diff.func_72432_b().func_186678_a((dist - (double)tetherLength) * (double)0.01f);
                part.motionX -= correction.field_72450_a;
                part.motionY -= correction.field_72448_b;
                part.motionZ -= correction.field_72449_c;
                continue;
            }
            Vec3d constrainedTetherPos = pos.func_178787_e(diff.func_72432_b().func_186678_a((double)tetherLength));
            part.move(constrainedTetherPos.field_72450_a - part.x, constrainedTetherPos.field_72448_b - part.y, constrainedTetherPos.field_72449_c - part.z);
            motion = new Vec3d(part.motionX, part.motionY, part.motionZ);
            motion = motion.func_178788_d(diff.func_72432_b().func_186678_a(motion.func_72430_b(diff.func_72432_b())));
            part.motionX = motion.field_72450_a;
            part.motionY = motion.field_72448_b;
            part.motionZ = motion.field_72449_c;
        }
        if (this.field_70170_p.field_72995_K && this.func_184186_bw() && this.field_70173_aa % this.movementSyncTicks == 0) {
            for (DraetonPhysicsPart part : this.physicsParts) {
                TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageUpdateDraetonPhysicsPart(this, part, MessageUpdateDraetonPhysicsPart.Action.UPDATE));
            }
        }
    }

    public float getMaxTetherLength(DraetonPhysicsPart part) {
        if (part.type == DraetonPhysicsPart.Type.ANCHOR) {
            return ((Float)this.field_70180_af.func_187225_a(ANCHOR_LENGTH)).floatValue();
        }
        return 6.0f;
    }

    public boolean isFixated(DraetonPhysicsPart part) {
        if (part.type == DraetonPhysicsPart.Type.ANCHOR) {
            return (Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED) != false && part.grounded;
        }
        return false;
    }

    public boolean isControlling(DraetonPhysicsPart part) {
        Vec3d pos;
        Vec3d tether;
        Vec3d diff;
        Object entity = part.getEntity();
        if (entity != null && (diff = (tether = new Vec3d(((Entity)entity).field_70165_t, ((Entity)entity).field_70163_u, ((Entity)entity).field_70161_v)).func_178788_d(pos = this.func_174791_d().func_178787_e(this.getPullPoint(part, 1.0f)))).func_72433_c() > (double)this.getMaxTetherLength(part)) {
            return true;
        }
        return this.func_184179_bs() != null && (entity == null || entity.func_184187_bx() == null);
    }

    public float getWidth(DraetonPhysicsPart part) {
        return 0.5f;
    }

    public float getHeight(DraetonPhysicsPart part) {
        if (part == this.anchorPhysicsPart) {
            return 0.75f;
        }
        return 0.5f;
    }

    public AxisAlignedBB getAabb(DraetonPhysicsPart part) {
        float width = this.getWidth(part);
        float height = this.getHeight(part);
        float yOff = 0.0f;
        if (part == this.anchorPhysicsPart) {
            yOff = this.getAnchorYOffset();
        }
        return new AxisAlignedBB(part.x - (double)(width / 2.0f), part.y + (double)yOff, part.z - (double)(width / 2.0f), part.x + (double)(width / 2.0f), part.y + (double)yOff + (double)height, part.z + (double)(width / 2.0f));
    }

    public void setPosToAabb(DraetonPhysicsPart part, AxisAlignedBB aabb) {
        float width = this.getWidth(part);
        float yOff = 0.0f;
        if (part == this.anchorPhysicsPart) {
            yOff = this.getAnchorYOffset();
        }
        part.x = aabb.field_72340_a + (double)(width / 2.0f);
        part.y = aabb.field_72338_b - (double)yOff;
        part.z = aabb.field_72339_c + (double)(width / 2.0f);
    }

    public boolean canCollide(DraetonPhysicsPart part) {
        return part != this.anchorPhysicsPart || (Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED) != false || !(this.getMaxTetherLength(part) < this.minAnchorLength + 0.1f);
    }

    protected float getAnchorYOffset() {
        return -0.3f;
    }

    public float getMaxPullerSpeed() {
        return 3.0f;
    }

    public Vec3d getPullPoint(DraetonPhysicsPart part, float partialTicks) {
        Vec3d basePoint;
        if (part.type == DraetonPhysicsPart.Type.ANCHOR) {
            return this.getRotatedCarriagePoint(new Vec3d(0.0, (double)0.025f, 1.25), partialTicks);
        }
        int index = part.slot;
        switch (index % 3) {
            default: {
                basePoint = new Vec3d(0.0, 0.875, 1.75);
                break;
            }
            case 0: {
                basePoint = new Vec3d((double)0.6f, 0.75, (double)1.55f);
                break;
            }
            case 2: {
                basePoint = new Vec3d((double)-0.6f, 0.75, (double)1.55f);
            }
        }
        return this.getRotatedCarriagePoint(basePoint, partialTicks);
    }

    public Vec3d getRotatedCarriagePoint(Vec3d pos, float partialTicks) {
        Matrix mat = new Matrix();
        mat.translate(0.0, 1.5, 0.0);
        mat.rotate((float)(-Math.toRadians(this.field_70126_B + (this.field_70177_z - this.field_70126_B) * partialTicks)), 0.0, 1.0, 0.0);
        mat.rotate((float)(-Math.toRadians(this.field_70127_C + (this.field_70125_A - this.field_70127_C) * partialTicks)), 1.0, 0.0, 0.0);
        mat.rotate((float)Math.toRadians(this.prevRotationRoll + (this.rotationRoll - this.prevRotationRoll) * partialTicks), 0.0, 0.0, 1.0);
        mat.translate(0.0, -1.5, 0.0);
        return mat.transform(pos);
    }

    public Vec3d getRotatedBalloonPoint(Vec3d pos, float partialTicks) {
        Matrix mat = new Matrix();
        mat.rotate((float)(-Math.toRadians(this.field_70126_B + (this.field_70177_z - this.field_70126_B) * partialTicks)), 0.0, 1.0, 0.0);
        mat.rotate((float)(-Math.toRadians(this.field_70127_C + (this.field_70125_A - this.field_70127_C) * partialTicks)), 1.0, 0.0, 0.0);
        mat.rotate((float)Math.toRadians(this.prevRotationRoll + (this.rotationRoll - this.prevRotationRoll) * partialTicks), 0.0, 0.0, 1.0);
        return mat.transform(pos);
    }

    public void setAnchorPos(BlockPos pos, boolean fixated) {
        this.field_70180_af.func_187227_b(ANCHOR_POS, (Object)pos);
        this.field_70180_af.func_187227_b(ANCHOR_FIXATED, (Object)fixated);
    }

    public BlockPos getAnchorPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(ANCHOR_POS);
    }

    public boolean isReelingInAnchor() {
        return (Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED) == false && (double)((Float)this.field_70180_af.func_187225_a(ANCHOR_LENGTH)).floatValue() > (double)this.minAnchorLength + 0.1 || this.anchorRetractTicks > 0;
    }

    public boolean isBurnerRunning() {
        return (Integer)this.field_70180_af.func_187225_a(BURNER_FUEL) > 0 && (!this.field_70122_E && !this.field_70171_ac || this.func_184179_bs() instanceof EntityLivingBase && ((EntityLivingBase)this.func_184179_bs()).field_70703_bu);
    }

    public int getBurnerFuel() {
        return (Integer)this.field_70180_af.func_187225_a(BURNER_FUEL);
    }

    public int getMaxBurnerFuel() {
        return this.maxFuel;
    }

    public void setBurnerFuel(int fuel) {
        this.field_70180_af.func_187227_b(BURNER_FUEL, (Object)fuel);
    }

    public List<DraetonLeakage> getLeakages() {
        return this.leakages;
    }

    public boolean isLeaking() {
        return this.isBurnerRunning() && !this.leakages.isEmpty();
    }

    public void setLeakages(List<DraetonLeakage> leakages) {
        this.leakages = leakages;
    }

    public void addLeakage(DraetonLeakage leakage) {
        this.leakages.add(leakage);
        TheBetweenlands.networkWrapper.sendToAllTracking((IMessage)new MessageSyncDraetonLeakages(this), (Entity)this);
    }

    public void removeLeakage(DraetonLeakage leakage) {
        this.leakages.remove(leakage);
        TheBetweenlands.networkWrapper.sendToAllTracking((IMessage)new MessageSyncDraetonLeakages(this), (Entity)this);
    }

    protected DraetonLeakage generateRandomLeakage() {
        Vec3d dir;
        Vec3d pos;
        float radius = 9.5f;
        switch (this.field_70170_p.field_73012_v.nextInt(6)) {
            default: {
                pos = new Vec3d((double)1.185f, (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.1f), (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 3.0f));
                dir = new Vec3d(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                pos = new Vec3d((double)-1.185f, (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.1f), (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 3.0f));
                dir = new Vec3d(-1.0, 0.0, 0.0);
                break;
            }
            case 2: {
                dir = new Vec3d((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 1.5f), 0.0, (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 4.0f)).func_178786_a(0.0, (double)(-radius), 0.0).func_72432_b();
                pos = dir.func_186678_a((double)radius).func_72441_c(0.0, (double)(1.06f - radius), 0.0);
                break;
            }
            case 3: {
                dir = new Vec3d((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 1.5f), 0.0, (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.5f)).func_178786_a(0.0, (double)(-radius), 0.0).func_72432_b();
                pos = dir.func_186678_a((double)radius).func_72441_c(0.0, (double)(-0.05f - radius), 0.0);
                dir = new Vec3d(-dir.field_72450_a, -dir.field_72448_b, -dir.field_72449_c);
                break;
            }
            case 4: {
                float y = this.field_70170_p.field_73012_v.nextFloat() * 0.6f - 0.1f;
                pos = new Vec3d((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.95f), (double)y, (double)(2.25f + y * 0.35f));
                dir = new Vec3d(0.0, (double)-0.35f, 1.0).func_72432_b();
                break;
            }
            case 5: {
                float y = this.field_70170_p.field_73012_v.nextFloat() * 0.6f - 0.1f;
                pos = new Vec3d((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.95f), (double)y, (double)(-2.25f - y * 0.35f));
                dir = new Vec3d(0.0, (double)-0.35f, -1.0).func_72432_b();
            }
        }
        return new DraetonLeakage(pos, dir, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        if (!this.func_184186_bw()) {
            super.func_70016_h(x, y, z);
        }
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        double dx = x - this.field_70165_t;
        double dy = y - this.field_70163_u;
        double dz = z - this.field_70161_v;
        super.func_70080_a(x, y, z, yaw, pitch);
        for (DraetonPhysicsPart part : this.physicsParts) {
            part.lerpX += dx;
            part.lerpY += dy;
            part.lerpZ += dz;
            part.x += dx;
            part.y += dy;
            part.z += dz;
            part.prevX = part.x;
            part.prevY = part.y;
            part.prevZ = part.z;
        }
        this.prevBalloonPos = this.balloonPos = this.balloonPos.func_72441_c(dx, dy, dz);
        this.updatePartPositions();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        if (!(entityIn instanceof IPullerEntity)) {
            super.func_70108_f(entityIn);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L) {
            if (source instanceof EntityDamageSource && (source.func_76346_g() != null && this.func_184196_w(source.func_76346_g()) || source.func_76364_f() != null && this.func_184196_w(source.func_76364_f()))) {
                return false;
            }
            boolean isPlayerHit = source.func_76364_f() instanceof EntityPlayer;
            if (!this.field_70170_p.field_72995_K) {
                if (isPlayerHit) {
                    this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
                } else {
                    this.setDamageTaken(Math.min(this.getDamageTaken() + amount * 10.0f, 25.0f));
                }
                if (isPlayerHit) {
                    boolean isCreative;
                    boolean bl = isCreative = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
                    if (isCreative || this.getDamageTaken() > 40.0f) {
                        if (!isCreative && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            this.func_145778_a(ItemRegistry.DRAETON, 1, 0.0f);
                        }
                        this.func_70106_y();
                    }
                } else if (this.getTimeSinceHit() < 5 && this.leakages.size() < 16 && this.field_70146_Z.nextInt(3) == 0) {
                    this.addLeakage(this.generateRandomLeakage());
                }
                if (this.getTimeSinceHit() < 5) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.DRAETON_DAMAGE, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
                this.setTimeSinceHit(10);
            }
            if (!isPlayerHit) {
                Vec3d bounce = source.func_188404_v();
                if (bounce != null) {
                    bounce = this.getBalloonPos(1.0f).func_178788_d(bounce);
                    bounce = new Vec3d(bounce.field_72450_a, 0.0, bounce.field_72449_c).func_72432_b().func_186678_a(0.5);
                } else {
                    bounce = new Vec3d((double)(this.field_70170_p.field_73012_v.nextFloat() - 0.5f), 0.0, (double)(this.field_70170_p.field_73012_v.nextFloat() - 0.5f)).func_186678_a(0.5);
                }
                this.balloonMotion = this.balloonMotion.func_178787_e(bounce);
            }
            return true;
        }
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.dropContentsWhenDead) {
            Iterator<DraetonPhysicsPart> partsIt = this.physicsParts.iterator();
            while (partsIt.hasNext()) {
                DraetonPhysicsPart part = partsIt.next();
                if (part.getEntity() == null) continue;
                ((IPullerEntity)part.getEntity()).spawnReleasedEntity();
                partsIt.remove();
            }
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 4; ++i) {
                    this.dropFurnaceContent(i);
                }
                InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.upgradesInventory);
                InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.burnerInventory);
            }
        }
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            if (!player.func_70093_af() && !player.func_184223_x((Entity)this)) {
                player.func_184220_m((Entity)this);
            } else {
                player.openGui((Object)TheBetweenlands.instance, 21, player.func_130014_f_(), this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return false;
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public IInventory getUpgradesInventory() {
        return this.upgradesInventory;
    }

    public IInventory getPullersInventory() {
        return this.pullersInventory;
    }

    public IInventory getBurnerInventory() {
        return this.burnerInventory;
    }

    public TileEntityDraetonFurnace getFurnace(int index) {
        return this.furnaces[index];
    }

    protected void dropFurnaceContent(int index) {
        Vec3d dropPos = this.getRotatedCarriagePoint(this.getUpgradePoint(index, 0.25f), 1.0f).func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        TileEntityDraetonFurnace furnaceInv = this.getFurnace(index);
        for (int i = 0; i < furnaceInv.func_70302_i_(); ++i) {
            ItemStack stack = furnaceInv.func_70301_a(i);
            if (!stack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)dropPos.field_72450_a, (double)dropPos.field_72448_b, (double)dropPos.field_72449_c, (ItemStack)stack);
            }
            furnaceInv.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public void openStorage(EntityPlayer player, int index) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.storageUsers[index] == 0 && this.isStorageUpgrade(this.getUpgradesInventory().func_70301_a(index))) {
                Vec3d upgradePos = this.getUpgradePoint(index, 0.25f).func_178787_e(this.func_174791_d());
                this.field_70170_p.func_184148_a(null, upgradePos.field_72450_a, upgradePos.field_72448_b, upgradePos.field_72449_c, SoundEvents.field_187657_V, SoundCategory.NEUTRAL, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            int n = index;
            this.storageUsers[n] = this.storageUsers[n] + 1;
            this.field_70180_af.func_187227_b((DataParameter)STORAGE_OPEN.get(index), (Object)true);
        }
    }

    public void closeStorage(EntityPlayer player, int index) {
        if (!this.field_70170_p.field_72995_K) {
            this.storageUsers[index] = Math.max(0, this.storageUsers[index] - 1);
            if (this.storageUsers[index] == 0) {
                if (this.isStorageUpgrade(this.getUpgradesInventory().func_70301_a(index))) {
                    Vec3d upgradePos = this.getUpgradePoint(index, 0.25f).func_178787_e(this.func_174791_d());
                    this.field_70170_p.func_184148_a(null, upgradePos.field_72450_a, upgradePos.field_72448_b, upgradePos.field_72449_c, SoundEvents.field_187651_T, SoundCategory.NEUTRAL, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                this.field_70180_af.func_187227_b((DataParameter)STORAGE_OPEN.get(index), (Object)false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(8.0);
    }

    public Entity[] func_70021_al() {
        return this.parts;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (part == this.upgradeAnchorPart && source instanceof EntityDamageSource && source.func_76364_f() != null && this.func_184196_w(source.func_76364_f())) {
            if (this.field_70170_p.field_72995_K && this.anchorRetractTicks == 0) {
                this.playPulleySound();
                this.pulleyRotationTicks = -20;
            }
            this.anchorRetractTicks = 20;
            return false;
        }
        return this.func_70097_a(source, damage);
    }

    protected boolean interactFromMultipart(EntityDraetonInteractionPart part, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (!held.func_190926_b() && held.func_77973_b() == ItemRegistry.LURKER_SKIN_PATCH) {
            for (int i = 0; i < Math.min(this.leakages.size(), this.leakageParts.length); ++i) {
                if (this.leakageParts[i] != part) continue;
                held.func_190918_g(1);
                player.func_184609_a(hand);
                this.field_70170_p.func_184148_a(null, this.leakageParts[i].field_70165_t, this.leakageParts[i].field_70163_u, this.leakageParts[i].field_70161_v, (SoundEvent)SoundRegistry.DRAETON_PLUG, SoundCategory.NEUTRAL, 1.2f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.removeLeakage(this.leakages.get(i));
                }
                return true;
            }
        }
        if (hand == EnumHand.MAIN_HAND) {
            if (part == this.guiPart) {
                if (!this.field_70170_p.field_72995_K) {
                    player.openGui((Object)TheBetweenlands.instance, 21, player.func_130014_f_(), this.func_145782_y(), 0, 0);
                }
                player.func_184609_a(hand);
                return true;
            }
            if (part == this.upgradePart1) {
                this.interactWithUpgrade(part, player, hand, 0);
            } else if (part == this.upgradePart2) {
                this.interactWithUpgrade(part, player, hand, 1);
            } else if (part == this.upgradePart3) {
                this.interactWithUpgrade(part, player, hand, 2);
            } else if (part == this.upgradePart4) {
                this.interactWithUpgrade(part, player, hand, 3);
            } else {
                if (part == this.burnerPart) {
                    if (!held.func_190926_b() && held.func_77973_b() == ItemRegistry.DENTROTHYST_FLUID_VIAL) {
                        ItemStack input;
                        ItemStack result;
                        if (!this.field_70170_p.field_72995_K && !(result = this.tryFillingBurner(input = held.func_77946_l())).equals(input)) {
                            this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FluidRegistry.SHALLOWBREATH.getEmptySound(new FluidStack(FluidRegistry.SHALLOWBREATH, 1000)), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            if (!player.func_184812_l_()) {
                                player.func_184611_a(hand, result);
                            }
                        }
                        player.func_184609_a(hand);
                        return true;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        player.openGui((Object)TheBetweenlands.instance, 18, player.func_130014_f_(), this.func_145782_y(), 0, 0);
                    }
                    player.func_184609_a(hand);
                    return true;
                }
                if (part == this.upgradeAnchorPart) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70180_af.func_187227_b(ANCHOR_DEPLOYED, (Object)((Boolean)this.field_70180_af.func_187225_a(ANCHOR_DEPLOYED) == false ? 1 : 0));
                    }
                    player.func_184609_a(hand);
                    return true;
                }
            }
        }
        return false;
    }

    protected void interactWithUpgrade(EntityDraetonInteractionPart part, EntityPlayer player, EnumHand hand, int index) {
        ItemStack stack = this.getUpgradesInventory().func_70301_a(index);
        if (!stack.func_190926_b()) {
            if (this.isFurnaceUpgrade(stack)) {
                if (!this.field_70170_p.field_72995_K) {
                    player.openGui((Object)TheBetweenlands.instance, 20, player.func_130014_f_(), this.func_145782_y(), index, 0);
                }
                player.func_184609_a(hand);
            } else if (this.isStorageUpgrade(stack)) {
                if (!this.field_70170_p.field_72995_K) {
                    player.openGui((Object)TheBetweenlands.instance, 17, player.func_130014_f_(), this.func_145782_y(), index, 0);
                }
                player.func_184609_a(hand);
            } else if (this.isCraftingUpgrade(stack)) {
                if (!this.field_70170_p.field_72995_K) {
                    player.openGui((Object)TheBetweenlands.instance, 19, player.func_130014_f_(), this.func_145782_y(), index, 0);
                }
                player.func_184609_a(hand);
            }
        }
    }

    public void onPullerSlotChanged(int index) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack;
            DraetonPhysicsPart puller = this.getPhysicsPartBySlot(index, DraetonPhysicsPart.Type.PULLER);
            if (puller != null) {
                Object entity = puller.getEntity();
                if (entity != null) {
                    entity.func_184174_b(false);
                    entity.func_70106_y();
                }
                this.physicsParts.remove(puller);
                TheBetweenlands.networkWrapper.sendToAllTracking((IMessage)new MessageUpdateDraetonPhysicsPart(this, puller, MessageUpdateDraetonPhysicsPart.Action.REMOVE), (Entity)this);
            }
            if (!(stack = this.getPullersInventory().func_70301_a(index)).func_190926_b() && stack.func_77973_b() instanceof ItemMob) {
                Object pullerEntity;
                Entity capturedEntity = ((ItemMob)stack.func_77973_b()).createCapturedEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                Object spawnedEntity = null;
                if (capturedEntity instanceof IPullerEntityProvider && (pullerEntity = ((IPullerEntityProvider)capturedEntity).createPuller(this, puller = new DraetonPhysicsPart(DraetonPhysicsPart.Type.PULLER, this, this.nextPhysicsPartId++, index))) instanceof IPullerEntity) {
                    Vec3d pos = this.getPullPoint(puller, 1.0f).func_178787_e(this.func_174791_d());
                    puller.lerpX = puller.x = pos.field_72450_a;
                    puller.lerpY = puller.y = pos.field_72448_b;
                    puller.lerpZ = puller.z = pos.field_72449_c;
                    this.physicsParts.add(puller);
                    pullerEntity.func_70020_e(capturedEntity.func_189511_e(new NBTTagCompound()));
                    pullerEntity.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
                    this.field_70170_p.func_72838_d(pullerEntity);
                    spawnedEntity = pullerEntity;
                    puller.setEntity((IPullerEntity)pullerEntity);
                    TheBetweenlands.networkWrapper.sendToAllTracking((IMessage)new MessageUpdateDraetonPhysicsPart(this, puller, MessageUpdateDraetonPhysicsPart.Action.ADD), (Entity)this);
                }
                if (capturedEntity != null && capturedEntity != spawnedEntity) {
                    capturedEntity.func_70106_y();
                }
            }
        }
    }

    public boolean isFurnaceUpgrade(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.DRAETON_UPGRADE_FURNACE;
    }

    public boolean isStorageUpgrade(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.LURKER_SKIN_POUCH;
    }

    public boolean isCraftingUpgrade(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.DRAETON_UPGRADE_CRAFTING;
    }

    public boolean isAnchorUpgrade(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.DRAETON_UPGRADE_ANCHOR;
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer packetBuffer = new PacketBuffer(buffer);
        MessageSyncDraetonLeakages.serialize(this.leakages, packetBuffer);
        buffer.writeInt(this.physicsParts.size());
        for (DraetonPhysicsPart part : this.physicsParts) {
            MessageUpdateDraetonPhysicsPart msg = new MessageUpdateDraetonPhysicsPart(this, part, MessageUpdateDraetonPhysicsPart.Action.UPDATE);
            msg.serialize(packetBuffer);
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        PacketBuffer packetBuffer = new PacketBuffer(buffer);
        this.leakages.clear();
        MessageSyncDraetonLeakages.deserialize(this.leakages, packetBuffer);
        this.physicsParts.clear();
        int numParts = buffer.readInt();
        for (int i = 0; i < numParts; ++i) {
            MessageUpdateDraetonPhysicsPart msg = new MessageUpdateDraetonPhysicsPart();
            msg.deserialize(packetBuffer);
            msg.processClient(this);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity target = event.getRayTraceResult().field_72308_g;
        if (event.getEntity().field_70173_aa < 3 && (target instanceof EntityDraeton || target instanceof EntityDraetonInteractionPart)) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean isUnmountBlocked(EntityPlayer rider) {
        return !this.field_70170_p.field_72995_K && this.unmountTicks.get((Object)rider) < 40;
    }

    @Override
    public void onUnmountBlocked(EntityPlayer rider) {
        if (!this.field_70170_p.field_72995_K) {
            int unmountTicks = this.unmountTicks.adjustOrPutValue((Object)rider, 1, 0);
            if (rider instanceof EntityPlayerMP) {
                ((EntityPlayerMP)rider).func_146105_b((ITextComponent)new TextComponentTranslation("chat.draeton_dismount_timer", new Object[]{String.valueOf(unmountTicks == 40 ? 0 : (40 - unmountTicks) / 14 + 1)}), true);
            }
        }
    }

    @Override
    public boolean shouldPreventStatusBarText(EntityPlayer rider) {
        return false;
    }
}

