/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.block.container.BlockLootUrn;
import thebetweenlands.common.block.container.BlockMudBrickAlcove;
import thebetweenlands.common.entity.EntityShockwaveBlock;
import thebetweenlands.common.entity.ai.IPathObstructionAwareEntity;
import thebetweenlands.common.entity.ai.PathNavigateBarrishee;
import thebetweenlands.common.entity.mobs.EntityAshSprite;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityMudBrickAlcove;
import thebetweenlands.common.world.gen.feature.structure.utils.SludgeWormMazeBlockHelper;
import thebetweenlands.common.world.storage.location.LocationGuarded;

public class EntityBarrishee
extends EntityMob
implements IEntityScreenShake,
IEntityBL,
IPathObstructionAwareEntity {
    private static final DataParameter<Boolean> AMBUSH_SPAWNED = EntityDataManager.func_187226_a(EntityBarrishee.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SCREAM = EntityDataManager.func_187226_a(EntityBarrishee.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SCREAM_TIMER = EntityDataManager.func_187226_a(EntityBarrishee.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SCREAM_BEAM = EntityDataManager.func_187226_a(EntityBarrishee.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLAMMING_ANIMATION = EntityDataManager.func_187226_a(EntityBarrishee.class, (DataSerializer)DataSerializers.field_187198_h);
    public float standingAngle;
    public float prevStandingAngle;
    private SludgeWormMazeBlockHelper blockHelper = new SludgeWormMazeBlockHelper(null);
    private int prevScreamTimer;
    public int screamTimer;
    private int screamingTimerMax = 50;
    protected int actionCooldown = 0;
    protected static final int MUTEX_SPECIAL_ATTACK = 8;

    public EntityBarrishee(World world) {
        super(world);
        this.func_70105_a(2.25f, 1.8f);
        this.field_70728_aV = 150;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AMBUSH_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(SCREAM, (Object)false);
        this.field_70180_af.func_187214_a(SCREAM_TIMER, (Object)50);
        this.field_70180_af.func_187214_a(SCREAM_BEAM, (Object)false);
        this.field_70180_af.func_187214_a(SLAMMING_ANIMATION, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBlockBreakAttack(this, 60, 100));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISonicAttack(this, 32, 50));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISlamAttack(this, 22, 40));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIBarrisheeAttack(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 50));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null).func_190882_b(1200));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateBarrishee(this, worldIn);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.BARRISHEE;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.BARRISHEE_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.BARRISHEE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.BARRISHEE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundRegistry.BARRISHEE_STEP, 0.5f, 1.0f);
    }

    protected SoundEvent getScreamSound() {
        return SoundRegistry.BARRISHEE_SCREAM;
    }

    public boolean isAmbushSpawn() {
        return (Boolean)this.field_70180_af.func_187225_a(AMBUSH_SPAWNED);
    }

    public void setIsAmbushSpawn(boolean is_ambush) {
        this.field_70180_af.func_187227_b(AMBUSH_SPAWNED, (Object)is_ambush);
    }

    public void setIsScreaming(boolean scream) {
        this.field_70180_af.func_187227_b(SCREAM, (Object)scream);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAM);
    }

    public void setScreamTimer(int scream_timer) {
        this.field_70180_af.func_187227_b(SCREAM_TIMER, (Object)scream_timer);
    }

    public int getScreamTimer() {
        return (Integer)this.field_70180_af.func_187225_a(SCREAM_TIMER);
    }

    public void setIsScreamingBeam(boolean scream_beam) {
        this.field_70180_af.func_187227_b(SCREAM_BEAM, (Object)scream_beam);
    }

    public boolean isScreamingBeam() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAM_BEAM);
    }

    public void setIsSlamming(boolean slamming) {
        this.field_70180_af.func_187227_b(SLAMMING_ANIMATION, (Object)slamming);
    }

    public boolean isSlamming() {
        return (Boolean)this.field_70180_af.func_187225_a(SLAMMING_ANIMATION);
    }

    public boolean func_70058_J() {
        return !this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70641_bl() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSmoothedStandingAngle(float partialTicks) {
        return this.prevStandingAngle + (this.standingAngle - this.prevStandingAngle) * partialTicks;
    }

    public void func_70636_d() {
        if (this.func_130014_f_().field_72995_K && !this.isSlamming()) {
            this.prevStandingAngle = this.standingAngle;
            if (this.standingAngle <= 0.1f) {
                this.standingAngle += this.isAmbushSpawn() ? 0.01f : 0.2f;
            }
            if (this.standingAngle > 0.1f && this.standingAngle <= 1.0f) {
                this.standingAngle += this.isAmbushSpawn() ? 0.1f : 0.2f;
            }
            if (this.standingAngle > 1.0f) {
                this.standingAngle = 1.0f;
                if (this.isAmbushSpawn()) {
                    this.setIsAmbushSpawn(false);
                }
            }
        }
        if (this.func_130014_f_().field_72995_K && this.isSlamming()) {
            this.prevStandingAngle = this.standingAngle;
            if (this.standingAngle >= 0.0f && this.standingAngle <= 1.0f) {
                this.standingAngle -= 0.2f;
            }
            if (this.standingAngle < 0.0f) {
                this.setIsSlamming(false);
                this.standingAngle = 0.0f;
            }
        }
        this.prevScreamTimer = this.getScreamTimer();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getScreamTimer() == 0) {
                this.setIsScreaming(true);
                this.setScreamTimer(1);
            }
            if (this.getScreamTimer() == 1) {
                this.func_130014_f_().func_184133_a(null, this.func_180425_c(), this.getScreamSound(), SoundCategory.HOSTILE, 0.75f, 0.5f);
            }
            if (this.getScreamTimer() > 0 && this.getScreamTimer() <= this.screamingTimerMax) {
                this.setScreamTimer(this.getScreamTimer() + 1);
            }
            this.setIsScreaming(this.getScreamTimer() < this.screamingTimerMax);
            if (this.func_70638_az() != null) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 100.0f, 100.0f);
                if (this.isScreaming()) {
                    this.func_70661_as().func_75484_a(this.func_70661_as().func_75494_a((Entity)this.func_70638_az()), 0.0);
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.isScreamingBeam()) {
            this.spawnScreamParticles();
        }
        if (!this.field_70170_p.field_72995_K && this.isScreaming() && !this.isScreamingBeam() && this.getScreamTimer() >= 25) {
            this.breakBlocksForAOEScream(this.getAOEScreamBounds());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isDoingSpecialAttack()) {
                this.actionCooldown = 60;
            } else if (this.actionCooldown > 0) {
                --this.actionCooldown;
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.pushEntitiesAway();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        if (entityIn.func_70067_L()) {
            AxisAlignedBB collisionBox = entityIn.func_70046_E();
            return collisionBox != null ? collisionBox : entityIn.func_174813_aQ();
        }
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
    }

    protected void pushEntitiesAway() {
        AxisAlignedBB collisionAABB = this.func_70046_E().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (collisionAABB != null) {
            List entities = this.field_70170_p.func_72839_b((Entity)this, collisionAABB);
            for (Entity entity : entities) {
                AxisAlignedBB entityAABB;
                if (!entity.func_70067_L() || !entity.func_70104_M() || (entityAABB = this.func_70114_g(entity)) == null) continue;
                double dx = Math.max(collisionAABB.field_72340_a - entityAABB.field_72336_d, entityAABB.field_72340_a - collisionAABB.field_72336_d);
                double dz = Math.max(collisionAABB.field_72339_c - entityAABB.field_72334_f, entityAABB.field_72339_c - collisionAABB.field_72334_f);
                if (Math.abs(dz) < Math.abs(dx)) {
                    entity.func_70091_d(MoverType.PISTON, 0.0, 0.0, (dz - 0.005) * Math.signum(this.field_70161_v - entity.field_70161_v));
                } else {
                    entity.func_70091_d(MoverType.PISTON, (dx - 0.005) * Math.signum(this.field_70165_t - entity.field_70165_t), 0.0, 0.0);
                }
                entity.func_70091_d(MoverType.PISTON, 0.0, -0.01, 0.0);
            }
        }
    }

    private void breakBlocksForAOEScream(AxisAlignedBB aoeScreamBounds) {
        if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            int minX = MathHelper.func_76128_c((double)aoeScreamBounds.field_72340_a);
            int minY = MathHelper.func_76128_c((double)aoeScreamBounds.field_72338_b);
            int minZ = MathHelper.func_76128_c((double)aoeScreamBounds.field_72339_c);
            int maxX = MathHelper.func_76128_c((double)aoeScreamBounds.field_72336_d);
            int maxY = MathHelper.func_76128_c((double)aoeScreamBounds.field_72337_e);
            int maxZ = MathHelper.func_76128_c((double)aoeScreamBounds.field_72334_f);
            for (int sizeX = minX; sizeX <= maxX; ++sizeX) {
                for (int sizeZ = minZ; sizeZ <= maxZ; ++sizeZ) {
                    for (int sizeY = minY; sizeY <= maxY; ++sizeY) {
                        BlockPos pos = new BlockPos(sizeX, sizeY, sizeZ);
                        IBlockState state = this.func_130014_f_().func_180495_p(pos);
                        if (state.func_177230_c() instanceof BlockMudBrickAlcove && this.checkAlcoveForUrn(this.field_70170_p, state)) {
                            this.setAlcoveUrnEmpty(this.field_70170_p, pos, state);
                        }
                        if (!(state.func_185887_b(this.field_70170_p, pos) >= 0.0f) || !state.func_177230_c().canEntityDestroy(state, (IBlockAccess)this.field_70170_p, pos, (Entity)this)) continue;
                        if (state.func_177230_c() instanceof BlockLootUrn) {
                            this.spawnAshSpriteMinion(this.func_130014_f_(), pos, state);
                            this.field_70170_p.func_175655_b(pos, true);
                            continue;
                        }
                        if (LocationGuarded.isLocationGuarded(this.field_70170_p, (Entity)this, pos) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)state)) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                    }
                }
            }
        }
    }

    @Nullable
    public static TileEntityMudBrickAlcove getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMudBrickAlcove) {
            return (TileEntityMudBrickAlcove)tile;
        }
        return null;
    }

    private void setAlcoveUrnEmpty(World world, BlockPos pos, IBlockState state) {
        BlockPos offsetPos = pos;
        TileEntityMudBrickAlcove tile = EntityBarrishee.getTileEntity((IBlockAccess)world, pos);
        if (tile instanceof TileEntityMudBrickAlcove && tile.hasUrn) {
            TileEntityMudBrickAlcove tileInv = tile;
            if (tileInv != null) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockMudBrickAlcove.FACING);
                offsetPos = pos.func_177972_a(facing);
                InventoryHelper.func_180175_a((World)world, (BlockPos)offsetPos, (IInventory)tileInv);
            }
            this.spawnAshSpriteMinion(this.func_130014_f_(), pos, state);
            world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)state.func_177230_c()));
            tile.hasUrn = false;
            world.func_184138_a(pos, state, state, 2);
        }
    }

    private void spawnAshSpriteMinion(World world, BlockPos pos, IBlockState state) {
        BlockPos offsetPos = pos;
        if (state.func_177230_c() instanceof BlockMudBrickAlcove) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockMudBrickAlcove.FACING);
            offsetPos = pos.func_177972_a(facing);
        }
        EntityAshSprite entity = new EntityAshSprite(world);
        entity.func_70012_b((double)offsetPos.func_177958_n() + 0.5, offsetPos.func_177956_o(), (double)offsetPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        entity.setBoundOrigin(offsetPos);
        world.func_72838_d((Entity)entity);
    }

    private boolean checkAlcoveForUrn(World entityWorld, IBlockState state) {
        return (Boolean)state.func_177229_b(BlockMudBrickAlcove.HAS_URN);
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnScreamParticles() {
        Vec3d look = this.func_70676_i(1.0f).func_72432_b();
        float speed = 0.6f;
        Particle particle = BLParticles.SONIC_SCREAM.create(this.field_70170_p, this.field_70165_t, this.field_70163_u + (this.getScreamTimer() < 25 ? 0.8 + (double)((float)this.getScreamTimer() * 0.0125f) : 1.25 - (double)((float)(25 - this.getScreamTimer()) * 0.025f)), this.field_70161_v, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(look.field_72450_a * (double)speed, look.field_72448_b * (double)speed, look.field_72449_c * (double)speed)).withScale(10.0f)).withData(30, MathHelper.func_76141_d((float)((float)this.field_70173_aa * 3.3f)))).withColor(1.0f, 0.9f, 0.8f, 1.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING, particle);
    }

    private boolean isLookingAtAttackTarget(Entity entity) {
        Vec3d vec3d = this.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(entity.field_70165_t - this.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)entity.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e()), entity.field_70161_v - this.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? this.func_70685_l(entity) : false;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX();
    }

    public float getScreamingProgress(float delta) {
        return 1.0f / (float)this.screamingTimerMax * ((float)this.prevScreamTimer + (float)(this.screamTimer - this.prevScreamTimer) * delta);
    }

    public AxisAlignedBB getAOEScreamBounds() {
        float boxsizeUnit = 0.0275f * (float)this.getScreamTimer();
        AxisAlignedBB bounds = this.func_174813_aQ();
        return bounds.func_72314_b((double)boxsizeUnit, 0.0, (double)boxsizeUnit).func_72321_a(0.0, 1.0, 0.0);
    }

    public boolean isDoingSpecialAttack() {
        return this.isScreaming() || this.isScreamingBeam() || this.isSlamming();
    }

    public boolean isReadyForSpecialAttack() {
        if (this.isDoingSpecialAttack()) {
            return false;
        }
        return this.actionCooldown <= 0;
    }

    @Override
    public void onPathingObstructed(EnumFacing facing) {
        if (this.func_70638_az() != null && this.isReadyForSpecialAttack()) {
            this.setScreamTimer(0);
        }
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.isScreaming()) {
            double dist = this.func_70032_d(viewer);
            float screamMult = (float)(1.0 - dist / 30.0);
            if (dist >= 30.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.getScreamingProgress(partialTicks) * Math.PI) + (double)0.1f) * (double)0.15f * (double)screamMult);
        }
        return 0.0f;
    }

    static class AIBarrisheeAttack
    extends EntityAIAttackMelee {
        public AIBarrisheeAttack(EntityBarrishee barrishee) {
            super((EntityCreature)barrishee, 1.0, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    static class AISlamAttack
    extends EntityAIBase {
        EntityBarrishee barrishee;
        int cooldown;
        int minCooldown;
        int maxCooldown;
        int missileCount;
        int shootCount;

        public AISlamAttack(EntityBarrishee barrishee, int minCooldown, int maxCooldown) {
            this.barrishee = barrishee;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.cooldown = minCooldown + barrishee.field_70146_Z.nextInt(maxCooldown - minCooldown);
            this.func_75248_a(9);
        }

        public boolean func_75250_a() {
            double distance;
            EntityLivingBase target = this.barrishee.func_70638_az();
            if (target != null && (distance = this.barrishee.func_70068_e((Entity)target)) >= 9.0 && distance <= 81.0 && this.barrishee.field_70122_E && this.barrishee.isReadyForSpecialAttack()) {
                return this.cooldown-- < 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            EntityLivingBase target = this.barrishee.func_70638_az();
            return target != null && this.shootCount != -1 && this.missileCount != -1 && this.barrishee.isLookingAtAttackTarget((Entity)target);
        }

        public void func_75249_e() {
            this.missileCount = 0;
            this.shootCount = 0;
            this.barrishee.setIsSlamming(true);
        }

        public void func_75251_c() {
            this.cooldown = this.minCooldown + this.barrishee.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown);
            this.shootCount = -1;
            this.missileCount = -1;
            if (this.barrishee.isSlamming()) {
                this.barrishee.setIsSlamming(false);
            }
        }

        public void func_75246_d() {
            EntityLivingBase target = this.barrishee.func_70638_az();
            if (target != null) {
                int distance = MathHelper.func_76141_d((float)this.barrishee.func_70032_d((Entity)target));
                if (this.barrishee.isLookingAtAttackTarget((Entity)target)) {
                    float f = (float)MathHelper.func_181159_b((double)(target.field_70161_v - this.barrishee.field_70161_v), (double)(target.field_70165_t - this.barrishee.field_70165_t));
                    ++this.missileCount;
                    if (this.missileCount % 2 == 0) {
                        ++this.shootCount;
                        if (this.shootCount == 1) {
                            this.barrishee.func_130014_f_().func_184133_a(null, this.barrishee.func_180425_c(), (SoundEvent)SoundRegistry.WALL_SLAM, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        }
                        double d2 = 2.5 + 1.0 * (double)this.shootCount;
                        BlockPos origin = new BlockPos(this.barrishee.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, this.barrishee.field_70163_u - 1.0, this.barrishee.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2);
                        IBlockState block = this.barrishee.func_130014_f_().func_180495_p(origin);
                        if (block.func_185915_l() && !block.func_177230_c().hasTileEntity(block) && block.func_185887_b(this.barrishee.func_130014_f_(), origin) <= 5.0f && block.func_185887_b(this.barrishee.func_130014_f_(), origin) >= 0.0f && this.barrishee.func_130014_f_().func_180495_p(origin).func_185914_p()) {
                            EntityShockwaveBlock shockwaveBlock = new EntityShockwaveBlock(this.barrishee.func_130014_f_());
                            shockwaveBlock.setOrigin(origin, 10, (double)origin.func_177958_n() + 0.5, (double)origin.func_177952_p() + 0.5, (Entity)this.barrishee);
                            shockwaveBlock.func_70012_b((double)origin.func_177958_n() + 0.5, origin.func_177956_o(), (double)origin.func_177952_p() + 0.5, 0.0f, 0.0f);
                            shockwaveBlock.setBlock(Block.func_149729_e((int)Block.func_149682_b((Block)this.barrishee.func_130014_f_().func_180495_p(origin).func_177230_c())), this.barrishee.func_130014_f_().func_180495_p(origin).func_177230_c().func_176201_c(this.barrishee.func_130014_f_().func_180495_p(origin)));
                            this.barrishee.func_130014_f_().func_72838_d((Entity)shockwaveBlock);
                        }
                    }
                }
                if (this.shootCount >= distance || this.shootCount >= 9 || target.field_70128_L) {
                    this.func_75251_c();
                }
            }
        }
    }

    static class AISonicAttack
    extends EntityAIBase {
        EntityBarrishee barrishee;
        int cooldown;
        int minCooldown;
        int maxCooldown;
        int missileCount;
        int shootCount;

        public AISonicAttack(EntityBarrishee barrishee, int minCooldown, int maxCooldown) {
            this.barrishee = barrishee;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.cooldown = minCooldown + barrishee.field_70146_Z.nextInt(maxCooldown - minCooldown);
            this.func_75248_a(11);
        }

        public boolean func_75250_a() {
            double distance;
            EntityLivingBase target = this.barrishee.func_70638_az();
            if (target != null && (distance = this.barrishee.func_70068_e((Entity)target)) >= 9.0 && distance <= 144.0 && this.barrishee.field_70122_E && this.barrishee.isReadyForSpecialAttack() && this.barrishee.isLookingAtAttackTarget((Entity)target)) {
                return this.cooldown-- < 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.barrishee.func_70638_az() != null && this.shootCount != -1 && this.missileCount != -1;
        }

        public void func_75249_e() {
            this.missileCount = 0;
            this.shootCount = 0;
            this.barrishee.func_130014_f_().func_184133_a(null, this.barrishee.func_180425_c(), this.barrishee.getScreamSound(), SoundCategory.HOSTILE, 0.75f, 0.5f);
            this.barrishee.setScreamTimer(0);
        }

        public void func_75251_c() {
            this.cooldown = this.minCooldown + this.barrishee.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown);
            this.shootCount = -1;
            this.missileCount = -1;
            if (this.barrishee.isScreamingBeam()) {
                this.barrishee.setIsScreamingBeam(false);
            }
        }

        public void func_75246_d() {
            EntityLivingBase target = this.barrishee.func_70638_az();
            if (target != null) {
                int distance = MathHelper.func_76141_d((float)this.barrishee.func_70032_d((Entity)target));
                if (this.barrishee.getScreamTimer() >= 25) {
                    if (!this.barrishee.isScreamingBeam()) {
                        this.barrishee.setIsScreamingBeam(true);
                    }
                    float f = (float)MathHelper.func_181159_b((double)(target.field_70161_v - this.barrishee.field_70161_v), (double)(target.field_70165_t - this.barrishee.field_70165_t));
                    ++this.missileCount;
                    if (this.missileCount % 2 == 0) {
                        ++this.shootCount;
                        double d2 = 2.0 + 1.0 * (double)this.shootCount;
                        this.checkIfBeamHitsAnyone(this.barrishee.func_130014_f_(), new BlockPos(this.barrishee.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, this.barrishee.field_70163_u + (double)this.barrishee.func_70047_e(), this.barrishee.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2));
                    }
                }
                if (this.shootCount >= distance || this.shootCount >= 12 || target.field_70128_L) {
                    this.func_75251_c();
                }
            }
        }

        public void checkIfBeamHitsAnyone(World world, BlockPos pos) {
            AxisAlignedBB hitBox = new AxisAlignedBB(pos).func_72314_b(0.0, 0.25, 0.0);
            List list = world.func_72872_a(EntityLivingBase.class, hitBox);
            for (EntityLivingBase entity : list) {
                if (!this.barrishee.func_70652_k((Entity)entity)) continue;
                entity.func_70653_a((Entity)this.barrishee, 0.75f, (double)MathHelper.func_76126_a((float)(this.barrishee.field_70177_z * 3.141593f / 180.0f)), (double)(-MathHelper.func_76134_b((float)(this.barrishee.field_70177_z * 3.141593f / 180.0f))));
            }
        }
    }

    static class AIBlockBreakAttack
    extends EntityAIBase {
        EntityBarrishee barrishee;
        int cooldown;
        int minCooldown;
        int maxCooldown;

        public AIBlockBreakAttack(EntityBarrishee barrishee, int minCooldown, int maxCooldown) {
            this.barrishee = barrishee;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.cooldown = minCooldown + barrishee.field_70146_Z.nextInt(maxCooldown - minCooldown);
            this.func_75248_a(11);
        }

        public boolean func_75250_a() {
            if (this.barrishee.func_70638_az() != null && this.barrishee.isReadyForSpecialAttack()) {
                return this.cooldown-- < 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.barrishee.setScreamTimer(0);
        }

        public void func_75251_c() {
            this.cooldown = this.minCooldown + this.barrishee.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown);
        }
    }
}

