/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.projectiles.EntitySnailPoisonJet;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityBloodSnail
extends EntityMob
implements IEntityBL {
    public static final IAttribute RANGED_ATTACK_MIN_DIST_ATTRIB = new RangedAttribute(null, "bl.rangedAttackMinDist", 3.0, 0.0, Double.MAX_VALUE).func_111117_a("Minimum range at which the ranged attack is used");
    public static final IAttribute RANGED_ATTACK_COOLDOWN_ATTRIB = new RangedAttribute(null, "bl.rangedAttackCooldown", 50.0, 0.0, 2.147483647E9).func_111117_a("Ranged attack cooldown in ticks");
    protected int rangedAttackTimer = 0;

    public EntityBloodSnail(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.5f);
        this.field_70138_W = 0.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110140_aT().func_111150_b(RANGED_ATTACK_MIN_DIST_ATTRIB);
        this.func_110140_aT().func_111150_b(RANGED_ATTACK_COOLDOWN_ATTRIB);
    }

    public int func_70641_bl() {
        return 3;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.BLOOD_SNAIL;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.SNAIL_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.SNAIL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SNAIL_DEATH;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLiving) {
                int duration = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0) {
                    ((EntityLiving)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
                    ((EntityLiving)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        double minDist;
        float distance;
        super.func_70071_h_();
        if (this.func_70638_az() != null && this.func_70089_S() && (double)(distance = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v)) > (minDist = this.func_110148_a(RANGED_ATTACK_MIN_DIST_ATTRIB).func_111126_e())) {
            int cooldown = (int)this.func_110148_a(RANGED_ATTACK_COOLDOWN_ATTRIB).func_111126_e();
            if (this.getRangeAttackTimer() < cooldown) {
                this.setRangeAttackTimer(this.getRangeAttackTimer() + 1);
            } else if (this.getRangeAttackTimer() >= cooldown) {
                this.shootMissile(this.func_70638_az(), distance);
            }
        }
    }

    public void shootMissile(EntityLivingBase entity, float distance) {
        this.setRangeAttackTimer(0);
        if (this.func_70685_l((Entity)entity)) {
            EntitySnailPoisonJet missile = new EntitySnailPoisonJet(this.field_70170_p, (EntityLiving)this);
            missile.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            missile.field_70125_A -= -20.0f;
            double targetX = entity.field_70165_t + entity.field_70159_w - this.field_70165_t;
            double targetY = entity.field_70163_u + (double)entity.func_70047_e() / 2.0 - this.field_70163_u;
            double targetZ = entity.field_70161_v + entity.field_70179_y - this.field_70161_v;
            float target = MathHelper.func_76133_a((double)(targetX * targetX + targetZ * targetZ));
            missile.func_70186_c(targetX, targetY + (double)(target * 0.1f), targetZ, 0.75f, 8.0f);
            this.field_70170_p.func_72838_d((Entity)missile);
        }
    }

    public int getRangeAttackTimer() {
        return this.rangedAttackTimer;
    }

    public void setRangeAttackTimer(int size) {
        this.rangedAttackTimer = size;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

