/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntityFortressBoss;
import thebetweenlands.common.entity.mobs.EntityFortressBossProjectile;

public class EntityFortressBossTurret
extends EntityMob
implements IEntityBL {
    protected static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityFortressBossTurret.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Optional<UUID>> TARGET = EntityDataManager.func_187226_a(EntityFortressBossTurret.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> DEFLECTION_STATE = EntityDataManager.func_187226_a(EntityFortressBossTurret.class, (DataSerializer)DataSerializers.field_187198_h);
    private Entity cachedOwner;
    private Entity cachedTarget;
    private boolean particlesSpawned = false;
    private int attackTicks = 0;
    private int attackDelay = 40;

    public EntityFortressBossTurret(World world) {
        super(world);
        float width = 0.4f;
        float height = 0.4f;
        this.func_70105_a(width, height);
    }

    public EntityFortressBossTurret(World world, Entity source) {
        super(world);
        this.setOwner(source);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(TARGET, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(DEFLECTION_STATE, (Object)false);
    }

    public void setDeflectable(boolean deflectable) {
        this.func_184212_Q().func_187227_b(DEFLECTION_STATE, (Object)deflectable);
    }

    public boolean isDeflectable() {
        return (Boolean)this.func_184212_Q().func_187225_a(DEFLECTION_STATE);
    }

    public void setOwner(@Nullable Entity entity) {
        this.func_184212_Q().func_187227_b(OWNER, (Object)(entity == null ? Optional.absent() : Optional.of((Object)entity.func_110124_au())));
    }

    @Nullable
    public UUID getOwnerUUID() {
        Optional uuid = (Optional)this.func_184212_Q().func_187225_a(OWNER);
        return uuid.isPresent() ? (UUID)uuid.get() : null;
    }

    @Nullable
    public Entity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null) {
            this.cachedOwner = null;
        } else if (this.cachedOwner == null || !this.cachedOwner.func_70089_S() || !this.cachedOwner.func_110124_au().equals(uuid)) {
            this.cachedOwner = null;
            for (Entity entity : this.func_130014_f_().func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0))) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                this.cachedOwner = entity;
                break;
            }
        }
        return this.cachedOwner;
    }

    public void setTarget(@Nullable Entity entity) {
        this.func_184212_Q().func_187227_b(TARGET, (Object)(entity == null ? Optional.absent() : Optional.of((Object)entity.func_110124_au())));
    }

    @Nullable
    public UUID getTargetUUID() {
        Optional uuid = (Optional)this.func_184212_Q().func_187225_a(TARGET);
        return uuid.isPresent() ? (UUID)uuid.get() : null;
    }

    @Nullable
    public Entity getTarget() {
        UUID uuid = this.getTargetUUID();
        if (uuid == null) {
            this.cachedTarget = null;
        } else if (this.cachedTarget == null || !this.cachedTarget.func_70089_S() || !this.cachedTarget.func_110124_au().equals(uuid)) {
            this.cachedTarget = null;
            for (Entity entity : this.func_130014_f_().func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0))) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                this.cachedTarget = entity;
                break;
            }
        }
        return this.cachedTarget;
    }

    public int getAttackDelay() {
        return this.attackDelay;
    }

    public void setAttackDelay(int delay) {
        this.attackDelay = delay;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("attackDelay", this.attackDelay);
        nbt.func_74757_a("deflectable", this.isDeflectable());
        if (this.getOwnerUUID() != null) {
            nbt.func_186854_a("owner", this.getOwnerUUID());
        }
        if (this.getTargetUUID() != null) {
            nbt.func_186854_a("target", this.getTargetUUID());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.attackDelay = nbt.func_74762_e("attackDelay");
        this.setDeflectable(nbt.func_74767_n("deflectable"));
        if (nbt.func_186855_b("owner")) {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.of((Object)nbt.func_186857_a("owner")));
        } else {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.absent());
        }
        if (nbt.func_186855_b("target")) {
            this.func_184212_Q().func_187227_b(TARGET, (Object)Optional.of((Object)nbt.func_186857_a("target")));
        } else {
            this.func_184212_Q().func_187227_b(TARGET, (Object)Optional.absent());
        }
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (!this.particlesSpawned) {
                this.particlesSpawned = true;
                for (i = 0; i < 6; ++i) {
                    this.spawnVolatileParticles();
                }
            }
            if (this.field_70170_p.field_73012_v.nextInt(6) == 0) {
                this.spawnFlameParticles();
            }
        }
        if (this.getTarget() == null) {
            AxisAlignedBB searchBB = this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0);
            List eligiblePlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, searchBB);
            EntityPlayer closest = null;
            for (EntityPlayer player : eligiblePlayers) {
                if (closest != null && !(closest.func_70032_d((Entity)this) > player.func_70032_d((Entity)this))) continue;
                closest = player;
            }
            if (closest != null) {
                this.setTarget((Entity)closest);
            }
        }
        if (this.getTarget() != null) {
            this.func_70625_a(this.getTarget(), 360.0f, 360.0f);
            ++this.attackTicks;
            if (this.attackTicks > this.attackDelay) {
                if (!this.field_70170_p.field_72995_K) {
                    if (!this.isObstructedByBoss()) {
                        Vec3d diff = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178788_d(new Vec3d(this.getTarget().func_174813_aQ().field_72340_a + (this.getTarget().func_174813_aQ().field_72336_d - this.getTarget().func_174813_aQ().field_72340_a) / 2.0, this.getTarget().func_174813_aQ().field_72338_b + (this.getTarget().func_174813_aQ().field_72337_e - this.getTarget().func_174813_aQ().field_72338_b) / 2.0, this.getTarget().func_174813_aQ().field_72339_c + (this.getTarget().func_174813_aQ().field_72334_f - this.getTarget().func_174813_aQ().field_72339_c) / 2.0)).func_72432_b();
                        EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, this.getOwner());
                        bullet.setDeflectable(this.isDeflectable());
                        bullet.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                        float speed = 0.5f;
                        bullet.func_70186_c(-diff.field_72450_a, -diff.field_72448_b, -diff.field_72449_c, speed, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)bullet);
                    }
                } else {
                    for (i = 0; i < 6; ++i) {
                        this.spawnVolatileParticles();
                    }
                }
                this.func_70106_y();
            }
        } else {
            this.attackTicks = 0;
        }
    }

    public boolean isObstructedByBoss() {
        Vec3d ray = this.func_70040_Z().func_72432_b();
        Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d nextPos = currentPos.func_72441_c(ray.field_72450_a * 64.0, ray.field_72448_b * 64.0, ray.field_72449_c * 64.0);
        Entity hitEntity = null;
        List hitEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
        double minDist = 0.0;
        for (int i = 0; i < hitEntities.size(); ++i) {
            double dst;
            Entity entity = (Entity)hitEntities.get(i);
            if (!entity.func_70067_L()) continue;
            float f = 0.525f;
            AxisAlignedBB entityBB = entity.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
            RayTraceResult result = entityBB.func_72327_a(currentPos, nextPos);
            if (result == null || !((dst = currentPos.func_72438_d(result.field_72307_f)) < minDist) && minDist != 0.0) continue;
            hitEntity = entity;
            minDist = dst;
        }
        return hitEntity != null && (hitEntity instanceof EntityFortressBoss || hitEntity == this.getOwner());
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFlameParticles() {
        BLParticles.GREEN_FLAME.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)0.2f, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 5.0f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 5.0f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 5.0f));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVolatileParticles() {
        double radius = 0.3f;
        double cx = this.field_70165_t;
        double cy = this.field_70163_u + 0.35;
        double cz = this.field_70161_v;
        for (int i = 0; i < 8; ++i) {
            double px = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double py = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double pz = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            Vec3d vec = new Vec3d(px, py, pz).func_178788_d(new Vec3d((double)0.35f, (double)0.35f, (double)0.35f)).func_72432_b();
            px = cx + vec.field_72450_a * (double)0.3f;
            py = cy + vec.field_72448_b * (double)0.3f;
            pz = cz + vec.field_72449_c * (double)0.3f;
            BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz);
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, up, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else {
            float friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float groundFriction = 0.16277136f / (friction * friction * friction);
            this.func_191958_b(strafe, up, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
            friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double dx = this.field_70165_t - this.field_70169_q;
        double dz = this.field_70161_v - this.field_70166_s;
        float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
        if (distanceMoved > 1.0f) {
            distanceMoved = 1.0f;
        }
        this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70652_k(Entity target) {
        return false;
    }
}

