/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.audio.IEntitySound;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityMusic;
import thebetweenlands.client.audio.GreeblingMusicSound;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.sound.BLSoundEvent;

public class EntityGreebling
extends EntityCreature
implements IEntityBL,
IEntityMusic {
    protected static final byte EVENT_START_DISAPPEARING = 40;
    protected static final byte EVENT_DISAPPEAR = 41;
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityGreebling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<EnumFacing> FACING = EntityDataManager.func_187226_a(EntityGreebling.class, (DataSerializer)DataSerializers.field_187202_l);
    public int disappearTimer = 0;

    public EntityGreebling(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 0.75f);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        if (livingdata == null) {
            livingdata = new GreeblingGroup();
        }
        if (livingdata instanceof GreeblingGroup) {
            GreeblingGroup group = (GreeblingGroup)livingdata;
            if (!(group.count <= 0 || group.hasType1 && group.hasType2)) {
                if (!group.hasType1) {
                    this.setType(0);
                } else {
                    this.setType(1);
                }
            } else {
                this.setType(this.field_70146_Z.nextInt(2));
                if (this.getType() == 0) {
                    group.hasType1 = true;
                } else {
                    group.hasType2 = true;
                }
            }
            ++group.count;
        } else {
            this.setType(this.field_70146_Z.nextInt(2));
        }
        this.field_70180_af.func_187227_b(FACING, (Object)EnumFacing.field_176754_o[this.field_70146_Z.nextInt(EnumFacing.field_176754_o.length)]);
        return livingdata;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(FACING, (Object)EnumFacing.NORTH);
    }

    public void setType(int type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70125_A = 0.0f;
        this.field_70127_C = 0.0f;
        this.field_70126_B = this.field_70177_z = ((EnumFacing)this.field_70180_af.func_187225_a(FACING)).func_185119_l();
        this.field_70760_ar = this.field_70761_aq = ((EnumFacing)this.field_70180_af.func_187225_a(FACING)).func_185119_l();
        if (this.disappearTimer > 0 && this.disappearTimer < 8) {
            ++this.disappearTimer;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.disappearTimer == 5) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)41);
            }
            if (this.disappearTimer >= 8) {
                this.func_70106_y();
            }
            List nearPlayers = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(4.5, 5.0, 4.5), e -> !e.field_71075_bZ.field_75098_d && !e.func_82150_aj());
            if (this.disappearTimer == 0 && !nearPlayers.isEmpty()) {
                ++this.disappearTimer;
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.GREEBLING_VANISH, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)40);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 40) {
            this.disappearTimer = 1;
        } else if (id == 41) {
            this.doLeafEffects();
        }
    }

    private void doLeafEffects() {
        if (this.field_70170_p.field_72995_K) {
            int leafCount = 40;
            float x = (float)this.field_70165_t;
            float y = (float)(this.field_70163_u + (double)1.3f);
            float z = (float)this.field_70161_v;
            while (leafCount-- > 0) {
                float dx = this.field_70170_p.field_73012_v.nextFloat() * 1.0f - 0.5f;
                float dy = this.field_70170_p.field_73012_v.nextFloat() * 1.0f - 0.1f;
                float dz = this.field_70170_p.field_73012_v.nextFloat() * 1.0f - 0.5f;
                float mag = 0.08f + this.field_70170_p.field_73012_v.nextFloat() * 0.07f;
                BLParticles.WEEDWOOD_LEAF.spawn(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag));
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("type", this.getType());
        compound.func_74768_a("facing", ((EnumFacing)this.field_70180_af.func_187225_a(FACING)).func_176736_b());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74762_e("type"));
        this.field_70180_af.func_187227_b(FACING, (Object)EnumFacing.func_176731_b((int)compound.func_74762_e("facing")));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_85033_bc() {
    }

    public void func_70108_f(Entity entityIn) {
    }

    @Override
    public BLSoundEvent getMusicFile(EntityPlayer listener) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IEntitySound getMusicSound(EntityPlayer listener) {
        return new GreeblingMusicSound(this.getType(), this, 0.75f);
    }

    @Override
    public double getMusicRange(EntityPlayer listener) {
        return 40.0;
    }

    @Override
    public boolean isMusicActive(EntityPlayer listener) {
        return this.func_70089_S();
    }

    @Override
    public int getMusicLayer(EntityPlayer listener) {
        return this.getType() == 0 ? 2 : 3;
    }

    @Override
    public boolean canInterruptOtherEntityMusic(EntityPlayer listener) {
        return false;
    }

    public void setFacing(EnumFacing facing) {
        this.field_70180_af.func_187227_b(FACING, (Object)facing);
    }

    private static final class GreeblingGroup
    implements IEntityLivingData {
        public boolean hasType1;
        public boolean hasType2;
        public int count;

        private GreeblingGroup() {
        }
    }
}

