/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.GreeblingFallSound;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityGreeblingVolarpadFloater
extends EntityThrowable {
    protected static final byte EVENT_START_DISAPPEARING = 40;
    protected static final byte EVENT_DISAPPEAR = 41;
    public int disappearTimer = 0;
    protected float prevFloatingRotationTicks = 0.0f;
    protected float floatingRotationTicks = 0.0f;

    public EntityGreeblingVolarpadFloater(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_184224_h(true);
    }

    public EntityGreeblingVolarpadFloater(World world, double x, double y, double z) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70107_b(x, y, z);
        this.func_184224_h(true);
        this.field_70159_w = 0.25 - world.field_73012_v.nextDouble() * 0.5;
        this.field_70179_y = 0.25 - world.field_73012_v.nextDouble() * 0.5;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.func_130014_f_().field_72995_K) {
            this.playFallingSound(this.func_130014_f_(), this.func_180425_c());
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.5;
        }
        this.prevFloatingRotationTicks = this.floatingRotationTicks;
        this.floatingRotationTicks += 5.0f;
        float wrap = MathHelper.func_76142_g((float)this.floatingRotationTicks) - this.floatingRotationTicks;
        this.floatingRotationTicks += wrap;
        this.prevFloatingRotationTicks += wrap;
        if (this.disappearTimer > 0 && this.disappearTimer < 8) {
            ++this.disappearTimer;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.disappearTimer == 5) {
                this.func_130014_f_().func_72960_a((Entity)this, (byte)41);
            }
            if (this.disappearTimer >= 8) {
                this.func_70106_y();
            }
            List nearPlayers = this.func_130014_f_().func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(4.5, 5.0, 4.5));
            if (!(this.disappearTimer != 0 || nearPlayers.isEmpty() && this.field_70173_aa <= 80)) {
                this.startVanishEvent();
            }
        }
    }

    public boolean isFloating() {
        return this.field_70181_x < 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void playFallingSound(World world, BlockPos pos) {
        GreeblingFallSound fall_sound = new GreeblingFallSound(this);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)fall_sound);
    }

    public void startVanishEvent() {
        ++this.disappearTimer;
        this.func_130014_f_().func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.GREEBLING_VANISH, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        this.func_130014_f_().func_72960_a((Entity)this, (byte)40);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 40) {
            this.disappearTimer = 1;
        } else if (id == 41) {
            this.doLeafEffects();
        }
    }

    private void doLeafEffects() {
        if (this.field_70170_p.field_72995_K) {
            int leafCount = 40;
            float x = (float)this.field_70165_t;
            float y = (float)this.field_70163_u + 0.5f;
            float z = (float)this.field_70161_v;
            while (leafCount-- > 0) {
                float dx = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.5f;
                float dy = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.1f;
                float dz = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.5f;
                float mag = 0.08f + this.func_130014_f_().field_73012_v.nextFloat() * 0.07f;
                BLParticles.WEEDWOOD_LEAF.spawn(this.func_130014_f_(), x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag));
            }
        }
    }

    public float smoothedAngle(float partialTicks) {
        return this.prevFloatingRotationTicks + (this.floatingRotationTicks - this.prevFloatingRotationTicks) * partialTicks;
    }

    protected float func_70185_h() {
        return 0.09f;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72313_a != null && result.field_72313_a == RayTraceResult.Type.BLOCK && !this.func_130014_f_().field_72995_K) {
            this.startVanishEvent();
        }
    }
}

