/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.api.entity.IEntityMusic;
import thebetweenlands.api.entity.IEntityPreventUnmount;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.api.entity.spawning.IWeightProvider;
import thebetweenlands.client.audio.EntitySound;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleGasCloud;
import thebetweenlands.common.entity.EntityTinyWormEggSac;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntityLargeSludgeWorm;
import thebetweenlands.common.entity.mobs.EntityLeech;
import thebetweenlands.common.entity.mobs.EntityMultipartDummy;
import thebetweenlands.common.entity.mobs.EntitySludgeJet;
import thebetweenlands.common.entity.mobs.EntityWallLivingRoot;
import thebetweenlands.common.entity.projectiles.EntitySludgeBall;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.sound.BLSoundEvent;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationSludgeWormDungeon;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.util.WeightedList;

public class EntitySludgeMenace
extends EntityWallLivingRoot
implements IEntityScreenShake,
IBLBoss,
IEntityMusic,
IEntityPreventUnmount {
    protected static final byte EVENT_START_ACTION = 90;
    protected static final byte EVENT_SLAM_HIT = 91;
    protected static final byte EVENT_ADD_LEECH_BULGE = 92;
    protected static final byte EVENT_ADD_EGG_SAC_BULGE = 93;
    protected static final byte EVENT_ADD_LARGE_SLUDGE_WORM_BULGE = 94;
    protected static final byte EVENT_ADD_SLUDGE_BALL_SERIES_BULGE = 95;
    protected static final byte EVENT_ADD_SLUDGE_BALL_BULGE = 96;
    public int renderedFrame = -1;
    protected static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntitySludgeMenace.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Integer> ACTION_STATE = EntityDataManager.func_187226_a(EntitySludgeMenace.class, (DataSerializer)DataSerializers.field_187192_b);
    private DummyPart[] dummies;
    private AxisAlignedBB renderBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected int actionTimer = 0;
    protected ActionState actionState = ActionState.IDLE;
    protected Vec3d actionTargetPos = null;
    protected int screenShakeTimer = 0;
    protected int hitCounter = 0;
    protected float damageCounter = 0.0f;
    protected List<Bulge> bulges = new ArrayList<Bulge>();
    protected int bulgeSpawnCooldown = 0;
    protected int spawnSeriesCount = 0;
    protected BulgeType spawnSeriesType = null;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private int deathTicks = 0;
    private Vec3d deathSpazzMotion = Vec3d.field_186680_a;
    @SideOnly(value=Side.CLIENT)
    private ISound livingSound;

    public EntitySludgeMenace(World world) {
        super(world);
        this.dummies = new DummyPart[this.func_70021_al().length];
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setPositionToAnchor(new BlockPos((Entity)this).func_177977_b(), EnumFacing.UP, EnumFacing.NORTH);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ACTION_STATE, (Object)ActionState.IDLE.ordinal());
        this.field_70180_af.func_187214_a(BOSSINFO_ID, (Object)Optional.absent());
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved(this, true){

            protected double func_111175_f() {
                return 8.0;
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null).func_190882_b(120));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISludgeMenaceArmAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAction(this, 10, 40));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(MAX_ARM_LENGTH).func_111128_a(9.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(600.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        this.deathTicks = nbt.func_74762_e("deathTicks");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("deathTicks", this.deathTicks);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    @Override
    protected float[][] getArmCrossSection() {
        float width = this.getFullArmWidth();
        return new float[][]{{-width, width}, {-width, -width}, {width, -width}, {width, width}};
    }

    @Override
    protected float getNodeSize(int node) {
        return 0.2f + (float)node / (float)this.getNumSegments() * 0.75f;
    }

    @Override
    protected int getNumSegments() {
        return 16;
    }

    @Override
    protected float getFullArmWidth() {
        return 0.55f;
    }

    @Override
    protected float getArmLengthSlack() {
        return 0.25f;
    }

    public void func_70642_aH() {
        if (this.field_70170_p.field_72995_K) {
            this.playLivingSoundLoop();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playLivingSoundLoop() {
        if (this.livingSound != null && !Minecraft.func_71410_x().func_147118_V().func_147692_c(this.livingSound)) {
            this.livingSound = null;
        }
        if (this.livingSound == null) {
            this.livingSound = new EntitySound<EntitySludgeMenace>(SoundRegistry.SLUDGE_MENACE_LIVING, SoundCategory.HOSTILE, this, e -> e.func_70089_S());
        }
        if (!Minecraft.func_71410_x().func_147118_V().func_147692_c(this.livingSound)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a(this.livingSound);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.SLUDGE_MENACE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SLUDGE_MENACE_DEATH;
    }

    @Override
    protected void func_184581_c(DamageSource source) {
        this.field_70757_a = -this.func_70627_aG();
        SoundEvent soundevent = this.func_184601_bQ(source);
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SLUDGE_MENACE;
    }

    @Override
    protected boolean isValidBlockForMovement(BlockPos pos, IBlockState state) {
        return state.func_185914_p() && state.func_185915_l() && state.func_185917_h() && state.func_185887_b(this.field_70170_p, pos) > 0.0f;
    }

    @Override
    protected boolean isTravelBlocked() {
        return this.func_70610_aX() || this.checkAnchorHere(3) == 0 || !BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSludgeWormDungeon.class, this.func_174813_aQ(), loc -> loc.isInside((Entity)this)).isEmpty();
    }

    @Override
    public float getArmSize(float partialTicks) {
        if (this.field_70173_aa < 10) {
            return (float)Math.pow(((float)this.field_70173_aa + partialTicks) / 10.0f, 6.0);
        }
        if (!this.func_70089_S()) {
            return (float)Math.max(0.0, 1.0 - Math.pow((float)this.deathTicks / 130.0f, 8.0));
        }
        return super.getArmSize(partialTicks);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BOSSINFO_ID, (Object)Optional.of((Object)this.bossInfo.func_186737_d()));
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.actionState = ActionState.values()[(Integer)this.field_70180_af.func_187225_a(ACTION_STATE)];
        }
        this.actionTimer = this.actionState != ActionState.IDLE ? ++this.actionTimer : 0;
        Vec3d armGravity = new Vec3d(0.0, 0.5, 0.0);
        if (this.actionState == ActionState.SLAM) {
            armGravity = Vec3d.field_186680_a;
        } else if (this.actionState == ActionState.POKE) {
            armGravity = new Vec3d(0.0, (double)0.8f, 0.0);
        } else if (this.actionState == ActionState.STUNNED) {
            float str = 0.2f;
            armGravity = new Vec3d((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * str), (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * str), (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * str));
        }
        int segmentIndex = 0;
        for (EntityWallLivingRoot.ArmSegment segment : this.armSegments) {
            segment.motion = armGravity.func_186678_a((double)(1.0f - (float)segmentIndex / (float)this.armSegments.size()));
            ++segmentIndex;
        }
        if (this.screenShakeTimer > 0) {
            --this.screenShakeTimer;
        }
        if (this.field_70173_aa < 10) {
            Vec3d straightPos = this.func_174791_d().func_178787_e(new Vec3d((double)this.getFacing().func_82601_c(), (double)this.getFacing().func_96559_d(), (double)this.getFacing().func_82599_e()).func_186678_a((double)this.getArmSize(1.0f) * (this.func_110148_a(MAX_ARM_LENGTH).func_111126_e() + 1.0)));
            this.rootTip.func_70107_b(straightPos.field_72450_a, straightPos.field_72448_b, straightPos.field_72449_c);
        }
        super.func_70071_h_();
        Entity[] parts = this.func_70021_al();
        this.updateBulges(parts);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < parts.length; ++i) {
                this.renderBoundingBox = i == 0 ? parts[i].func_174813_aQ() : this.renderBoundingBox.func_111270_a(parts[i].func_174813_aQ());
            }
            this.spawnTipParticles();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70173_aa % 12 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                double rangeXZ = 14.0;
                double rangeY = 13.0;
                List nearbyPlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(14.0, 14.0, 14.0));
                Iterator it = nearbyPlayers.iterator();
                while (it.hasNext()) {
                    EntityLivingBase living = (EntityLivingBase)it.next();
                    if (!(living.func_70011_f(this.field_70165_t, living.field_70163_u, this.field_70161_v) > 14.0) && !(Math.abs(living.field_70163_u - this.field_70163_u) > 13.0)) continue;
                    it.remove();
                }
                if (nearbyPlayers.isEmpty()) {
                    this.func_70691_i(1.0f);
                }
            }
            for (int i = 0; i < this.dummies.length; ++i) {
                DummyPart dummy = this.dummies[i];
                if (dummy == null || !dummy.func_70089_S()) {
                    Entity multipart = parts[i];
                    if (!(multipart instanceof MultiPartEntityPart)) continue;
                    this.dummies[i] = dummy = new DummyPart(this.field_70170_p, (MultiPartEntityPart)multipart);
                    this.field_70170_p.func_72838_d((Entity)dummy);
                    continue;
                }
                dummy.updatePositioning();
            }
        }
    }

    protected void updateBulges(Entity[] parts) {
        Iterator<Bulge> it = this.bulges.iterator();
        while (it.hasNext()) {
            EntityLivingBase target;
            Object mob;
            Bulge bulge = it.next();
            bulge.prevPosition = bulge.position;
            bulge.prevSize = bulge.size;
            bulge.position += bulge.type.speed;
            if (bulge.position >= 0.95f) {
                bulge.size -= 0.1f;
                if (bulge.size < 0.0f) {
                    bulge.size = 0.0f;
                }
            }
            if (!(bulge.position >= 1.0f)) continue;
            bulge.position = 1.0f;
            it.remove();
            if (this.field_70170_p.field_72995_K || parts.length < 2) continue;
            switch (bulge.type) {
                default: {
                    mob = new EntityLeech(this.field_70170_p);
                    break;
                }
                case EGG_SAC: {
                    mob = new EntityTinyWormEggSac(this.field_70170_p);
                    break;
                }
                case LARGE_SLUDGE_WORM: {
                    mob = new EntityLargeSludgeWorm(this.field_70170_p);
                    break;
                }
                case SLUDGE_BALL: 
                case SLUDGE_BALL_SERIES: {
                    mob = new EntitySludgeBall(this.field_70170_p, (EntityLivingBase)this, false);
                }
            }
            Vec3d dir = parts[parts.length - 1].func_174791_d().func_178788_d(parts[parts.length - 2].func_174791_d()).func_72432_b();
            float spawnOffset = -0.5f;
            mob.func_70107_b(this.rootTip.field_70165_t + dir.field_72450_a * (double)spawnOffset, this.rootTip.field_70163_u + dir.field_72448_b * (double)spawnOffset, this.rootTip.field_70161_v + dir.field_72449_c * (double)spawnOffset);
            float speed = 0.85f;
            ((Entity)mob).field_70159_w = dir.field_72450_a * (double)speed;
            ((Entity)mob).field_70181_x = dir.field_72448_b * (double)speed;
            ((Entity)mob).field_70179_y = dir.field_72449_c * (double)speed;
            if (mob instanceof EntityLeech && (target = this.func_70638_az()) != null) {
                mob.func_70624_b(target);
            }
            this.field_70170_p.func_72838_d((Entity)mob);
            this.func_184185_a(SoundRegistry.SLUDGE_MENACE_SPIT, 1.0f, 1.0f);
        }
    }

    protected void func_70609_aI() {
        this.bossInfo.func_186735_a(0.0f);
        ++this.deathTicks;
        if (!this.field_70170_p.field_72995_K) {
            int xp;
            int dropXP;
            if (this.actionState != ActionState.DEATH) {
                this.startAction(ActionState.DEATH);
            }
            if (this.deathTicks > 100 && this.deathTicks % 5 == 0) {
                for (xp = 800; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks > 130) {
                for (xp = 3000; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
                List<LocationStorage> locations = LocationStorage.getLocations(this.field_70170_p, this.func_174791_d().func_72441_c(0.0, 2.0, 0.0));
                for (LocationStorage location : locations) {
                    if (location.getType() != EnumLocationType.SLUDGE_WORM_DUNGEON) continue;
                    if (location.getGuard() != null) {
                        location.getGuard().clear(this.field_70170_p);
                        location.setDirty(true);
                    }
                    if (!(location instanceof LocationSludgeWormDungeon)) continue;
                    ((LocationSludgeWormDungeon)location).setDefeated(true);
                }
                this.func_70106_y();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnTipParticles() {
        Entity[] parts = this.func_70021_al();
        if (parts.length > 2) {
            Entity lastPart = parts[parts.length - 1];
            Entity secondLastPart = parts[parts.length - 2];
            Vec3d dir = lastPart.func_174791_d().func_178788_d(secondLastPart.func_174791_d()).func_72432_b().func_72441_c((double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.5f), 0.0, (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.5f)).func_186678_a(0.1);
            double x = lastPart.field_70165_t;
            double y = lastPart.field_70163_u + (double)(lastPart.field_70131_O / 2.0f);
            double z = lastPart.field_70161_v;
            double mx = dir.field_72450_a;
            double my = dir.field_72448_b;
            double mz = dir.field_72449_c;
            int[] color = new int[]{100, 70, 0, 255};
            ParticleGasCloud hazeParticle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(3.5f));
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_HEAT_HAZE, hazeParticle);
            ParticleGasCloud particle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(2.5f));
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_TEXTURED, particle);
        }
    }

    @Override
    public boolean func_70652_k(Entity target) {
        boolean damaged = super.func_70652_k(target);
        this.func_184185_a(SoundRegistry.SLUDGE_MENACE_ATTACK, 1.0f, 1.0f);
        if (this.actionState == ActionState.POKE) {
            if (target == this.func_70638_az() && this.actionTimer >= 40) {
                DummyPart endDummy = this.dummies[this.dummies.length - 1];
                if (endDummy != null && endDummy.func_70089_S()) {
                    List passengers = endDummy.func_184188_bt();
                    if (!passengers.isEmpty() && passengers.get(0) != this.func_70638_az()) {
                        endDummy.func_184226_ay();
                    }
                    if (target.func_184187_bx() != endDummy) {
                        target.func_184210_p();
                        target.func_184205_a((Entity)endDummy, true);
                    }
                }
                if (damaged) {
                    this.func_70691_i((float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 1.5f);
                }
            }
        } else if (this.actionState == ActionState.SWING) {
            if (!damaged && target instanceof EntityLivingBase && ((EntityLivingBase)target).func_184585_cz() && this.field_70170_p.field_73012_v.nextInt(3) == 0) {
                this.startAction(ActionState.STUNNED);
            } else if (damaged && target instanceof EntityLivingBase) {
                float dx = (float)(this.rootTip.field_70165_t - this.field_70165_t);
                float dz = (float)(this.rootTip.field_70161_v - this.field_70161_v);
                float len = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
                ((EntityLivingBase)target).func_70653_a((Entity)this, 1.75f, (double)(dz /= len), (double)(-(dx /= len)));
            }
        }
        return damaged;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76352_a() || source.func_94541_c() || source.func_76347_k()) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if (!this.field_70170_p.field_72995_K && this.actionState == ActionState.POKE) {
                DummyPart endDummy;
                this.damageCounter += amount;
                ++this.hitCounter;
                if ((this.damageCounter >= 15.0f || this.hitCounter >= 6) && (endDummy = this.dummies[this.dummies.length - 1]) != null && !endDummy.func_184188_bt().isEmpty()) {
                    this.startAction(ActionState.IDLE);
                    endDummy.func_184226_ay();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected Vec3d updateTargetTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        switch (this.actionState) {
            default: {
                return this.updateDeathTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
            }
            case IDLE: {
                return this.updateIdleTargetTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
            }
            case SLAM: {
                return this.updateSlamTargetTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
            }
            case POKE: {
                return this.updatePokeTargetTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
            }
            case SWING: {
                return this.updateSwingTargetTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
            }
            case SPIT_MOBS: {
                return this.updateSpitMobsTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
            }
            case STUNNED: 
        }
        return this.updateStunnedTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
    }

    protected Vec3d updateDeathTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            float vel = 2.0f + this.field_70170_p.field_73012_v.nextFloat() * 4.0f;
            this.deathSpazzMotion = new Vec3d((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * vel), (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * vel + 1.25f), (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * vel));
        }
        return this.rootTip.func_174791_d().func_178787_e(this.deathSpazzMotion);
    }

    protected Vec3d updateStunnedTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        if (this.actionTimer >= 150) {
            this.actionState = ActionState.IDLE;
        }
        Vec3d moveDir = this.func_174791_d().func_178788_d(this.rootTip.func_174791_d()).func_72432_b().func_186678_a((double)0.02f);
        float str = 0.2f;
        return this.rootTip.func_174791_d().func_72441_c((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * str) + moveDir.field_72450_a, (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * str + 0.01f), (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * str) + moveDir.field_72449_c);
    }

    protected Vec3d updateSpitMobsTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        if (this.actionTimer < 200 && this.bulgeSpawnCooldown-- <= 0) {
            if (this.spawnSeriesType == null) {
                HashSet<BulgeType> availableTypes = new HashSet<BulgeType>();
                AxisAlignedBB checkAabb = this.func_174813_aQ().func_72314_b(12.0, 1.0, 12.0).func_72321_a(0.0, 11.0, 0.0);
                TObjectIntHashMap bulgeCounts = new TObjectIntHashMap();
                for (Bulge bulge : this.bulges) {
                    bulgeCounts.increment((Object)bulge.type);
                }
                for (BulgeType bulgeType : BulgeType.values()) {
                    if (this.field_70170_p.func_72872_a(bulgeType.entityType, checkAabb).size() + bulgeCounts.get((Object)bulgeType) >= bulgeType.maxEntityCount || bulgeType.spawnSeries > 1 && !this.bulges.isEmpty()) continue;
                    availableTypes.add(bulgeType);
                }
                if (!availableTypes.isEmpty()) {
                    WeightedList list = new WeightedList();
                    list.addAll(availableTypes);
                    list.recalculateWeight();
                    BulgeType bulgeType = (BulgeType)list.getRandomItem(this.field_70146_Z);
                    this.addBulge(bulgeType);
                    if (bulgeType.spawnSeries > 1) {
                        this.spawnSeriesCount = bulgeType.spawnSeries;
                        this.spawnSeriesType = bulgeType;
                    }
                }
            } else {
                this.addBulge(this.spawnSeriesType);
                --this.spawnSeriesCount;
                if (this.spawnSeriesCount <= 0) {
                    this.spawnSeriesCount = 0;
                    this.spawnSeriesType = null;
                }
            }
            this.bulgeSpawnCooldown = this.spawnSeriesType == null ? 15 + this.field_70170_p.field_73012_v.nextInt(15) : 4;
        }
        if (this.actionTimer >= 200 && this.bulges.isEmpty()) {
            this.startAction(ActionState.IDLE);
        }
        float furthestPos = 0.0f;
        Bulge nextBulge = null;
        for (Bulge bulge : this.bulges) {
            if (!(bulge.position > furthestPos)) continue;
            furthestPos = bulge.position;
            nextBulge = bulge;
        }
        ++this.armMovementTicks;
        Vec3d targetTipPos = armStartWorld.func_178787_e(dirFwd.func_186678_a((double)(maxArmLength + 1.0f)));
        EntityLivingBase target = this.func_70638_az();
        if (nextBulge != null && nextBulge.type == BulgeType.LARGE_SLUDGE_WORM) {
            float rx = (float)Math.cos((float)this.field_70173_aa * 0.05f);
            float rz = (float)Math.sin((float)this.field_70173_aa * 0.05f);
            targetTipPos = armStartWorld.func_178787_e(dirFwd.func_186678_a((double)(maxArmLength / 2.0f))).func_72441_c((double)(rx * 2.0f), 0.0, (double)(rz * 2.0f));
        } else if (nextBulge != null && nextBulge.type == BulgeType.LEECH && target != null) {
            Vec3d bendPos = armStartWorld.func_178787_e(dirFwd.func_186678_a((double)maxArmLength));
            Vec3d targetDir = target.func_174791_d().func_178788_d(bendPos).func_72432_b().func_186678_a(5.0);
            targetTipPos = bendPos.func_178787_e(targetDir);
        } else {
            float idleX = MathHelper.func_76134_b((float)((float)this.armMovementTicks / 9.0f)) * 0.75f;
            float idleY = MathHelper.func_76126_a((float)((float)this.armMovementTicks / 7.0f)) * 0.75f;
            float idleZ = (MathHelper.func_76134_b((float)((float)this.armMovementTicks / 15.0f)) + 1.0f) * 0.25f;
            float forwardPos = (float)dirFwd.func_72430_b(targetTipPos.func_178788_d(armStartWorld));
            float offsetZ = 0.0f;
            if (forwardPos < 1.0f) {
                offsetZ = 1.0f - forwardPos;
            }
            targetTipPos = targetTipPos.func_178787_e(dirUp.func_186678_a((double)idleY)).func_178787_e(dirFwd.func_72431_c(dirUp).func_186678_a((double)idleX)).func_178787_e(dirFwd.func_186678_a((double)(offsetZ - idleZ)));
        }
        Vec3d tipPos = this.rootTip.func_174791_d();
        Vec3d diff = targetTipPos.func_178788_d(tipPos);
        targetTipPos = tipPos.func_178787_e(diff.func_72432_b().func_186678_a(Math.min(diff.func_72433_c(), 0.5)));
        return targetTipPos;
    }

    protected Vec3d updateSwingTargetTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        float prevDrive = (float)(this.actionTimer - 1) * 0.07f * (1.0f + (float)(this.actionTimer - 1) / 300.0f * 2.0f);
        float drive = (float)this.actionTimer * 0.07f * (1.0f + (float)this.actionTimer / 300.0f * 2.0f);
        float prevDriveMod = prevDrive % ((float)Math.PI * 2);
        float driveMod = drive % ((float)Math.PI * 2);
        if (prevDriveMod <= 1.0f && driveMod > 1.0f) {
            this.func_184185_a(SoundRegistry.SLUDGE_MENACE_ATTACK, 1.0f, 1.0f);
        }
        if (this.actionTimer >= 300) {
            this.startAction(ActionState.IDLE);
        }
        float swingLength = maxArmLength + 0.2f;
        Vec3d targetTipPos = armStartWorld.func_72441_c(Math.cos(drive) * (double)swingLength, (double)1.8f + (Math.sin(drive * 0.28f) + 1.0) * (double)2.2f, Math.sin(drive) * (double)swingLength);
        Vec3d tipPos = this.rootTip.func_174791_d();
        Vec3d diff = targetTipPos.func_178788_d(tipPos);
        targetTipPos = tipPos.func_178787_e(diff.func_72432_b().func_186678_a(Math.min(diff.func_72433_c(), 0.5 + (double)((float)this.actionTimer / 300.0f) * 2.5)));
        return targetTipPos;
    }

    protected Vec3d updatePokeTargetTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        boolean isSucking = false;
        DummyPart endDummy = this.dummies[this.dummies.length - 1];
        if (endDummy != null) {
            List passengers = endDummy.func_184188_bt();
            if (passengers.isEmpty() || passengers.get(0) != this.func_70638_az()) {
                if (this.actionTimer >= 70) {
                    this.startAction(ActionState.IDLE);
                }
            } else if (!passengers.isEmpty() && passengers.get(0) == this.func_70638_az()) {
                isSucking = true;
            }
        } else if (this.actionTimer >= 70) {
            this.startAction(ActionState.IDLE);
        }
        if (isSucking) {
            if (endDummy != null && endDummy.func_184188_bt().get(0) == this.func_70638_az() && this.func_70638_az().func_110143_aJ() <= 4.0f) {
                this.startAction(ActionState.IDLE);
                endDummy.func_184226_ay();
            }
            ++this.armMovementTicks;
            float idleX = MathHelper.func_76134_b((float)((float)this.armMovementTicks / 4.0f)) * 0.75f;
            float idleY = MathHelper.func_76126_a((float)((float)this.armMovementTicks / 3.0f)) * 0.75f;
            float idleZ = (MathHelper.func_76134_b((float)((float)this.armMovementTicks / 8.0f)) + 1.0f) * 0.25f;
            return this.actionTargetPos.func_72441_c((double)idleX, (double)(idleY + 1.5f), (double)idleZ);
        }
        this.damageCounter = 0.0f;
        this.hitCounter = 0;
        float drive = this.actionTimer;
        if (drive < 43.0f && this.func_70638_az() != null) {
            this.actionTargetPos = this.func_70638_az().func_174791_d();
        }
        if (drive < 40.0f) {
            Vec3d bendPos = armStartWorld.func_178787_e(dirFwd.func_186678_a((double)maxArmLength));
            Vec3d targetDir = new Vec3d(3.0, 0.0, 0.0);
            if (this.func_70638_az() != null) {
                targetDir = this.func_70638_az().func_174791_d().func_178788_d(bendPos).func_72432_b().func_186678_a(5.0);
            }
            return bendPos.func_178787_e(targetDir);
        }
        if (drive < 48.0f) {
            float speed = (drive - 40.0f) / 8.0f * 4.0f;
            Vec3d targetTipPos = armStartWorld.func_178787_e(dirFwd.func_186678_a((double)maxArmLength));
            if (this.actionTargetPos != null) {
                targetTipPos = this.actionTargetPos.func_72441_c(0.0, this.func_70638_az() != null ? (double)(this.func_70638_az().field_70131_O / 2.0f) : 0.0, 0.0);
            }
            Vec3d tipPos = this.rootTip.func_174791_d();
            Vec3d tipDiff = targetTipPos.func_178788_d(tipPos);
            targetTipPos = tipPos.func_178787_e(tipDiff.func_72432_b().func_186678_a(Math.min(tipDiff.func_72433_c(), (double)speed)));
            return targetTipPos;
        }
        return this.rootTip.func_174791_d();
    }

    protected Vec3d updateSlamTargetTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        float rot;
        float drive = this.actionTimer;
        if (drive < 58.0f && this.func_70638_az() != null) {
            this.actionTargetPos = this.func_70638_az().func_174791_d();
        }
        if (drive < 20.0f) {
            rot = 1.5707964f;
        } else if (drive < 60.0f) {
            float slap = (drive - 20.0f) / 40.0f;
            float s = 6.0f;
            float a = 6.0f;
            rot = (float)Math.pow(slap, a + slap * s) * 1.5707964f + 1.5707964f;
        } else {
            rot = (float)Math.PI;
        }
        Vec3d targetDir = new Vec3d((double)(maxArmLength + 1.0f), 0.0, 0.0);
        if (this.actionTargetPos != null) {
            targetDir = armStartWorld.func_178788_d(this.actionTargetPos).func_72432_b().func_186678_a((double)(maxArmLength + 1.0f));
        }
        if (this.actionTimer >= 90) {
            this.startAction(ActionState.IDLE);
        }
        if (!this.field_70170_p.field_72995_K && this.actionTimer == 63) {
            this.startSlamHit();
            for (Entity part : this.func_70021_al()) {
                BlockPos pos = new BlockPos(part).func_177977_b();
                BlockPos spawnPos = null;
                if (!this.field_70170_p.func_175623_d(pos)) {
                    spawnPos = pos;
                } else {
                    for (int i = 0; i < 5; ++i) {
                        if (!this.field_70170_p.func_175623_d(pos = pos.func_177984_a())) continue;
                        spawnPos = pos.func_177977_b();
                        break;
                    }
                }
                if (spawnPos == null) continue;
                EntitySludgeJet jet = new EntitySludgeJet(this.field_70170_p);
                jet.func_70012_b(part.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, (double)spawnPos.func_177956_o() + 0.5, part.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)jet);
            }
        }
        Vec3d targetTipPos = armStartWorld.func_72441_c(targetDir.field_72450_a * Math.cos(rot), Math.sin(rot) * targetDir.func_72433_c(), targetDir.field_72449_c * Math.cos(rot));
        Vec3d tipPos = this.rootTip.func_174791_d();
        Vec3d diff = targetTipPos.func_178788_d(tipPos);
        targetTipPos = tipPos.func_178787_e(diff.func_72432_b().func_186678_a(Math.min(diff.func_72433_c(), 0.5 + (double)((float)this.actionTimer / 90.0f) * 5.0)));
        return targetTipPos;
    }

    protected Vec3d updateIdleTargetTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        float flailingStrength = this.field_82175_bq ? 1.0f - this.field_70733_aJ : (this.field_70737_aN > 0 ? (float)this.field_70737_aN / (float)this.field_70738_aO * 0.5f : 0.0f);
        this.armMovementTicks += 1 + (int)(flailingStrength * 10.0f);
        float idleX = MathHelper.func_76134_b((float)((float)this.armMovementTicks / 9.0f)) * 1.25f;
        float idleY = MathHelper.func_76126_a((float)((float)this.armMovementTicks / 7.0f)) * 0.25f;
        float idleZ = (MathHelper.func_76134_b((float)((float)this.armMovementTicks / 15.0f)) + 1.0f) * 0.75f;
        Vec3d targetTipPos = armStartWorld.func_178787_e(dirFwd.func_186678_a((double)maxArmLength));
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            targetTipPos = target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0);
        }
        float forwardPos = (float)dirFwd.func_72430_b(targetTipPos.func_178788_d(armStartWorld));
        float offsetZ = 0.0f;
        if (forwardPos < 1.0f) {
            offsetZ = 1.0f - forwardPos;
        }
        targetTipPos = targetTipPos.func_178787_e(dirUp.func_186678_a((double)idleY)).func_178787_e(dirFwd.func_72431_c(dirUp).func_186678_a((double)idleX)).func_178787_e(dirFwd.func_186678_a((double)(offsetZ - idleZ)));
        Vec3d tipPos = this.rootTip.func_174791_d();
        Vec3d tipDiff = targetTipPos.func_178788_d(tipPos);
        targetTipPos = tipPos.func_178787_e(tipDiff.func_72432_b().func_186678_a(Math.min(tipDiff.func_72433_c(), 0.125 + (double)flailingStrength * 0.8)));
        return targetTipPos;
    }

    public AxisAlignedBB func_184177_bl() {
        return this.renderBoundingBox;
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.screenShakeTimer > 0) {
            float dstMul = MathHelper.func_76131_a((float)(1.0f - this.func_70032_d(viewer) / 24.0f), (float)0.0f, (float)1.0f);
            return dstMul * ((float)this.screenShakeTimer - partialTicks) / 10.0f * 0.2f;
        }
        return 0.0f;
    }

    @Override
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        BulgeType bulgeType = BulgeType.byEventId(id);
        if (bulgeType != null) {
            this.addBulge(bulgeType);
        } else if (id == 90) {
            this.startAction(ActionState.values()[(Integer)this.field_70180_af.func_187225_a(ACTION_STATE)]);
        } else if (id == 91) {
            this.startSlamHit();
        }
    }

    protected void startAction(ActionState action) {
        this.actionState = action;
        this.actionTimer = 0;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)90);
            this.field_70180_af.func_187227_b(ACTION_STATE, (Object)this.actionState.ordinal());
        }
    }

    protected void startSlamHit() {
        this.screenShakeTimer = 10;
        this.func_184185_a(SoundRegistry.WALL_SLAM, 2.0f, 1.0f);
        this.func_184185_a(SoundRegistry.SLUDGE_MENACE_ATTACK, 1.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)91);
        }
    }

    protected void addBulge(BulgeType type) {
        Bulge bulge = new Bulge();
        bulge.size = bulge.renderSize = type.size;
        bulge.type = type;
        this.bulges.add(bulge);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, type.eventId);
        }
    }

    @Nullable
    public List<Bulge> getBulges(float partialTicks) {
        for (Bulge bulge : this.bulges) {
            bulge.renderPosition = bulge.prevPosition + (bulge.position - bulge.prevPosition) * partialTicks;
            bulge.renderSize = bulge.prevSize + (bulge.size - bulge.prevSize) * partialTicks;
        }
        return this.bulges;
    }

    @Override
    public UUID getBossInfoUuid() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(BOSSINFO_ID)).or((Object)new UUID(0L, 0L));
    }

    @Override
    public BLSoundEvent getMusicFile(EntityPlayer listener) {
        return SoundRegistry.PIT_OF_DECAY_LOOP;
    }

    @Override
    public double getMusicRange(EntityPlayer listener) {
        return 32.0;
    }

    @Override
    public boolean isMusicActive(EntityPlayer listener) {
        return this.func_70089_S();
    }

    @Override
    public int getMusicLayer(EntityPlayer listener) {
        return 1;
    }

    @Override
    public boolean isUnmountBlocked(EntityPlayer rider) {
        List passengers;
        DummyPart endDummy;
        return !this.field_70170_p.field_72995_K && this.actionState == ActionState.POKE && (endDummy = this.dummies[this.dummies.length - 1]) != null && endDummy.func_70089_S() && !(passengers = endDummy.func_184188_bt()).isEmpty() && passengers.get(0) == rider;
    }

    protected static class AIAction
    extends EntityAIBase {
        protected final EntitySludgeMenace menace;
        protected int cooldown;
        protected int minCooldown;
        protected int maxCooldown;

        protected AIAction(EntitySludgeMenace entity, int minCooldown, int maxCooldown) {
            this.menace = entity;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.func_75251_c();
        }

        public boolean func_75250_a() {
            if (this.menace.actionState == ActionState.IDLE && this.menace.func_70638_az() != null && this.menace.func_70089_S()) {
                return this.cooldown-- <= 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            int nr = this.menace.field_70146_Z.nextInt(100);
            if (nr <= 17) {
                this.menace.startAction(ActionState.SPIT_MOBS);
            } else if (nr <= 34) {
                this.menace.startAction(ActionState.SWING);
            } else if (nr <= 67) {
                this.menace.startAction(ActionState.POKE);
            } else {
                this.menace.startAction(ActionState.SLAM);
            }
        }

        public void func_75251_c() {
            this.cooldown = this.minCooldown + this.menace.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown);
        }
    }

    protected static class AISludgeMenaceArmAttack
    extends EntityWallLivingRoot.AIArmAttack {
        protected final EntitySludgeMenace menace;

        protected AISludgeMenaceArmAttack(EntitySludgeMenace entity) {
            super(entity);
            this.menace = entity;
        }

        @Override
        public void func_75246_d() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (this.attackTicks > 0) {
                --this.attackTicks;
            } else if (target != null && this.menace.func_70089_S()) {
                AxisAlignedBB targetAabb = target.func_174813_aQ();
                boolean attacked = false;
                HashSet<EntityLivingBase> attackedSet = new HashSet<EntityLivingBase>();
                for (Entity part : this.menace.func_70021_al()) {
                    if (!attackedSet.contains(target) && targetAabb.func_72326_a(part.func_174813_aQ())) {
                        attacked = true;
                        if (this.entity.func_70652_k((Entity)target)) {
                            attackedSet.add(target);
                        }
                    }
                    List collidingList = this.menace.func_82194_d().func_175647_a(EntityLivingBase.class, part.func_174813_aQ(), arg_0 -> AISludgeMenaceArmAttack.lambda$updateTask$0((Entity)target, attackedSet, arg_0));
                    for (EntityLivingBase colliding : collidingList) {
                        attacked = true;
                        if (!this.entity.func_70652_k((Entity)colliding)) continue;
                        attackedSet.add(colliding);
                    }
                }
                if (attacked) {
                    this.entity.func_184609_a(EnumHand.MAIN_HAND);
                    this.attackTicks = 20;
                }
            }
        }

        private static /* synthetic */ boolean lambda$updateTask$0(Entity target, Set attackedSet, EntityLivingBase e) {
            return !(e instanceof IMob) && e != target && !attackedSet.contains(e);
        }
    }

    public static class DummyPart
    extends EntityMultipartDummy
    implements IEntityPreventUnmount {
        public DummyPart(World world) {
            super(world);
        }

        public DummyPart(World world, MultiPartEntityPart parent) {
            super(world, parent);
        }

        public double func_70042_X() {
            return -0.4;
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public String func_70005_c_() {
            return this.getParent() != null ? this.getParent().func_70005_c_() : super.func_70005_c_();
        }

        @Override
        public boolean isUnmountBlocked(EntityPlayer rider) {
            return this.getParent() != null && this.getParent().field_70259_a instanceof IEntityPreventUnmount ? ((IEntityPreventUnmount)this.getParent().field_70259_a).isUnmountBlocked(rider) : false;
        }
    }

    public static class Bulge {
        public float renderPosition;
        public float renderSize;
        public BulgeType type;
        protected float prevSize;
        protected float size;
        protected float prevPosition;
        protected float position;
    }

    public static enum BulgeType implements IWeightProvider
    {
        LEECH(EntityLeech.class, 2, 25, 1, 0.01f, 0.8f, 1.0f, 92),
        EGG_SAC(EntityTinyWormEggSac.class, 3, 15, 1, 0.01f, 0.9f, 1.0f, 93),
        LARGE_SLUDGE_WORM(EntityLargeSludgeWorm.class, 1, 10, 1, 0.01f, 1.2f, 1.6f, 94),
        SLUDGE_BALL_SERIES(EntitySludgeBall.class, 6, 50, 12, 0.07f, 0.7f, 1.0f, 95),
        SLUDGE_BALL(EntitySludgeBall.class, 6, 30, 1, 0.01f, 0.7f, 1.0f, 96);

        public final Class<? extends Entity> entityType;
        public final int maxEntityCount;
        public final short spawnWeight;
        public final int spawnSeries;
        public final float speed;
        public final float size;
        public final float length;
        public final byte eventId;

        private BulgeType(Class<? extends Entity> entityType, int maxEntityCount, int spawnWeight, int spawnSeries, float speed, float size, float length, byte eventId) {
            this.entityType = entityType;
            this.maxEntityCount = maxEntityCount;
            this.spawnWeight = (short)spawnWeight;
            this.spawnSeries = spawnSeries;
            this.speed = speed;
            this.size = size;
            this.length = length;
            this.eventId = eventId;
        }

        public static BulgeType byEventId(byte eventId) {
            for (BulgeType type : BulgeType.values()) {
                if (type.eventId != eventId) continue;
                return type;
            }
            return null;
        }

        @Override
        public short getWeight() {
            return this.spawnWeight;
        }
    }

    public static enum ActionState {
        IDLE,
        SLAM,
        POKE,
        SWING,
        SPIT_MOBS,
        STUNNED,
        DEATH;

    }
}

