/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.entity.EntityTinyWormEggSac;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntitySludgeWorm
extends EntityMob
implements IEntityMultiPart,
IMob,
IEntityBL {
    public MultiPartEntityPart[] parts;
    public boolean debugHitboxes = false;
    Random field_70146_Z = new Random();
    private AxisAlignedBB renderBoundingBox;
    private int wallInvulnerabilityTicks = 40;
    private boolean doSpawningAnimation = true;

    public EntitySludgeWorm(World world) {
        super(world);
        this.func_70105_a(0.4375f, 0.3125f);
        this.func_184644_a(PathNodeType.WATER, -10.0f);
        this.field_70178_ae = true;
        this.parts = new MultiPartEntityPart[]{new MultiPartEntityPart((IEntityMultiPart)this, "part1", 0.4375f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part2", 0.3125f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part3", 0.3125f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part4", 0.3125f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part5", 0.3125f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part6", 0.3125f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part7", 0.3125f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part8", 0.3125f, 0.3125f), new MultiPartEntityPart((IEntityMultiPart)this, "part9", 0.3125f, 0.3125f)};
        this.renderBoundingBox = this.func_174813_aQ();
    }

    public EntitySludgeWorm(World world, boolean doSpawningAnimation) {
        this(world);
        this.doSpawningAnimation = doSpawningAnimation;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 1));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, entity -> !(entity instanceof IMob)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.21);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.25);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_191989_p(0.2f);
        this.setHitBoxes();
    }

    protected float getHeadMotionYMultiplier() {
        return this.doSpawningAnimation && this.field_70173_aa < 20 ? 0.65f : 1.0f;
    }

    protected float getTailMotionYMultiplier() {
        return this.doSpawningAnimation && this.field_70173_aa < 20 ? 0.0f : 1.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
            this.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z);
        }
        if (this.wallInvulnerabilityTicks > 0) {
            --this.wallInvulnerabilityTicks;
        }
        this.field_70181_x *= (double)this.getHeadMotionYMultiplier();
        this.renderBoundingBox = this.func_174813_aQ();
        for (MultiPartEntityPart part : this.parts) {
            this.renderBoundingBox = this.renderBoundingBox.func_111270_a(part.func_174813_aQ());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 1 + world.field_73012_v.nextInt(4); ++count) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.0 + rand.nextDouble() * 0.3 - rand.nextDouble() * 0.3;
            double offSetZ = Math.cos(a) * 0.0 + rand.nextDouble() * 0.3 - rand.nextDouble() * 0.3;
            BLParticles.TAR_BEAST_DRIP.spawn(world, x + offSetX, y, z + offSetZ).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        }
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float dmg) {
        this.damageWorm(source, dmg * 0.75f);
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i || source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            this.damageWorm(source, amount);
        } else {
            if (source == DamageSource.field_76368_d && this.wallInvulnerabilityTicks > 0) {
                return false;
            }
            this.damageWorm(source, amount);
        }
        return true;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entity) {
        return !IEntityBL.class.isAssignableFrom(entity) && EntityTinyWormEggSac.class != entity;
    }

    protected boolean damageWorm(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public Entity[] func_70021_al() {
        return this.parts;
    }

    private void setHitBoxes() {
        if (this.field_70173_aa == 1) {
            for (int i = 1; i < this.parts.length; ++i) {
                this.parts[i].func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            }
        }
        this.parts[0].func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
        for (MultiPartEntityPart part : this.parts) {
            part.field_70126_B = part.field_70177_z;
            part.field_70127_C = part.field_70125_A;
            if (part == this.parts[0]) continue;
            part.field_70169_q = part.field_70142_S = part.field_70165_t;
            part.field_70167_r = part.field_70137_T = part.field_70163_u;
            part.field_70166_s = part.field_70136_U = part.field_70161_v;
            if (part.field_70163_u < this.field_70163_u && this.field_70170_p.func_184143_b(part.func_174813_aQ())) {
                part.func_70091_d(MoverType.SELF, 0.0, 0.1, 0.0);
                part.field_70181_x = 0.0;
            }
            part.func_70091_d(MoverType.SELF, 0.0, part.field_70181_x, 0.0);
            part.field_70181_x -= 0.08;
            part.field_70181_x *= 0.98 * (double)this.getTailMotionYMultiplier();
        }
        for (int i = 1; i < this.parts.length; ++i) {
            this.movePiecePos(this.parts[i], this.parts[i - 1], 4.5f, 2.0f);
        }
    }

    protected double getMaxPieceDistance() {
        return 0.3;
    }

    public void movePiecePos(MultiPartEntityPart targetPart, MultiPartEntityPart destinationPart, float speed, float yawSpeed) {
        Vec3d diff;
        double len;
        if (destinationPart.field_70163_u - targetPart.field_70163_u < -0.5) {
            speed = 1.5f;
        }
        double movementTolerance = 0.05;
        double maxDist = this.getMaxPieceDistance();
        boolean correctY = false;
        for (int i = 0; i < 5; ++i) {
            Vec3d diff2 = destinationPart.func_174791_d().func_178788_d(targetPart.func_174791_d());
            double len2 = diff2.func_72433_c();
            if (!(len2 > maxDist)) continue;
            Vec3d correction = diff2.func_186678_a(1.0 / len2 * (len2 - maxDist));
            targetPart.field_70165_t += correction.field_72450_a;
            targetPart.field_70161_v += correction.field_72449_c;
            targetPart.func_70107_b(targetPart.field_70165_t, targetPart.field_70163_u, targetPart.field_70161_v);
            double cy = targetPart.field_70163_u;
            targetPart.func_70091_d(MoverType.SELF, 0.0, correction.field_72448_b, 0.0);
            if (!(Math.abs(targetPart.field_70163_u - cy - correction.field_72448_b) <= movementTolerance)) continue;
            correctY = true;
            break;
        }
        if (!correctY && (len = (diff = destinationPart.func_174791_d().func_178788_d(targetPart.func_174791_d())).func_189985_c()) > maxDist) {
            Vec3d correction = diff.func_186678_a(1.0 / len * (len - maxDist));
            targetPart.field_70165_t += correction.field_72450_a;
            targetPart.field_70163_u += correction.field_72448_b;
            targetPart.field_70161_v += correction.field_72449_c;
        }
        diff = new Vec3d(destinationPart.field_70165_t, 0.0, destinationPart.field_70161_v).func_178788_d(new Vec3d(targetPart.field_70165_t, 0.0, targetPart.field_70161_v));
        float destYaw = (float)Math.toDegrees(Math.atan2(diff.field_72449_c, diff.field_72450_a)) - 90.0f;
        double yawDiff = (destYaw - targetPart.field_70177_z) % 360.0f;
        double yawInterpolant = 2.0 * yawDiff % 360.0 - yawDiff;
        targetPart.field_70177_z = (float)((double)targetPart.field_70177_z + yawInterpolant / (double)yawSpeed);
        targetPart.field_70125_A = 0.0f;
        targetPart.func_70107_b(targetPart.field_70165_t, targetPart.field_70163_u, targetPart.field_70161_v);
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.WORM_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.WORM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.WORM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundRegistry.WORM_LIVING, 0.5f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.renderBoundingBox;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SMALL_SLUDGE_WORM;
    }
}

