/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityTarBeast
extends EntityMob
implements IEntityBL {
    public static final IAttribute SHED_COOLDOWN_ATTRIB = new RangedAttribute(null, "bl.shedCooldown", 70.0, 10.0, 2.147483647E9).func_111117_a("Shed Cooldown");
    public static final IAttribute SHED_SPEED_ATTRIB = new RangedAttribute(null, "bl.shedSpeed", 10.0, 0.0, 2.147483647E9).func_111117_a("Shedding Speed");
    public static final IAttribute SUCK_COOLDOWN_ATTRIB = new RangedAttribute(null, "bl.suckCooldown", 400.0, 0.0, 2.147483647E9).func_111117_a("Sucking Cooldown");
    public static final IAttribute SUCK_PREPARATION_SPEED_ATTRIB = new RangedAttribute(null, "bl.suckPreparationSpeed", 40.0, 0.0, 2.147483647E9).func_111117_a("Sucking Preparation Speed");
    public static final IAttribute SUCK_LENGTH_ATTRIB = new RangedAttribute(null, "bl.suckLength", 130.0, 0.0, 2.147483647E9).func_111117_a("Sucking Length");
    private int shedCooldown = (int)SHED_COOLDOWN_ATTRIB.func_111110_b();
    private int sheddingProgress = 0;
    private int suckingCooldown = (int)SUCK_COOLDOWN_ATTRIB.func_111110_b();
    private int suckingPreparation = 0;
    private int suckingProgress = 0;
    protected static final DataParameter<Byte> SUCKING_STATE_DW = EntityDataManager.func_187226_a(EntityTarBeast.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Boolean> SHEDDING_STATE_DW = EntityDataManager.func_187226_a(EntityTarBeast.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityTarBeast(World world) {
        super(world);
        this.func_70105_a(1.25f, 2.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveToBlock((EntityCreature)this, 0.85, 32){

            protected boolean func_179488_a(World worldIn, BlockPos pos) {
                return worldIn.func_180495_p(pos).func_177230_c() == BlockRegistry.TAR;
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.85));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.85));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SUCKING_STATE_DW, (Object)0);
        this.func_184212_Q().func_187214_a(SHEDDING_STATE_DW, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SHED_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(SHED_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(SUCK_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(SUCK_PREPARATION_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(SUCK_LENGTH_ATTRIB);
    }

    public boolean func_70601_bi() {
        boolean isDifficultyValid;
        boolean bl = isDifficultyValid = this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
        if (isDifficultyValid) {
            int bz;
            int by;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int bx = MathHelper.func_76128_c((double)this.field_70165_t);
            boolean isInTar = this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(bx, by = MathHelper.func_76128_c((double)this.field_70163_u), bz = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.TAR && this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(bx - 1, by, bz)).func_177230_c() == BlockRegistry.TAR && this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(bx + 1, by, bz)).func_177230_c() == BlockRegistry.TAR && this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(bx, by, bz - 1)).func_177230_c() == BlockRegistry.TAR && this.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(bx, by, bz + 1)).func_177230_c() == BlockRegistry.TAR;
            return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && isInTar;
        }
        return false;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70641_bl() {
        return 3;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.TAR_BEAST_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.TAR_BEAST_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.TAR_BEAST_DEATH;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("shedCooldown", this.shedCooldown);
        nbt.func_74768_a("sheddingProgress", this.sheddingProgress);
        nbt.func_74757_a("sheddingState", this.isShedding());
        nbt.func_74768_a("suckingCooldown", this.suckingCooldown);
        nbt.func_74768_a("suckingPreparation", this.suckingPreparation);
        nbt.func_74768_a("suckingProgress", this.suckingProgress);
        nbt.func_74774_a("suckingState", ((Byte)this.func_184212_Q().func_187225_a(SUCKING_STATE_DW)).byteValue());
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("shedCooldown")) {
            this.shedCooldown = nbt.func_74762_e("shedCooldown");
        }
        if (nbt.func_74764_b("sheddingProgress")) {
            this.sheddingProgress = nbt.func_74762_e("sheddingProgress");
        }
        if (nbt.func_74764_b("sheddingState")) {
            this.func_184212_Q().func_187227_b(SHEDDING_STATE_DW, (Object)nbt.func_74767_n("sheddingState"));
        }
        if (nbt.func_74764_b("suckingCooldown")) {
            this.suckingCooldown = nbt.func_74762_e("suckingCooldown");
        }
        if (nbt.func_74764_b("suckingPreparation")) {
            this.suckingPreparation = nbt.func_74762_e("suckingPreparation");
        }
        if (nbt.func_74764_b("suckingProgress")) {
            this.suckingProgress = nbt.func_74762_e("suckingProgress");
        }
        if (nbt.func_74764_b("suckingState")) {
            this.func_184212_Q().func_187227_b(SUCKING_STATE_DW, (Object)nbt.func_74771_c("suckingState"));
        }
        super.func_70037_a(nbt);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundRegistry.TAR_BEAST_STEP, 1.0f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.TAR_BEAST;
    }

    public void func_70071_h_() {
        int i;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            Vec3d vec;
            float rz;
            float ry;
            float rx;
            Random rnd;
            if (this.field_70173_aa % 10 == 0) {
                this.renderParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z);
            }
            if (this.sheddingProgress > this.getSheddingSpeed()) {
                this.sheddingProgress = 0;
                for (i = 0; i < 200; ++i) {
                    rnd = this.field_70170_p.field_73012_v;
                    rx = rnd.nextFloat() * 4.0f - 2.0f;
                    ry = rnd.nextFloat() * 4.0f - 2.0f;
                    rz = rnd.nextFloat() * 4.0f - 2.0f;
                    vec = new Vec3d((double)rx, (double)ry, (double)rz);
                    vec = vec.func_72432_b();
                    BLParticles.SPLASH_TAR.spawn(this.field_70170_p, this.field_70165_t + (double)rx + 0.25, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + 0.25, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * 0.5, vec.field_72448_b * 0.5, vec.field_72449_c * 0.5));
                }
            } else {
                this.sheddingProgress = this.isShedding() || this.sheddingProgress > 0 ? ++this.sheddingProgress : 0;
            }
            if (this.isSucking()) {
                for (i = 0; i < 5; ++i) {
                    rnd = this.field_70170_p.field_73012_v;
                    rx = rnd.nextFloat() * 8.0f - 4.0f;
                    ry = rnd.nextFloat() * 8.0f - 4.0f;
                    rz = rnd.nextFloat() * 8.0f - 4.0f;
                    vec = new Vec3d((double)rx, (double)ry, (double)rz);
                    vec = vec.func_72432_b();
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)rx + 0.25, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + 0.25, -vec.field_72450_a * 0.5, -vec.field_72448_b * 0.5, -vec.field_72449_c * 0.5, new int[0]);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70138_W = this.func_70055_a(BLMaterialRegistry.TAR) ? 2.0f : 0.75f;
            if (this.shedCooldown > 0 && this.func_70638_az() != null) {
                --this.shedCooldown;
            }
            if (!this.isSucking() && !this.isPreparing()) {
                if (this.shedCooldown == 0 && this.func_70638_az() != null && (double)this.func_70638_az().func_70032_d((Entity)this) < 6.0 && this.func_70685_l((Entity)this.func_70638_az())) {
                    this.setShedding(true);
                    this.shedCooldown = this.getSheddingCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getSheddingCooldown() / 2);
                }
                if (this.sheddingProgress > this.getSheddingSpeed()) {
                    this.func_184185_a(SoundRegistry.TAR_BEAST_LIVING, 1.0f, (this.field_70146_Z.nextFloat() * 0.2f + 1.0f) * 0.6f);
                    for (i = 0; i < 8; ++i) {
                        this.func_184185_a(SoundRegistry.TAR_BEAST_STEP, 1.0f, (this.field_70146_Z.nextFloat() * 0.4f + 0.8f) * 0.8f);
                    }
                    this.sheddingProgress = 0;
                    this.setShedding(false);
                    if (this.func_70638_az() != null) {
                        List affectedEntities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0));
                        for (EntityLivingBase e : affectedEntities) {
                            if (e == this || e.func_70032_d((Entity)this) > 6.0f || !e.func_70685_l((Entity)this) || e instanceof EntityTarBeast || e instanceof EntityPlayer && ((EntityPlayer)e).func_184585_cz()) continue;
                            double dst = e.func_70032_d((Entity)this);
                            float dmg = (float)(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / dst * 7.0);
                            e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmg);
                            e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(20.0 + (1.0 - dst / 6.0) * 150.0), 1));
                        }
                    }
                }
                this.sheddingProgress = this.isShedding() ? ++this.sheddingProgress : 0;
            }
            if (this.suckingCooldown > 0 && this.func_70638_az() != null) {
                --this.suckingCooldown;
            }
            if (!this.isShedding()) {
                if (this.suckingCooldown == 0 && this.func_70638_az() != null && (double)this.func_70638_az().func_70032_d((Entity)this) <= 10.0 && this.func_70685_l((Entity)this.func_70638_az())) {
                    this.setPreparing();
                }
                if (this.isPreparing()) {
                    ++this.suckingPreparation;
                    if ((double)this.suckingPreparation > this.func_110148_a(SUCK_PREPARATION_SPEED_ATTRIB).func_111126_e()) {
                        this.suckingPreparation = 0;
                        this.setSucking(true);
                        this.suckingCooldown = this.getSuckingCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getSuckingCooldown() / 2);
                        this.func_184185_a(SoundRegistry.TAR_BEAST_SUCK, 1.0f, 1.0f);
                    }
                }
                if (this.suckingProgress > (int)this.func_110148_a(SUCK_LENGTH_ATTRIB).func_111126_e()) {
                    this.setSucking(false);
                    this.suckingProgress = 0;
                }
                if (this.isSucking()) {
                    ++this.suckingProgress;
                    List affectedEntities = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
                    for (Entity e : affectedEntities) {
                        if (e == this || e.func_70032_d((Entity)this) > 10.0f || !this.func_70685_l(e) || e instanceof EntityTarBeast) continue;
                        Vec3d vec = new Vec3d(this.field_70165_t - e.field_70165_t, this.field_70163_u - e.field_70163_u, this.field_70161_v - e.field_70161_v);
                        vec = vec.func_72432_b();
                        float dst = e.func_70032_d((Entity)this);
                        float mod = (float)Math.pow(1.0f - dst / 13.0f, 1.2);
                        if (e instanceof EntityPlayer && ((EntityPlayer)e).func_184585_cz()) {
                            mod *= 0.18f;
                        }
                        if (dst < 1.0f && e instanceof EntityLivingBase) {
                            ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 20, 3));
                            ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 3));
                            e.field_70159_w *= (double)0.008f;
                            e.field_70181_x *= (double)0.008f;
                            e.field_70179_y *= (double)0.008f;
                            if (e instanceof EntityPlayer) {
                                ((EntityPlayer)e).field_70747_aH = 0.0f;
                            }
                            if (this.field_70173_aa % 12 == 0) {
                                e.func_70097_a(DamageSource.field_76369_e, 1.0f);
                            }
                        }
                        e.field_70159_w += vec.field_72450_a * (double)0.18f * (double)mod;
                        e.field_70181_x += vec.field_72448_b * (double)0.18f * (double)mod;
                        e.field_70179_y += vec.field_72449_c * (double)0.18f * (double)mod;
                        e.field_70133_I = true;
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
                } else {
                    this.suckingProgress = 0;
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                }
            }
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.isSucking();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 3; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextInt(2) * 2 - 1;
            int motionZ = rand.nextInt(2) * 2 - 1;
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.5 + rand.nextDouble() * 0.3 - rand.nextDouble() * 0.3;
            double offSetZ = Math.cos(a) * 0.5 + rand.nextDouble() * 0.3 - rand.nextDouble() * 0.3;
            velY = ((double)rand.nextFloat() - 0.5) * 0.125;
            velZ = rand.nextFloat() * 0.5f * (float)motionZ;
            velX = rand.nextFloat() * 0.5f * (float)motionX;
            BLParticles.SPLASH_TAR.spawn(world, x, y + rand.nextDouble() * 1.9, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(velX * 0.15, velY * 0.1, velZ * 0.15));
            BLParticles.TAR_BEAST_DRIP.spawn(world, x + offSetX, y + 1.2, z + offSetZ);
        }
    }

    protected void func_82167_n(Entity e) {
        if (!this.isSucking()) {
            e.func_70108_f((Entity)this);
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && !this.isSucking();
    }

    public boolean isShedding() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHEDDING_STATE_DW);
    }

    public void setShedding(boolean shedding) {
        this.func_184212_Q().func_187227_b(SHEDDING_STATE_DW, (Object)shedding);
    }

    public int getSheddingProgress() {
        return this.sheddingProgress;
    }

    public int getSheddingCooldown() {
        return (int)this.func_110148_a(SHED_COOLDOWN_ATTRIB).func_111126_e();
    }

    public int getSheddingSpeed() {
        return (int)this.func_110148_a(SHED_SPEED_ATTRIB).func_111126_e();
    }

    public int getSuckingCooldown() {
        return (int)this.func_110148_a(SUCK_COOLDOWN_ATTRIB).func_111126_e();
    }

    public boolean isSucking() {
        return (Byte)this.func_184212_Q().func_187225_a(SUCKING_STATE_DW) == 1;
    }

    public boolean isPreparing() {
        return (Byte)this.func_184212_Q().func_187225_a(SUCKING_STATE_DW) == 2;
    }

    public void setSucking(boolean sucking) {
        this.func_184212_Q().func_187227_b(SUCKING_STATE_DW, (Object)((byte)(sucking ? 1 : 0)));
    }

    public void setPreparing() {
        this.func_184212_Q().func_187227_b(SUCKING_STATE_DW, (Object)2);
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

