/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.ai.EntityAIFlyRandomly;
import thebetweenlands.common.entity.ai.EntityAIMoveToDirect;
import thebetweenlands.common.entity.ai.EntityAITargetNonSneaking;
import thebetweenlands.common.entity.ai.EntityAIWightAttack;
import thebetweenlands.common.entity.ai.EntityAIWightBuffSwampHag;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityVolatileSoul;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.network.clientbound.MessageWightVolatileParticles;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityWight
extends EntityMob
implements IEntityBL {
    public static final IAttribute VOLATILE_HEALTH_START_ATTRIB = new RangedAttribute(null, "bl.volatileHealthStart", 1.0, 0.0, 1.0).func_111117_a("Volatile Health Percentage Start");
    public static final IAttribute VOLATILE_COOLDOWN_ATTRIB = new RangedAttribute(null, "bl.volatileCooldown", 400.0, 10.0, 2.147483647E9).func_111117_a("Volatile Cooldown");
    public static final IAttribute VOLATILE_FLIGHT_SPEED_ATTRIB = new RangedAttribute(null, "bl.volatileFlightSpeed", 0.32, 0.0, 5.0).func_111117_a("Volatile Flight Speed");
    public static final IAttribute VOLATILE_LENGTH_ATTRIB = new RangedAttribute(null, "bl.volatileLength", 600.0, 0.0, 2.147483647E9).func_111117_a("Volatile Length");
    public static final IAttribute VOLATILE_MAX_DAMAGE_ATTRIB = new RangedAttribute(null, "bl.volatileMaxDamage", 20.0, 0.0, Double.MAX_VALUE).func_111117_a("Volatile Max Damage");
    protected static final DataParameter<Boolean> HIDING_STATE_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> VOLATILE_STATE_DW = EntityDataManager.func_187226_a(EntityWight.class, (DataSerializer)DataSerializers.field_187198_h);
    protected final EntityMoveHelper flightMoveHelper;
    protected final EntityMoveHelper groundMoveHelper;
    private int hidingAnimationTicks = 0;
    private int lastHidingAnimationTicks = 0;
    private int volatileCooldownTicks = (int)VOLATILE_COOLDOWN_ATTRIB.func_111110_b() / 2 + 20;
    private int volatileTicks = 0;
    private float volatileReceivedDamage = 0.0f;
    private boolean canTurnVolatile = true;
    private boolean canTurnVolatileOnTarget = false;
    private boolean didTurnVolatileOnPlayer = false;

    public EntityWight(World world) {
        super(world);
        this.func_70105_a(0.7f, 2.2f);
        this.func_184644_a(PathNodeType.WATER, 0.2f);
        this.flightMoveHelper = new FlightMoveHelper((EntityLiving)this){

            @Override
            protected double getFlightSpeed() {
                return this.field_75648_a.func_110140_aT().func_111151_a(VOLATILE_FLIGHT_SPEED_ATTRIB).func_111126_e();
            }
        };
        this.field_70765_h = this.groundMoveHelper = new EntityMoveHelper((EntityLiving)this);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetNonSneaking((EntityCreature)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWightAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWightBuffSwampHag(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveToDirect<EntityWight>(this, this.func_110140_aT().func_111151_a(VOLATILE_FLIGHT_SPEED_ATTRIB).func_111126_e()){

            @Override
            protected Vec3d getTarget() {
                EntityLivingBase target;
                if (((EntityWight)this.entity).volatileTicks >= 20 && (target = ((EntityWight)this.entity).func_70638_az()) != null) {
                    return new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e() / 2.0, target.field_70161_v);
                }
                return null;
            }
        });
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIFlyRandomly<EntityWight>(this){

            @Override
            public boolean func_75250_a() {
                return ((EntityWight)this.entity).isVolatile() && ((EntityWight)this.entity).volatileTicks >= 20 && ((EntityWight)this.entity).func_70638_az() == null && super.func_75250_a();
            }

            @Override
            protected double getFlightSpeed() {
                return 0.1;
            }
        });
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VOLATILE_STATE_DW, (Object)false);
        this.field_70180_af.func_187214_a(HIDING_STATE_DW, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.33);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(76.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(80.0);
        this.func_110140_aT().func_111150_b(VOLATILE_HEALTH_START_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_FLIGHT_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_MAX_DAMAGE_ATTRIB);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                this.setHiding(true);
                this.canTurnVolatileOnTarget = false;
            } else {
                this.setHiding(false);
                if (this.canTurnVolatile && !this.isVolatile() && !this.func_184218_aH() && this.canPossess(this.func_70638_az()) && this.canTurnVolatileOnTarget) {
                    if (this.volatileCooldownTicks > 0) {
                        --this.volatileCooldownTicks;
                    }
                    if ((double)this.func_110143_aJ() <= (double)this.func_110138_aP() * this.func_110148_a(VOLATILE_HEALTH_START_ATTRIB).func_111126_e() && this.volatileCooldownTicks <= 0) {
                        this.setVolatile(true);
                        this.didTurnVolatileOnPlayer = true;
                        this.volatileReceivedDamage = 0.0f;
                        this.volatileCooldownTicks = this.getMaxVolatileCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getMaxVolatileCooldown()) + 20;
                        this.volatileTicks = 0;
                        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageWightVolatileParticles((Entity)this), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.WIGHT_ATTACK, SoundCategory.HOSTILE, 1.6f, 1.0f);
                    }
                } else if (this.didTurnVolatileOnPlayer && this.isVolatile() && !this.canPossess(this.func_70638_az())) {
                    this.setVolatile(false);
                    this.didTurnVolatileOnPlayer = false;
                }
            }
        }
        if (this.isVolatile()) {
            if (!this.field_70170_p.field_72995_K) {
                if ((double)this.volatileTicks < this.func_110148_a(VOLATILE_LENGTH_ATTRIB).func_111126_e()) {
                    ++this.volatileTicks;
                    if (this.volatileTicks >= 20) {
                        this.field_70145_X = true;
                    }
                } else {
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70181_x -= 0.075;
                        this.field_70143_R = 0.0f;
                        if (this.didTurnVolatileOnPlayer && this.field_70122_E) {
                            this.setVolatile(false);
                            this.didTurnVolatileOnPlayer = false;
                        }
                    }
                    this.field_70145_X = false;
                }
                if (this.volatileTicks < 20) {
                    this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.15);
                }
                if (this.func_70638_az() != null) {
                    EntityLivingBase attackTarget = this.func_70638_az();
                    if (this.func_184187_bx() == null && (double)this.func_70032_d((Entity)attackTarget) < 1.75 && this.canPossess(attackTarget)) {
                        this.func_184205_a((Entity)attackTarget, true);
                        this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers((Entity)attackTarget));
                    }
                    if (this.func_184187_bx() == null) {
                        double dy;
                        double dx = attackTarget.field_70165_t - this.field_70165_t;
                        double dz = attackTarget.field_70161_v - this.field_70161_v;
                        if (attackTarget instanceof EntityLivingBase) {
                            EntityLivingBase entitylivingbase = attackTarget;
                            dy = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
                        } else {
                            dy = (attackTarget.func_174813_aQ().field_72338_b + attackTarget.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
                        }
                        double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        float pitch = (float)(-(Math.atan2(dy, dist) * 180.0 / Math.PI));
                        this.func_70101_b(yaw, pitch);
                        this.func_70034_d(yaw);
                    } else {
                        List existingSouls;
                        this.func_70101_b(0.0f, 0.0f);
                        this.func_70034_d(0.0f);
                        if (this.field_70173_aa % 5 == 0 && this.func_70685_l((Entity)this.func_70638_az()) && !this.isWearingSkullMask(this.func_70638_az()) && (existingSouls = this.field_70170_p.func_72872_a(EntityVolatileSoul.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0))).size() < 16) {
                            EntityVolatileSoul soul = new EntityVolatileSoul(this.field_70170_p);
                            float mx = this.field_70170_p.field_73012_v.nextFloat() - 0.5f;
                            float my = this.field_70170_p.field_73012_v.nextFloat() / 2.0f;
                            float mz = this.field_70170_p.field_73012_v.nextFloat() - 0.5f;
                            Vec3d dir = new Vec3d((double)mx, (double)my, (double)mz).func_72432_b();
                            soul.setOwner(this.func_110124_au());
                            soul.func_70012_b(this.field_70165_t + dir.field_72450_a * 0.5, this.field_70163_u + dir.field_72448_b * 1.5, this.field_70161_v + dir.field_72449_c * 0.5, 0.0f, 0.0f);
                            soul.func_70186_c((double)mx * 2.0, (double)my * 2.0, (double)mz * 2.0, 1.0f, 1.0f);
                            this.field_70170_p.func_72838_d((Entity)soul);
                        }
                    }
                }
                this.field_70765_h = this.flightMoveHelper;
            }
            if (this.field_70170_p.field_72995_K && (this.func_184187_bx() == null || this.field_70173_aa % 4 == 0)) {
                this.spawnVolatileParticles();
            }
            this.func_70105_a(0.7f, 0.7f);
        } else {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70145_X = false;
                this.field_70765_h = this.groundMoveHelper;
            }
            this.func_70105_a(0.7f, 2.2f);
        }
        this.lastHidingAnimationTicks = this.hidingAnimationTicks;
        if (this.isHiding()) {
            if (this.hidingAnimationTicks < 12) {
                ++this.hidingAnimationTicks;
            }
        } else if (this.hidingAnimationTicks > 0) {
            --this.hidingAnimationTicks;
        }
        super.func_70071_h_();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.isVolatile()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.isVolatile()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.isVolatile()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_180799_ab()) {
                this.func_191958_b(strafe, up, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float f = 0.91f;
                if (this.field_70122_E) {
                    f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                float f1 = 0.16277136f / (f * f * f);
                this.func_191958_b(strafe, up, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
                f = 0.91f;
                if (this.field_70122_E) {
                    f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f;
                this.field_70181_x *= (double)f;
                this.field_70179_y *= (double)f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        boolean isCreative = source instanceof EntityDamageSourceIndirect && ((EntityDamageSourceIndirect)source).func_76346_g() instanceof EntityPlayer && ((EntityPlayer)((EntityDamageSourceIndirect)source).func_76346_g()).func_184812_l_();
        return this.isHiding() && isCreative;
    }

    public boolean func_70104_M() {
        return !this.isHiding();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.WIGHT;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isVolatile() && source == DamageSource.field_76368_d) {
            return false;
        }
        float prevHealth = this.func_110143_aJ();
        boolean ret = super.func_70097_a(source, damage);
        float dealtDamage = prevHealth - this.func_110143_aJ();
        if (this.didTurnVolatileOnPlayer && this.isVolatile() && this.func_184187_bx() != null) {
            this.volatileReceivedDamage += dealtDamage;
            if ((double)this.volatileReceivedDamage >= this.func_110148_a(VOLATILE_MAX_DAMAGE_ATTRIB).func_111126_e()) {
                this.setVolatile(false);
                this.didTurnVolatileOnPlayer = false;
            }
        }
        if (this.func_70638_az() != null && source instanceof EntityDamageSource && source.func_76346_g() == this.func_70638_az()) {
            this.canTurnVolatileOnTarget = true;
        }
        return ret;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isVolatile()) {
            return false;
        }
        if (super.func_70652_k(entity)) {
            if (entity == this.func_70638_az()) {
                this.canTurnVolatileOnTarget = true;
            }
            return true;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.WIGHT_MOAN;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.WIGHT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.WIGHT_DEATH;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("volatileState", this.isVolatile());
        nbt.func_74768_a("volatileCooldown", this.volatileCooldownTicks);
        nbt.func_74768_a("volatileTicks", this.volatileTicks);
        nbt.func_74776_a("volatileReceivedDamage", this.volatileReceivedDamage);
        nbt.func_74757_a("canTurnVolatileOnTarget", this.canTurnVolatileOnTarget);
        nbt.func_74757_a("canTurnVolatile", this.canTurnVolatile);
        nbt.func_74757_a("turnVolatileOnPlayer", this.didTurnVolatileOnPlayer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("volatileState")) {
            this.setVolatile(nbt.func_74767_n("volatileState"));
        }
        if (nbt.func_74764_b("turnVolatileOnPlayer")) {
            this.didTurnVolatileOnPlayer = nbt.func_74767_n("turnVolatileOnPlayer");
        }
        if (nbt.func_74764_b("volatileCooldown")) {
            this.volatileCooldownTicks = nbt.func_74762_e("volatileCooldown");
        }
        if (nbt.func_74764_b("volatileTicks")) {
            this.volatileTicks = nbt.func_74762_e("volatileTicks");
        }
        if (nbt.func_74764_b("volatileReceivedDamage")) {
            this.volatileReceivedDamage = nbt.func_74760_g("volatileReceivedDamage");
        }
        if (nbt.func_74764_b("canTurnVolatileOnTarget")) {
            this.canTurnVolatileOnTarget = nbt.func_74767_n("canTurnVolatileOnTarget");
        }
        if (nbt.func_74764_b("canTurnVolatile")) {
            this.canTurnVolatile = nbt.func_74767_n("canTurnVolatile");
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVolatileParticles() {
        double radius = 0.3f;
        double cx = this.field_70165_t;
        double cy = this.field_70163_u + 0.35;
        double cz = this.field_70161_v;
        for (int i = 0; i < 8; ++i) {
            double px = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double py = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double pz = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            Vec3d vec = new Vec3d(px, py, pz).func_178788_d(new Vec3d((double)0.35f, (double)0.35f, (double)0.35f)).func_72432_b();
            px = cx + vec.field_72450_a * (double)0.3f;
            py = cy + vec.field_72448_b * (double)0.3f;
            pz = cz + vec.field_72449_c * (double)0.3f;
            BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz);
        }
    }

    public boolean isHiding() {
        return (Boolean)this.func_184212_Q().func_187225_a(HIDING_STATE_DW);
    }

    public void setHiding(boolean hiding) {
        this.func_184212_Q().func_187227_b(HIDING_STATE_DW, (Object)hiding);
    }

    public float getHidingAnimation(float partialTicks) {
        return ((float)this.lastHidingAnimationTicks + (float)(this.hidingAnimationTicks - this.lastHidingAnimationTicks) * partialTicks) / 12.0f;
    }

    public boolean isVolatile() {
        return (Boolean)this.func_184212_Q().func_187225_a(VOLATILE_STATE_DW);
    }

    public void setVolatile(boolean isVolatile) {
        Entity ridingEntity;
        this.field_70180_af.func_187227_b(VOLATILE_STATE_DW, (Object)isVolatile);
        if (!isVolatile && (ridingEntity = this.func_184187_bx()) != null) {
            this.func_184210_p();
            if (!this.field_70170_p.field_72995_K) {
                this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers(ridingEntity));
            }
        }
    }

    public int getMaxVolatileCooldown() {
        return (int)this.func_110148_a(VOLATILE_COOLDOWN_ATTRIB).func_111126_e();
    }

    public boolean canPossess(EntityLivingBase entity) {
        if (entity instanceof EntitySwampHag) {
            return true;
        }
        if (entity instanceof EntityPlayer) {
            return !this.isWearingSkullMask(entity);
        }
        return false;
    }

    public boolean isWearingSkullMask(EntityLivingBase entity) {
        ItemStack helmet;
        return entity instanceof EntityPlayer && !(helmet = ((EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && helmet.func_77973_b() == ItemRegistry.SKULL_MASK;
    }

    public void setCanTurnVolatile(boolean canTurnVolatile) {
        this.canTurnVolatile = canTurnVolatile;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

