/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.item.misc.ItemGem;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;

public class AdvancementHandler {
    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == Side.SERVER && event.getEntityPlayer() instanceof EntityPlayerMP) {
            ItemStack stack = event.getItemStack();
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            AdvancementCriterionRegistry.CLICK_BLOCK.trigger(stack, (EntityPlayerMP)event.getEntityPlayer(), event.getPos(), state, event.getFace());
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player != null && !event.getWorld().field_72995_K && player instanceof EntityPlayerMP) {
            AdvancementCriterionRegistry.BREAK_BLOCK.trigger((EntityPlayerMP)player, event.getPos(), event.getState());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof EntityPlayerMP && player.field_70173_aa % 50 == 0) {
            AdvancementCriterionRegistry.HAS_ADVANCEMENT.trigger((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void onItemCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.player != null && !event.player.field_70170_p.field_72995_K && event.craftMatrix instanceof InventoryCrafting) {
            if (CircleGemHelper.getGem(event.crafting) != CircleGemType.NONE) {
                EntityPlayerMP playerMP;
                boolean hadGem = false;
                for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                    ItemStack stack = event.craftMatrix.func_70301_a(i);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemGem)) continue;
                    hadGem = true;
                    break;
                }
                if (hadGem && (playerMP = AdvancementHandler.getActivePlayer((InventoryCrafting)event.craftMatrix)) != null) {
                    AdvancementCriterionRegistry.MIDDLE_GEM_UPGRADE.trigger(playerMP);
                }
            } else if (event.crafting.func_77973_b() instanceof ICorrodible) {
                EntityPlayerMP playerMP;
                boolean hadScabyst = false;
                for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                    ItemStack stack = event.craftMatrix.func_70301_a(i);
                    if (stack.func_190926_b() || !ItemMisc.EnumItemMisc.SCABYST.isItemOf(stack)) continue;
                    hadScabyst = true;
                    break;
                }
                if (hadScabyst && (playerMP = AdvancementHandler.getActivePlayer((InventoryCrafting)event.craftMatrix)) != null) {
                    AdvancementCriterionRegistry.COAT_TOOL.trigger(playerMP);
                }
            }
        }
    }

    private static EntityPlayerMP getActivePlayer(InventoryCrafting crafting) {
        PlayerList manager;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (manager = server.func_184103_al()) != null) {
            Container container = crafting.field_70465_c;
            if (container == null) {
                return null;
            }
            for (EntityPlayerMP entityPlayerMP : manager.func_181057_v()) {
                if (entityPlayerMP.field_71070_bA != container || !container.func_75145_c((EntityPlayer)entityPlayerMP) || !container.func_75129_b((EntityPlayer)entityPlayerMP)) continue;
                return entityPlayerMP;
            }
        }
        return null;
    }
}

