/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.common.item.armor.ItemLurkerSkinArmor;
import thebetweenlands.common.item.armor.ItemSyrmoriteArmor;

public class ArmorHandler {
    private ArmorHandler() {
    }

    @SubscribeEvent
    public static void onEntityOnFire(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c) {
            float damageMultiplier = 1.0f;
            Iterable armorStacks = entityLiving.func_184193_aE();
            float reductionAmount = 0.25f;
            for (ItemStack stack : armorStacks) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSyrmoriteArmor)) continue;
                damageMultiplier -= reductionAmount;
            }
            if (damageMultiplier < 0.001f) {
                event.setAmount(0.01f);
                entityLiving.func_70066_B();
            } else {
                event.setAmount(event.getAmount() * damageMultiplier);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        IBlockState blockState;
        boolean fullyInWater;
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_70090_H() && (fullyInWater = (blockState = player.field_70170_p.func_180495_p(new BlockPos(player.field_70165_t, player.func_174813_aQ().field_72337_e + 0.1, player.field_70161_v))).func_185904_a().func_76224_d())) {
            NonNullList armor = player.field_71071_by.field_70460_b;
            int pieces = 0;
            for (int i = 0; i < armor.size(); ++i) {
                if (((ItemStack)armor.get(i)).func_190926_b() || !(((ItemStack)armor.get(i)).func_77973_b() instanceof ItemLurkerSkinArmor)) continue;
                ++pieces;
            }
            if (pieces != 0) {
                event.setNewSpeed(event.getNewSpeed() * (5.0f * (player.field_70122_E ? 1.0f : 5.0f) / 4.0f * (float)pieces));
            }
        }
    }
}

