/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.render.model.armor.ModelAncientArmor;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.armor.ItemBLArmor;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemAncientArmor
extends ItemBLArmor {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/armor/ancient.png");
    public static final ResourceLocation TEXTURE_AQUA = new ResourceLocation("thebetweenlands", "textures/armor/ancient_aqua.png");
    public static final ResourceLocation TEXTURE_CRIMSON = new ResourceLocation("thebetweenlands", "textures/armor/ancient_crimson.png");
    public static final ResourceLocation TEXTURE_GREEN = new ResourceLocation("thebetweenlands", "textures/armor/ancient_green.png");
    @SideOnly(value=Side.CLIENT)
    private static ModelAncientArmor model;

    public ItemAncientArmor(EntityEquipmentSlot slot) {
        super(BLMaterialRegistry.ARMOR_ANCIENT, 3, slot, "ancient");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.ancient_armor.usage", (Object[])new Object[0]), 0));
        if (stack.func_77952_i() == stack.func_77958_k()) {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.tool.broken", (Object[])new Object[]{stack.func_82833_r()}), 0));
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        CircleGemType gem = CircleGemHelper.getGem(stack);
        switch (gem) {
            case AQUA: {
                return TEXTURE_AQUA.toString();
            }
            case CRIMSON: {
                return TEXTURE_CRIMSON.toString();
            }
            case GREEN: {
                return TEXTURE_GREEN.toString();
            }
        }
        return TEXTURE.toString();
    }

    public int func_82814_b(ItemStack itemStack) {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped defaultModel) {
        if (model == null) {
            model = new ModelAncientArmor();
        }
        model.setVisibilities(armorSlot);
        return model;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage > maxDamage) {
            damage = maxDamage;
        }
        super.setDamage(stack, damage);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (stack.func_77952_i() == stack.func_77958_k()) {
            return HashMultimap.create();
        }
        return super.func_111205_h(slot);
    }

    @SubscribeEvent
    public static void onEntityMagicDamage(LivingHurtEvent event) {
        if (event.getSource().func_82725_o()) {
            float damage = 1.0f;
            EntityLivingBase entityHit = event.getEntityLiving();
            ItemStack boots = entityHit.func_184582_a(EntityEquipmentSlot.FEET);
            ItemStack legs = entityHit.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack chest = entityHit.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack helm = entityHit.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!boots.func_190926_b() && boots.func_77973_b() == ItemRegistry.ANCIENT_BOOTS && boots.func_77952_i() < boots.func_77958_k()) {
                damage = (float)((double)damage - 0.125);
            }
            if (!legs.func_190926_b() && legs.func_77973_b() == ItemRegistry.ANCIENT_LEGGINGS && legs.func_77952_i() < legs.func_77958_k()) {
                damage = (float)((double)damage - 0.125);
            }
            if (!chest.func_190926_b() && chest.func_77973_b() == ItemRegistry.ANCIENT_CHESTPLATE && chest.func_77952_i() < chest.func_77958_k()) {
                damage = (float)((double)damage - 0.125);
            }
            if (!helm.func_190926_b() && helm.func_77973_b() == ItemRegistry.ANCIENT_HELMET && helm.func_77952_i() < helm.func_77958_k()) {
                damage = (float)((double)damage - 0.125);
            }
            event.setAmount(event.getAmount() * damage);
        }
    }
}

