/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.armor.ItemBLArmor;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemLurkerSkinArmor
extends ItemBLArmor {
    public ItemLurkerSkinArmor(EntityEquipmentSlot slot) {
        super(BLMaterialRegistry.ARMOR_LURKER_SKIN, 3, slot, "lurker_skin");
        this.setGemArmorTextureOverride(CircleGemType.AQUA, "lurker_skin_aqua");
        this.setGemArmorTextureOverride(CircleGemType.CRIMSON, "lurker_skin_crimson");
        this.setGemArmorTextureOverride(CircleGemType.GREEN, "lurker_skin_green");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!player.func_175149_v()) {
            NonNullList armor = player.field_71071_by.field_70460_b;
            int armorPieces = 0;
            for (ItemStack anArmor : armor) {
                if (anArmor == null || !(anArmor.func_77973_b() instanceof ItemLurkerSkinArmor)) continue;
                ++armorPieces;
            }
            if (itemStack.func_77973_b() == ItemRegistry.LURKER_SKIN_BOOTS && player.func_70090_H()) {
                IBlockState blockState = player.field_70170_p.func_180495_p(new BlockPos(player.field_70165_t, player.func_174813_aQ().field_72337_e + 0.1, player.field_70161_v));
                boolean fullyInWater = blockState.func_185904_a().func_76224_d();
                if (fullyInWater) {
                    if (!player.func_70093_af() && player.field_191988_bg == 0.0f) {
                        player.field_70181_x = Math.sin((float)player.field_70173_aa / 5.0f) * 0.016;
                    }
                    if (player.field_191988_bg != 0.0f) {
                        if (player.field_191988_bg > 0.0f) {
                            Vec3d lookVec = player.func_70040_Z().func_72432_b();
                            double speed = 0.01 + 0.0125 * (double)armorPieces;
                            player.field_70159_w += lookVec.field_72450_a * (double)player.field_191988_bg * speed;
                            player.field_70179_y += lookVec.field_72449_c * (double)player.field_191988_bg * speed;
                            player.field_70181_x += lookVec.field_72448_b * (double)player.field_191988_bg * speed;
                            player.func_71024_bL().func_75113_a(0.0024f);
                        }
                        player.field_70181_x += 0.02;
                    }
                }
                if (armorPieces >= 4) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 10));
                    if (player.field_70173_aa % 3 == 0) {
                        player.func_70050_g(player.func_70086_ai() - 1);
                    }
                    if (player.func_70086_ai() <= -20) {
                        player.func_70050_g(0);
                        for (int i = 0; i < 8; ++i) {
                            Random rand = world.field_73012_v;
                            float rx = rand.nextFloat() - rand.nextFloat();
                            float ry = rand.nextFloat() - rand.nextFloat();
                            float rz = rand.nextFloat() - rand.nextFloat();
                            player.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, player.field_70165_t + (double)rx, player.field_70163_u + (double)ry, player.field_70161_v + (double)rz, player.field_70159_w, player.field_70181_x, player.field_70179_y, new int[0]);
                        }
                        player.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                }
            }
        }
    }
}

