/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.food;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IFoodSicknessCapability;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.item.food.ItemBLFood;
import thebetweenlands.common.network.clientbound.MessageShowFoodSicknessLine;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.TranslationHelper;

public class ItemChiromawWing
extends ItemBLFood {
    public ItemChiromawWing() {
        super(0, 0.0f, false);
        this.func_77637_a(BLCreativeTabs.ITEMS);
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        super.func_77849_c(stack, world, player);
        IFoodSicknessCapability cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null);
        if (!world.field_72995_K && cap != null) {
            if (FoodSickness.getSicknessForHatred(cap.getFoodHatred((Item)this)) != FoodSickness.SICK) {
                cap.increaseFoodHatred((Item)this, FoodSickness.SICK.maxHatred, FoodSickness.SICK.maxHatred);
                if (player instanceof EntityPlayerMP) {
                    TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageShowFoodSicknessLine(stack, FoodSickness.SICK), (EntityPlayerMP)player);
                }
            } else {
                player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 600, 2));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        IFoodSicknessCapability cap;
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player != null && (cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null)) != null) {
            if (FoodSickness.getSicknessForHatred(cap.getFoodHatred((Item)this)) != FoodSickness.SICK) {
                tooltip.add(TranslationHelper.translateToLocal("tooltip.bl.chiromaw_wing.eat", new Object[0]));
            } else {
                tooltip.add(TranslationHelper.translateToLocal("tooltip.bl.chiromaw_wing.dont_eat", new Object[0]));
            }
        }
    }

    @Override
    public boolean canGetSickOf(EntityPlayer player, ItemStack stack) {
        return false;
    }
}

