/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.tile.TileEntityBarrel;

public class ItemBarrel
extends ItemBlock {
    private static final String NBT_FLUID_STACK = "bl.fluidStack";

    public ItemBarrel(Block block) {
        super(block);
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77978_p() != null ? 1 : super.getItemStackLimit(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        FluidStack fluidStack = this.getFluidStack(stack);
        if (fluidStack != null) {
            tooltip.add(fluidStack.getLocalizedName() + " (" + fluidStack.amount + "mb)");
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileEntity te;
            FluidStack fluidStack = this.getFluidStack(stack);
            if (fluidStack != null && (te = world.func_175625_s(pos)) instanceof TileEntityBarrel) {
                ((TileEntityBarrel)te).fill(fluidStack, true);
            }
            return true;
        }
        return false;
    }

    public FluidStack getFluidStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(NBT_FLUID_STACK, 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(NBT_FLUID_STACK));
        }
        return null;
    }

    public ItemStack fromBarrel(TileEntityBarrel te) {
        ItemStack stack = new ItemStack((Item)this);
        IFluidTankProperties props = te.getTankProperties()[0];
        FluidStack fluidStack = props.getContents();
        if (fluidStack != null && fluidStack.amount > 0) {
            stack.func_77983_a(NBT_FLUID_STACK, (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
        return stack;
    }
}

